package ru.foodtechlab.lib.auth.integration.inner.authorization.mapper;

import ru.foodtechlab.lib.auth.service.domain.auth.entity.ClientInfo;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.responses.AuthorizationSessionResponse;

import java.util.Optional;

public class ClientInfoMapper {

    public static ClientInfo map(String deviceId, String ip, AuthorizationSessionResponse.ApplicationDetails applicationDetails) {
        return ClientInfo.builder()
                .deviceId(deviceId)
                .ip(ip)
                .application(Optional.ofNullable(applicationDetails)
                        .map(AuthorizationSessionResponse.ApplicationDetails::getName)
                        .orElse(null))
                .platform(Optional.ofNullable(applicationDetails)
                        .map(AuthorizationSessionResponse.ApplicationDetails::getPlatform)
                        .orElse(null))
                .versionName(Optional.ofNullable(applicationDetails)
                        .map(AuthorizationSessionResponse.ApplicationDetails::getVersionName)
                        .orElse(null))
                .build();
    }

    public static ClientInfo map(String deviceId) {
        return ClientInfo.builder()
                .deviceId(deviceId)
                .build();
    }

}
