package ru.foodtechlab.lib.auth.integration.inner.authorization.mapper;

import com.rcore.commons.mapper.DataMapper;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.service.domain.auth.usecases.InitSignUpUseCase;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.responses.ConfirmationCodeTimerResponse;
import ru.foodtechlab.lib.auth.service.facade.confirmationCode.dto.responses.ConfirmationCodeResponse;

import java.time.Instant;
import java.time.temporal.ChronoUnit;

@Component
public class ConfirmationCodeTimerResponseMapper implements DataMapper<InitSignUpUseCase.OutputValues, ConfirmationCodeTimerResponse> {

    @Override
    public ConfirmationCodeTimerResponse map(InitSignUpUseCase.OutputValues outputValues) {
        long seconds = ChronoUnit.SECONDS.between(outputValues.getConfirmationCode().getAuthSession().getExpiredAt(), Instant.now());
        return ConfirmationCodeTimerResponse.of(
                Math.abs(seconds),
                ConfirmationCodeResponse.Type.valueOf(outputValues.getConfirmationCode().getType().name())
        );
    }
}
