package ru.foodtechlab.lib.auth.integration.inner.config;

import com.rcore.commons.utils.PasswordCryptographer;
import com.rcore.commons.utils.PhoneNumberFormatter;
import com.rcore.commons.utils.PhoneNumberValidator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import ru.foodtechlab.lib.auth.service.domain.credential.aspect.CredentialPhoneNumberFormatAspect;
import ru.foodtechlab.lib.auth.service.domain.credential.port.CredentialIdGenerator;
import ru.foodtechlab.lib.auth.service.domain.credential.port.CredentialRepository;
import ru.foodtechlab.lib.auth.service.domain.credential.usecases.CheckAvailableInitCredentialsUseCase;
import ru.foodtechlab.lib.auth.service.domain.credential.usecases.FindCredentialByPhoneNumberUseCase;
import ru.foodtechlab.lib.auth.service.domain.credential.usecases.FindCredentialByUsernameUseCase;
import ru.foodtechlab.lib.auth.service.domain.credential.usecases.InitCredentialsUseCase;
import ru.foodtechlab.lib.auth.service.domain.preference.service.PersonalCodeResolver;
import ru.foodtechlab.lib.auth.service.domain.role.usecases.CreateRoleUseCase;
import ru.foodtechlab.lib.auth.service.domain.role.usecases.FindRoleByCodeUseCase;

@Configuration
public class CredentialUseCasesConfig {

    @Bean
    public InitCredentialsUseCase initCredentialsUseCase(
            CredentialRepository repository,
            CredentialIdGenerator idGenerator,
            FindRoleByCodeUseCase findRoleByCode,
            CreateRoleUseCase createRole,
            FindCredentialByPhoneNumberUseCase findCredentialByPhone,
            FindCredentialByUsernameUseCase findCredentialByUsername,
            PasswordCryptographer passwordCryptographer,
            PersonalCodeResolver personalCodeResolver,
            CheckAvailableInitCredentialsUseCase checkAvailable,
            @Value("${foodtechlab.security.secretWord}") String secretWord
    ) {
        return new InitCredentialsUseCase(
                repository,
                idGenerator,
                findRoleByCode,
                createRole,
                findCredentialByPhone,
                findCredentialByUsername,
                passwordCryptographer,
                personalCodeResolver,
                checkAvailable,
                secretWord
        );
    }

}
