package ru.foodtechlab.lib.auth.integration.inner.config;

import com.rcore.commons.utils.EmailValidator;
import com.rcore.commons.utils.PasswordCryptographer;
import com.rcore.commons.utils.PhoneNumberFormatter;
import com.rcore.commons.utils.PhoneNumberValidator;
import com.rcore.commons.utils.impl.DefaultPasswordCryptographer;
import com.rcore.commons.utils.impl.EmailValidatorImpl;
import com.rcore.domain.aspects.UseCaseExecutingAspect;
import com.rcore.domain.commons.exception.InvalidIdException;
import com.rcore.domain.commons.port.dto.SearchFilters;
import com.rcore.domain.commons.port.dto.SearchResult;
import com.rcore.domain.commons.usecase.UseCaseExecutor;
import com.rcore.domain.commons.usecase.impl.ValidatingUseCaseExecutor;
import com.rcore.domain.security.model.AccessTokenData;
import com.rcore.domain.security.port.AccessChecker;
import com.rcore.domain.security.port.CredentialIdentityService;
import com.rcore.domain.security.port.CredentialService;
import com.rcore.domain.security.port.TokenParser;
import com.rcore.event.driven.AsyncEventDispatcher;
import com.rcore.event.driven.EventDispatcher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.AuthSessionEntity;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.LoginDetails;
import ru.foodtechlab.lib.auth.service.domain.auth.port.impl.PhoneNumberFormatterWithLocaleResolver;
import ru.foodtechlab.lib.auth.service.domain.auth.port.impl.PhoneNumberValidatorWithLocaleResolver;
import ru.foodtechlab.lib.auth.service.domain.auth.usecases.authSession.DeleteAuthSessionUseCase;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.port.ConfirmationCodeGenerator;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.port.ConfirmationCodeMessageBuilder;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.port.ConfirmationCodeSender;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.port.impl.ConfirmationCodeGeneratorImpl;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.port.impl.DefaultConfirmationCodeMessageBuilder;
import ru.foodtechlab.lib.auth.service.domain.confirmationCodeSendingTask.port.ConfirmationCodeTaskBroadcaster;
import ru.foodtechlab.lib.auth.service.domain.confirmationCodeSendingTask.port.impl.ConfirmationCodeTaskBroadcasterImpl;
import ru.foodtechlab.lib.auth.service.domain.confirmationCodeSendingTask.usecases.FindPendingTasksUseCase;
import ru.foodtechlab.lib.auth.service.domain.confirmationCodeSendingTask.usecases.TransferTaskToErrorUseCase;
import ru.foodtechlab.lib.auth.service.domain.confirmationCodeSendingTask.usecases.TransferTaskToInProgressUseCase;
import ru.foodtechlab.lib.auth.service.domain.confirmationCodeSendingTask.usecases.TransferTaskToSuccessUseCase;
import ru.foodtechlab.lib.auth.service.domain.credential.entity.CredentialEntity;
import ru.foodtechlab.lib.auth.service.domain.credential.port.CredentialRepository;
import ru.foodtechlab.lib.auth.service.domain.credential.port.impl.CredentialIdentityServiceImpl;
import ru.foodtechlab.lib.auth.service.domain.credential.port.impl.CredentialServiceImpl;
import ru.foodtechlab.lib.auth.service.domain.passwordRecovery.entity.PasswordRecoveryEntity;
import ru.foodtechlab.lib.auth.service.domain.passwordRecovery.port.PasswordRecoveryIdGenerator;
import ru.foodtechlab.lib.auth.service.domain.passwordRecovery.port.PasswordRecoveryRepository;
import ru.foodtechlab.lib.auth.service.domain.preference.service.CountryCodeResolver;
import ru.foodtechlab.lib.auth.service.domain.preference.service.DefaultConfirmationCodeTypeResolver;
import ru.foodtechlab.lib.auth.service.domain.preference.service.PersonalCodeResolver;
import ru.foodtechlab.lib.auth.service.domain.preference.service.RoleResolver;
import ru.foodtechlab.lib.auth.service.domain.preference.usecase.GetServicePreferenceUseCase;
import ru.foodtechlab.lib.auth.service.domain.role.port.RoleRepository;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.port.impl.AccessCheckerImpl;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.usecase.CheckAccessByAccessTokenUseCase;
import ru.foodtechlab.lib.auth.service.domain.token.config.TokenLifeCycleConfig;
import ru.foodtechlab.lib.auth.service.domain.token.port.AccessTokenRepository;
import ru.foodtechlab.lib.auth.service.domain.token.port.TokenSaltGenerator;
import ru.foodtechlab.lib.auth.service.domain.token.port.impl.TokenSaltGeneratorImpl;
import ru.foodtechlab.rcore.spring.EnableRCoreSpring;

import javax.validation.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

@EnableRCoreSpring(basePackages = "ru.foodtechlab")
@Configuration
public class UseCaseConfig {

    @Bean
    public Function<LoginDetails, Optional<CredentialEntity>> findCredential() {
        return l -> Optional.empty();
    }

    @Bean
    public Function<DeleteAuthSessionUseCase.InputValues, List<AuthSessionEntity>> deleteAuthSessions() {
        return l -> new ArrayList<>();
    }

    @Bean
    public UseCaseExecutingAspect useCaseExecutingAspect(UseCaseExecutor useCaseExecutor) {
        return new UseCaseExecutingAspect(useCaseExecutor);
    }

    @Bean
    public ConfirmationCodeTaskBroadcaster confirmationCodeTaskBroadcaster(
            FindPendingTasksUseCase findPendingTasksUseCase,
            TransferTaskToErrorUseCase transferTaskToErrorUseCase,
            TransferTaskToInProgressUseCase transferTaskToInProgressUseCase,
            TransferTaskToSuccessUseCase transferTaskToSuccessUseCase,
            @Qualifier("smsConfirmationCodeSender")
                    ConfirmationCodeSender smsCodeSender,
            @Qualifier("emailConfirmationCodeSender")
                    ConfirmationCodeSender emailCodeSender
    ) {
        return new ConfirmationCodeTaskBroadcasterImpl(
                findPendingTasksUseCase,
                transferTaskToInProgressUseCase,
                transferTaskToSuccessUseCase,
                transferTaskToErrorUseCase,
                smsCodeSender,
                emailCodeSender
        );
    }

    @Bean
    public EventDispatcher eventDispatcher() {
        return new AsyncEventDispatcher();
    }

    @Bean
    public ConfirmationCodeMessageBuilder confirmationCodeMessageBuilder(GetServicePreferenceUseCase getServicePreferenceUseCase) {
        return new DefaultConfirmationCodeMessageBuilder(getServicePreferenceUseCase);
    }

    @Bean
    public TokenSaltGenerator tokenSaltGenerator() {
        return new TokenSaltGeneratorImpl();
    }

    @Bean
    public PasswordCryptographer passwordCryptographer() {
        return new DefaultPasswordCryptographer();
    }

    @Bean
    public ConfirmationCodeGenerator confirmationCodeGenerator() {
        return new ConfirmationCodeGeneratorImpl(4);
    }

    @Bean
    public PhoneNumberValidator phoneNumberValidator(CountryCodeResolver countryCodeResolver) {
        return new PhoneNumberValidatorWithLocaleResolver(countryCodeResolver);
    }

    @Bean
    public PhoneNumberFormatter phoneNumberFormatter(CountryCodeResolver countryCodeResolver) {
        return new PhoneNumberFormatterWithLocaleResolver(countryCodeResolver);
    }

    @Bean
    public EmailValidator emailValidator() {
        return new EmailValidatorImpl();
    }

    @Bean
    public CredentialIdentityService credentialIdentityService(
            TokenParser<AccessTokenData> accessTokenDataTokenParser,
            AccessTokenRepository accessTokenRepository,
            CredentialService credentialService
    ) {
        return new CredentialIdentityServiceImpl(accessTokenDataTokenParser, accessTokenRepository, credentialService);
    }

    @Bean
    public AccessChecker accessChecker(CheckAccessByAccessTokenUseCase checkAccessByAccessTokenUseCase, TokenParser<AccessTokenData> tokenDataTokenParser) {
        return new AccessCheckerImpl(checkAccessByAccessTokenUseCase, tokenDataTokenParser);
    }

    @Bean
    public CredentialService credentialService(CredentialRepository credentialRepository, RoleRepository roleRepository) {
        return new CredentialServiceImpl(credentialRepository, roleRepository);
    }

    @Bean
    public UseCaseExecutor useCaseExecutor(Validator validator) {
        return new ValidatingUseCaseExecutor(validator);
    }

    @Bean
    public TokenLifeCycleConfig tokenLifeCycleConfig(
            @Value("${foodtechlab.security.jwt.access-token.ttl: 600}") Long accessTokenLifetimeInSeconds,
            @Value("${foodtechlab.security.jwt.refresh-token.ttl: 31536000}") Long refreshTokenLifetimeInSeconds
    ) {
        return TokenLifeCycleConfig.of(accessTokenLifetimeInSeconds, refreshTokenLifetimeInSeconds);
    }

    @Bean
    public DefaultConfirmationCodeTypeResolver defaultConfirmationCodeTypeResolver(GetServicePreferenceUseCase getServicePreferenceUseCase) {
        return new DefaultConfirmationCodeTypeResolver(getServicePreferenceUseCase);
    }

    @Bean
    public RoleResolver roleResolver(GetServicePreferenceUseCase getServicePreferenceUseCase, RoleRepository roleRepository) {
        return new RoleResolver(getServicePreferenceUseCase, roleRepository);
    }

    @Bean
    public CountryCodeResolver isoCodeResolver(GetServicePreferenceUseCase getServicePreferenceUseCase) {
        return new CountryCodeResolver(getServicePreferenceUseCase);
    }

    @Bean
    public PersonalCodeResolver personalCodeResolver(GetServicePreferenceUseCase getServicePreferenceUseCase) {
        return new PersonalCodeResolver(getServicePreferenceUseCase);
    }

    //TODO реализовать
    @Bean
    public PasswordRecoveryIdGenerator<String> passwordRecoveryIdGenerator() {
        return new PasswordRecoveryIdGenerator<String>() {
            @Override
            public String generate() {
                return null;
            }

            @Override
            public String parse(String id) throws InvalidIdException {
                return null;
            }
        };
    }

    //TODO реализовать
    @Bean
    public PasswordRecoveryRepository passwordRecoveryRepository() {
        return new PasswordRecoveryRepository() {
            @Override
            public PasswordRecoveryEntity save(PasswordRecoveryEntity entity) {
                return null;
            }

            @Override
            public Boolean delete(String s) {
                return null;
            }

            @Override
            public Optional<PasswordRecoveryEntity> findById(String s) {
                return Optional.empty();
            }

            @Override
            public SearchResult<PasswordRecoveryEntity> find(SearchFilters filters) {
                return null;
            }

            @Override
            public boolean exist(String s) {
                return false;
            }

            @Override
            public Long count() {
                return null;
            }
        };
    }
}
