package ru.foodtechlab.lib.auth.integration.inner.confirmationCode.mapper;

import com.rcore.commons.mapper.DataMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.inner.authSessions.mapper.AuthorizationSessionResponseMapper;
import ru.foodtechlab.lib.auth.service.domain.confirmationCode.entity.ConfirmationCodeEntity;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.responses.AuthorizationSessionResponse;
import ru.foodtechlab.lib.auth.service.facade.confirmationCode.dto.responses.ConfirmationCodeResponse;

import java.util.Optional;

@RequiredArgsConstructor
@Component
public class ConfirmationCodeMapper implements DataMapper<ConfirmationCodeEntity, ConfirmationCodeResponse> {

    private final AuthorizationSessionResponseMapper authorizationSessionResponseMapper;

    @Override
    public ConfirmationCodeResponse map(ConfirmationCodeEntity entity) {
        var authSession = Optional.ofNullable(entity.getAuthSession()).map(authorizationSessionResponseMapper::map);
        return ConfirmationCodeResponse.builder()
                .id(entity.getId())
                .code(entity.getCode())
                .confirmationDate(entity.getConfirmationAt())
                .authSession(authSession.orElse(null))
                .confirmationStatus(ConfirmationCodeResponse.ConfirmationStatus.valueOf(entity.getConfirmationStatus().name()))
                .message(entity.getMessage())
                .header(entity.getHeader())
                .confirmationCodeDestinationType(Optional.ofNullable(entity.getConfirmationCodeDestinationType())
                        .map(c -> ConfirmationCodeResponse.ConfirmationCodeDestinationType.valueOf(c.name()))
                        .orElse(null))
                .confirmationDate(entity.getConfirmationAt())
                .email(authSession.map(AuthorizationSessionResponse::getEmail).orElse(null))
                .phoneNumber(authSession.map(AuthorizationSessionResponse::getPhoneNumber).orElse(null))
                .ttl(authSession.map(AuthorizationSessionResponse::getTtl).orElse(null))
                .webhookProviderUrl(entity.getWebhookProviderUrl())
                .isDeleted(entity.isDeleted())
                .loginType(authSession.map(AuthorizationSessionResponse::getLoginType).orElse(null))
                .createdAt(entity.getCreatedAt())
                .updatedAt(entity.getUpdatedAt())
                .expiredAt(entity.getAuthSession().getExpiredAt())
                .build();
    }
}
