package ru.foodtechlab.lib.auth.integration.inner.credential.mapper;

import com.rcore.commons.mapper.DataMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.inner.role.mapper.RoleResponseMapper;
import ru.foodtechlab.lib.auth.service.domain.credential.entity.CredentialEntity;
import ru.foodtechlab.lib.auth.service.facade.confirmationCode.dto.responses.ConfirmationCodeResponse;
import ru.foodtechlab.lib.auth.service.facade.credential.dto.responses.CredentialResponse;

import java.util.Optional;
import java.util.stream.Collectors;

@RequiredArgsConstructor
@Component
public class CredentialResponseMapper implements DataMapper<CredentialEntity, CredentialResponse> {

    private final RoleResponseMapper roleResponseMapper;

    @Override
    public CredentialResponse map(CredentialEntity entity) {
        return CredentialResponse.builder()
                .id(entity.getId())
                .createdAt(entity.getCreatedAt())
                .updatedAt(entity.getUpdatedAt())
                .email(Optional.ofNullable(entity.getEmail())
                        .map(e -> new CredentialResponse.Email(e.getValue(), e.isConfirmed()))
                        .orElse(null))
                .phoneNumber(Optional.ofNullable(entity.getPhoneNumber())
                        .map(p -> new CredentialResponse.PhoneNumber(p.getValue(), p.getIsoTwoLetterCountryCode(), p.isConfirmed()))
                        .orElse(null))
                .username(entity.getUsername())
                .roles(Optional.ofNullable(entity.getRoles())
                        .map(role -> role.stream()
                                .map(r -> CredentialResponse.Role.builder()
                                        .isBlocked(r.isBlocked())
                                        .role(Optional.ofNullable(r.getRole()).map(roleResponseMapper::map).orElse(null))
                                        .build())
                                .collect(Collectors.toList()))
                        .orElse(null))
                .confirmationCodeDestinationType(Optional.ofNullable(entity.getConfirmationCodeDestinationType())
                        .map(c -> ConfirmationCodeResponse.ConfirmationCodeDestinationType.valueOf(c.name()))
                        .orElse(null))
                .confirmationCodeType(Optional.ofNullable(entity.getConfirmationCodeType())
                        .map(c -> ConfirmationCodeResponse.Type.valueOf(c.name()))
                        .orElse(null))
                .isBlocked(entity.isBlocked())
                .isDeleted(entity.isDeleted())
                .build();
    }
}
