package ru.foodtechlab.lib.auth.integration.inner.preference;

import com.rcore.domain.commons.usecase.model.VoidInputValues;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.core.preference.ServicePreferenceFacade;
import ru.foodtechlab.lib.auth.integration.inner.preference.mapper.ServicePreferenceResponseMapper;
import ru.foodtechlab.lib.auth.integration.inner.preference.mapper.UpdateServicePreferencesRequestMapper;
import ru.foodtechlab.lib.auth.service.domain.preference.usecase.GetServicePreferenceUseCase;
import ru.foodtechlab.lib.auth.service.domain.preference.usecase.UpdateServicePreferenceUseCase;
import ru.foodtechlab.lib.auth.service.facade.preference.dto.requests.UpdateServicePreferenceRequest;
import ru.foodtechlab.lib.auth.service.facade.preference.dto.responses.ServicePreferenceResponse;

@RequiredArgsConstructor
@Component
public class InnerServicePreferenceServiceFacade implements ServicePreferenceFacade {

    private final ServicePreferenceResponseMapper mapper;
    private final UpdateServicePreferencesRequestMapper requestMapper;
    private final GetServicePreferenceUseCase getServicePreferenceUseCase;
    private final UpdateServicePreferenceUseCase updateServicePreferenceUseCase;

    @Override
    public ServicePreferenceResponse get() {
        var result = getServicePreferenceUseCase.execute(new VoidInputValues());
        return mapper.map(result.getValue());
    }

    @Override
    public ServicePreferenceResponse update(UpdateServicePreferenceRequest command) {
        var result = updateServicePreferenceUseCase.execute(requestMapper.map(command));
        return mapper.map(result.getEntity());
    }
}
