package ru.foodtechlab.lib.auth.integration.inner.role.mapper;

import com.rcore.commons.mapper.DataMapper;
import com.rcore.rest.api.commons.response.BaseAdminResponse;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.inner.roleAccess.mapper.RoleAccessResponseMapper;
import ru.foodtechlab.lib.auth.service.domain.role.entity.RoleEntity;
import ru.foodtechlab.lib.auth.service.facade.role.dto.responses.RoleResponse;

import java.util.Optional;
import java.util.stream.Collectors;

@RequiredArgsConstructor
@Component
public class RoleResponseMapper implements DataMapper<RoleEntity, RoleResponse> {

    private final RoleAccessResponseMapper roleAccessResponseMapper;

    @Override
    public RoleResponse map(RoleEntity roleEntity) {
        return BaseAdminResponse.fill(RoleResponse.builder(), roleEntity)
                .code(roleEntity.getCode())
                .name(roleEntity.getName())
                .accesses(Optional.ofNullable(roleEntity.getAccesses())
                        .map(r -> r.stream().map(roleAccessResponseMapper::map).collect(Collectors.toList()))
                        .orElse(null))
                .isDeleted(roleEntity.isDeleted())
                .isRegistrationAllowed(roleEntity.isRegistrationAllowed())
                .build();
    }
}
