package ru.foodtechlab.lib.auth.integration.inner.roleAccess;

import com.rcore.domain.security.model.CredentialDetails;
import com.rcore.domain.security.port.CredentialIdentityService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.core.roleAccess.CheckAccessServiceFacade;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.entity.RoleAccessEntity;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.usecase.CheckAccessByAccessTokenUseCase;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.requests.CheckAccessByTokenRequest;

import java.util.Optional;

@RequiredArgsConstructor
@Component
public class InnerCheckAccessServiceFacade implements CheckAccessServiceFacade {
    private final CredentialIdentityService credentialIdentityService;
    private final CheckAccessByAccessTokenUseCase checkAccessByAccessTokenUseCase;

    @Override
    public CredentialDetails checkAccess(CheckAccessByTokenRequest command) {
        return checkAccessByAccessTokenUseCase.execute(
                CheckAccessByAccessTokenUseCase.InputValues.builder()
                        .accessToken(command.getAccessToken())
                        .requestPath(command.getPath())
                        .serviceName(command.getServiceName())
                        .method(Optional.ofNullable(command.getMethod())
                                .map(r -> RoleAccessEntity.Method.valueOf(r.name()))
                                .orElse(null))
                        .build())
                .getValue();
    }

    @Override
    public Boolean tokenIsValid(String token) {
        credentialIdentityService.getCredentialByToken(token);
        return true;
    }
}
