package ru.foodtechlab.lib.auth.integration.inner.roleAccess.mapper;

import com.rcore.commons.mapper.DataMapper;
import com.rcore.rest.api.commons.response.BaseAdminResponse;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.service.domain.roleAccess.entity.RoleAccessEntity;
import ru.foodtechlab.lib.auth.service.facade.roleAccess.dto.responses.RoleAccessResponse;

import java.util.Optional;

@RequiredArgsConstructor
@Component
public class RoleAccessResponseMapper implements DataMapper<RoleAccessEntity, RoleAccessResponse> {

    @Override
    public RoleAccessResponse map(RoleAccessEntity entity) {
        return BaseAdminResponse.fill(RoleAccessResponse.builder(), entity)
                .isDeleted(entity.isDeleted())
                .requestPathPattern(entity.getRequestPathPattern())
                .method(Optional.ofNullable(entity.getMethod()).map(r -> RoleAccessResponse.Method.valueOf(r.name())).orElse(null))
                .serviceName(entity.getServiceName())
                .build();
    }
}
