package ru.foodtechlab.lib.auth.integration.inner.token.mapper;

import com.rcore.commons.mapper.DataMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.inner.credential.mapper.CredentialResponseMapper;
import ru.foodtechlab.lib.auth.service.domain.token.entity.AccessTokenEntity;
import ru.foodtechlab.lib.auth.service.facade.accessToken.dto.responses.AccessTokenResponse;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.dto.responses.RefreshTokenResponse;

import java.util.Optional;

@RequiredArgsConstructor
@Component
public class AccessTokenResponseMapper implements DataMapper<AccessTokenEntity, AccessTokenResponse> {

    private final RefreshTokenResponseMapper refreshTokenResponseMapper;
    private final CredentialResponseMapper credentialResponseMapper;

    @Override
    public AccessTokenResponse map(AccessTokenEntity accessTokenEntity) {
        return AccessTokenResponse.builder()
                .createByRefreshToken(Optional.ofNullable(accessTokenEntity.getCreateByRefreshToken())
                        .map(refreshTokenResponseMapper::map)
                        .orElse(null))
                .createdAt(accessTokenEntity.getCreatedAt())
                .credential(Optional.ofNullable(accessTokenEntity.getCredential())
                        .map(credentialResponseMapper::map)
                        .orElse(null))
                .expireAt(accessTokenEntity.getExpireAt())
                .ttl(accessTokenEntity.getTtl())
                .id(accessTokenEntity.getId())
                .status(Optional.ofNullable(accessTokenEntity.getStatus())
                        .map(s -> RefreshTokenResponse.Status.valueOf(s.name()))
                        .orElse(null))
                .updatedAt(accessTokenEntity.getUpdatedAt())
                .build();
    }
}
