package ru.foodtechlab.lib.auth.integration.inner.token.mapper;

import com.rcore.commons.mapper.DataMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.inner.credential.mapper.CredentialResponseMapper;
import ru.foodtechlab.lib.auth.service.domain.token.entity.RefreshTokenEntity;
import ru.foodtechlab.lib.auth.service.facade.refreshToken.dto.responses.RefreshTokenResponse;

import java.util.Optional;

@RequiredArgsConstructor
@Component
public class RefreshTokenResponseMapper implements DataMapper<RefreshTokenEntity, RefreshTokenResponse> {

    private final CredentialResponseMapper credentialResponseMapper;

    @Override
    public RefreshTokenResponse map(RefreshTokenEntity refreshTokenEntity) {
        return RefreshTokenResponse.builder()
                .createdAt(refreshTokenEntity.getCreatedAt())
                .credential(Optional.ofNullable(refreshTokenEntity.getCredential())
                        .map(credentialResponseMapper::map)
                        .orElse(null))
                .expireAt(refreshTokenEntity.getExpireAt())
                .id(refreshTokenEntity.getId())
                .ttl(refreshTokenEntity.getTtl())
                .createFromType(Optional.ofNullable(refreshTokenEntity.getCreateFromType())
                        .map(r -> RefreshTokenResponse.CreateFrom.valueOf(r.name()))
                        .orElse(null))
                .createFromTokenId(Optional.ofNullable(refreshTokenEntity.getCreateFromToken())
                        .map(RefreshTokenEntity::getId)
                        .orElse(null))
                .status(Optional.ofNullable(refreshTokenEntity.getStatus())
                        .map(s -> RefreshTokenResponse.Status.valueOf(s.name()))
                        .orElse(null))
                .updatedAt(refreshTokenEntity.getUpdatedAt())
                .build();
    }
}
