/*
 * Decompiled with CFR 0.152.
 */
package io.fsq.exceptionator.actions.concrete;

import com.twitter.finagle.Service;
import com.twitter.logging.Logger;
import com.twitter.ostrich.stats.Stats$;
import com.twitter.util.ExecutorServiceFuturePool;
import com.twitter.util.Future;
import com.twitter.util.FuturePool$;
import com.typesafe.config.Config;
import io.fsq.common.logging.Logger;
import io.fsq.exceptionator.actions.BucketActions;
import io.fsq.exceptionator.actions.HasBucketActions;
import io.fsq.exceptionator.actions.HasHistoryActions;
import io.fsq.exceptionator.actions.HasNoticeActions;
import io.fsq.exceptionator.actions.IncomingActions;
import io.fsq.exceptionator.actions.SaveResult;
import io.fsq.exceptionator.actions.concrete.ConcreteIncomingActions$;
import io.fsq.exceptionator.actions.concrete.ConcreteIncomingActions$$anonfun$doMaintenance$1$;
import io.fsq.exceptionator.filter.BucketSpec;
import io.fsq.exceptionator.filter.FilteredIncoming;
import io.fsq.exceptionator.filter.ProcessedIncoming;
import io.fsq.exceptionator.filter.concrete.FreshBucketFilter$;
import io.fsq.exceptionator.model.NoticeRecord;
import io.fsq.exceptionator.model.io.BucketId;
import io.fsq.exceptionator.model.io.BucketId$;
import io.fsq.exceptionator.util.Config$;
import java.util.concurrent.Executors;
import org.bson.types.ObjectId;
import org.joda.time.DateTime;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u0001\u0003\u00015\u0011qcQ8oGJ,G/Z%oG>l\u0017N\\4BGRLwN\\:\u000b\u0005\r!\u0011\u0001C2p]\u000e\u0014X\r^3\u000b\u0005\u00151\u0011aB1di&|gn\u001d\u0006\u0003\u000f!\tQ\"\u001a=dKB$\u0018n\u001c8bi>\u0014(BA\u0005\u000b\u0003\r17/\u001d\u0006\u0002\u0017\u0005\u0011\u0011n\\\u0002\u0001'\u0011\u0001a\"I\u0013\u0011\t=1\u0002DH\u0007\u0002!)\u0011\u0011CE\u0001\bM&t\u0017m\u001a7f\u0015\t\u0019B#A\u0004uo&$H/\u001a:\u000b\u0003U\t1aY8n\u0013\t9\u0002CA\u0004TKJ4\u0018nY3\u0011\u0005eaR\"\u0001\u000e\u000b\u0005m1\u0011A\u00024jYR,'/\u0003\u0002\u001e5\t\u0001b)\u001b7uKJ,G-\u00138d_6Lgn\u001a\t\u00033}I!\u0001\t\u000e\u0003#A\u0013xnY3tg\u0016$\u0017J\\2p[&tw\r\u0005\u0002#G5\tA!\u0003\u0002%\t\ty\u0011J\\2p[&tw-Q2uS>t7\u000f\u0005\u0002'W5\tqE\u0003\u0002)S\u00059An\\4hS:<'B\u0001\u0016\t\u0003\u0019\u0019w.\\7p]&\u0011Af\n\u0002\u0007\u0019><w-\u001a:\t\u00119\u0002!\u0011!Q\u0001\n=\n\u0001b]3sm&\u001cWm\u001d\n\u0005aI*\u0004H\u0002\u00032\u0001\u0001y#\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004C\u0001\u00124\u0013\t!DA\u0001\tICN\u0014UoY6fi\u0006\u001bG/[8ogB\u0011!EN\u0005\u0003o\u0011\u0011\u0011\u0003S1t\u0011&\u001cHo\u001c:z\u0003\u000e$\u0018n\u001c8t!\t\u0011\u0013(\u0003\u0002;\t\t\u0001\u0002*Y:O_RL7-Z!di&|gn\u001d\u0005\u0006y\u0001!\t!P\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005y\u0002\u0005CA \u0001\u001b\u0005\u0011\u0001\"\u0002\u0018<\u0001\u0004\t%\u0003\u0002\"3ka2A!\r\u0001\u0001\u0003\"9A\t\u0001b\u0001\n\u0003)\u0015AD:bm\u00164U\u000f^;sKB{w\u000e\\\u000b\u0002\rB\u0011qIS\u0007\u0002\u0011*\u0011\u0011JE\u0001\u0005kRLG.\u0003\u0002L\u0011\nIR\t_3dkR|'oU3sm&\u001cWMR;ukJ,\u0007k\\8m\u0011\u0019i\u0005\u0001)A\u0005\r\u0006y1/\u0019<f\rV$XO]3Q_>d\u0007\u0005C\u0004P\u0001\t\u0007I\u0011\u0001)\u0002\u0017\t,8m[3u'B,7m]\u000b\u0002#B!!+W.d\u001b\u0005\u0019&B\u0001+V\u0003\u001diW\u000f^1cY\u0016T!AV,\u0002\u0015\r|G\u000e\\3di&|gNC\u0001Y\u0003\u0015\u00198-\u00197b\u0013\tQ6KA\u0002NCB\u0004\"\u0001\u00181\u000f\u0005usV\"A,\n\u0005};\u0016A\u0002)sK\u0012,g-\u0003\u0002bE\n11\u000b\u001e:j]\u001eT!aX,\u0011\u0005e!\u0017BA3\u001b\u0005)\u0011UoY6fiN\u0003Xm\u0019\u0005\u0007O\u0002\u0001\u000b\u0011B)\u0002\u0019\t,8m[3u'B,7m\u001d\u0011\t\u000f%\u0004!\u0019!C\u0001U\u0006y\u0011N\\2p[&twMR5mi\u0016\u00148/F\u0001l!\raw.]\u0007\u0002[*\u0011a.V\u0001\nS6lW\u000f^1cY\u0016L!\u0001]7\u0003\t1K7\u000f\u001e\t\u0003e^l\u0011a\u001d\u0006\u0003iV\faaY8oM&<'B\u0001<\u0015\u0003!!\u0018\u0010]3tC\u001a,\u0017B\u0001=t\u0005\u0019\u0019uN\u001c4jO\"1!\u0010\u0001Q\u0001\n-\f\u0001#\u001b8d_6Lgn\u001a$jYR,'o\u001d\u0011\t\u000fq\u0004\u0001\u0019!C\u0001{\u0006Y1-\u001e:sK:$H+[7f+\u0005q\bCA/\u0000\u0013\r\t\ta\u0016\u0002\u0005\u0019>tw\rC\u0005\u0002\u0006\u0001\u0001\r\u0011\"\u0001\u0002\b\u0005y1-\u001e:sK:$H+[7f?\u0012*\u0017\u000f\u0006\u0003\u0002\n\u0005=\u0001cA/\u0002\f%\u0019\u0011QB,\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003#\t\u0019!!AA\u0002y\f1\u0001\u001f\u00132\u0011\u001d\t)\u0002\u0001Q!\ny\fAbY;se\u0016tG\u000fV5nK\u0002B\u0001\"!\u0007\u0001\u0001\u0004%\t!`\u0001\u0012Y\u0006\u001cH\u000fS5ti><'/Y7Ue&l\u0007\"CA\u000f\u0001\u0001\u0007I\u0011AA\u0010\u0003Ua\u0017m\u001d;ISN$xn\u001a:b[R\u0013\u0018.\\0%KF$B!!\u0003\u0002\"!I\u0011\u0011CA\u000e\u0003\u0003\u0005\rA \u0005\b\u0003K\u0001\u0001\u0015)\u0003\u007f\u0003Ia\u0017m\u001d;ISN$xn\u001a:b[R\u0013\u0018.\u001c\u0011\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,\u0005q!/Z4jgR,'OQ;dW\u0016$H\u0003BA\u0005\u0003[Aq!a\f\u0002(\u0001\u00071-\u0001\u0003ta\u0016\u001c\u0007bBA\u001a\u0001\u0011\u0005\u0011QG\u0001\u0014EV\u001c7.\u001a;Ge&,g\u000e\u001a7z\u001d\u0006lWm]\u000b\u0003\u0003o\u0001R\u0001XA\u001d7nK!A\u00172\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@\u0005)\u0011\r\u001d9msR!\u0011\u0011IA$!\u00119\u00151\t\u0010\n\u0007\u0005\u0015\u0003J\u0001\u0004GkR,(/\u001a\u0005\b\u0003\u0013\nY\u00041\u0001\u0019\u0003!IgnY8nS:<\u0007bBA'\u0001\u0011\u0005\u0011qJ\u0001\u000eI>l\u0015-\u001b8uK:\fgnY3\u0015\t\u0005%\u0011\u0011\u000b\u0005\b\u0003'\nY\u00051\u0001\u007f\u0003\rqwn\u001e\u0005\b\u0003/\u0002A\u0011AA-\u0003\u0011\u0019\u0018M^3\u0015\u0007y\tY\u0006C\u0004\u0002J\u0005U\u0003\u0019\u0001\r")
public class ConcreteIncomingActions
extends Service<FilteredIncoming, ProcessedIncoming>
implements IncomingActions,
io.fsq.common.logging.Logger {
    public final HasBucketActions io$fsq$exceptionator$actions$concrete$ConcreteIncomingActions$$services;
    private final ExecutorServiceFuturePool saveFuturePool;
    private final Map<String, BucketSpec> bucketSpecs;
    private final List<Config> incomingFilters;
    private long currentTime;
    private long lastHistogramTrim;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void io$fsq$common$logging$Logger$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ExecutorServiceFuturePool saveFuturePool() {
        return this.saveFuturePool;
    }

    public Map<String, BucketSpec> bucketSpecs() {
        return this.bucketSpecs;
    }

    public List<Config> incomingFilters() {
        return this.incomingFilters;
    }

    public long currentTime() {
        return this.currentTime;
    }

    public void currentTime_$eq(long x$1) {
        this.currentTime = x$1;
    }

    public long lastHistogramTrim() {
        return this.lastHistogramTrim;
    }

    public void lastHistogramTrim_$eq(long x$1) {
        this.lastHistogramTrim = x$1;
    }

    public void registerBucket(BucketSpec spec) {
        this.bucketSpecs().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)spec.name()), (Object)spec));
    }

    public scala.collection.immutable.Map<String, String> bucketFriendlyNames() {
        return (scala.collection.immutable.Map)this.bucketSpecs().toMap(Predef$.MODULE$.$conforms()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, BucketSpec> x0$1) {
                Tuple2<String, BucketSpec> tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    BucketSpec builder = (BucketSpec)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)builder.friendlyName());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }

    public Future<ProcessedIncoming> apply(FilteredIncoming incoming) {
        return this.saveFuturePool().apply((Function0)new Serializable(this, incoming){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConcreteIncomingActions $outer;
            private final FilteredIncoming incoming$1;

            public final ProcessedIncoming apply() {
                return this.$outer.save(this.incoming$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.incoming$1 = incoming$1;
            }
        });
    }

    public void doMaintenance(long now) {
        long histogramOldTime = BoxesRunTime.unboxToLong((Object)((HasHistoryActions)this.io$fsq$exceptionator$actions$concrete$ConcreteIncomingActions$$services).historyActions().oldestId().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(DateTime x$2) {
                return x$2.getMillis();
            }
        }).getOrElse((Function0)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final long now$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.now$1;
            }
            {
                this.now$1 = now$1;
            }
        }));
        this.io$fsq$exceptionator$actions$concrete$ConcreteIncomingActions$$services.bucketActions().deleteOldHistograms(histogramOldTime, true);
        Stats$.MODULE$.time("incomingActions.deleteOldBuckets", (Function0)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConcreteIncomingActions $outer;
            private final long now$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BucketActions qual$1 = this.$outer.io$fsq$exceptionator$actions$concrete$ConcreteIncomingActions$$services.bucketActions();
                long x$4 = this.now$1;
                int x$5 = qual$1.deleteOldBuckets$default$2();
                boolean x$6 = qual$1.deleteOldBuckets$default$3();
                List toRemove = qual$1.deleteOldBuckets(x$4, x$5, x$6);
                toRemove.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$doMaintenance$1 $outer;

                    public final void apply(SaveResult tr) {
                        tr.noticesToRemove().foreach((Function1)new Serializable(this, tr){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$doMaintenance$1$$anonfun$apply$mcV$sp$1 $outer;
                            private final SaveResult tr$1;

                            public final void apply(ObjectId n) {
                                ((HasNoticeActions)this.$outer.io$fsq$exceptionator$actions$concrete$ConcreteIncomingActions$$anonfun$$anonfun$$$outer().io$fsq$exceptionator$actions$concrete$ConcreteIncomingActions$$anonfun$$$outer().io$fsq$exceptionator$actions$concrete$ConcreteIncomingActions$$services).noticeActions().removeBucket(n, this.tr$1.bucket());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tr$1 = tr$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$doMaintenance$1 io$fsq$exceptionator$actions$concrete$ConcreteIncomingActions$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ConcreteIncomingActions io$fsq$exceptionator$actions$concrete$ConcreteIncomingActions$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.now$1 = now$1;
            }
        });
    }

    public ProcessedIncoming save(FilteredIncoming incoming) {
        Set set;
        Set tags = incoming.tags();
        Set kw = incoming.keywords();
        Set buckets = incoming.buckets();
        NoticeRecord notice = ((HasNoticeActions)this.io$fsq$exceptionator$actions$concrete$ConcreteIncomingActions$$services).noticeActions().save(incoming.incoming(), tags, kw, buckets);
        ObjectId incomingId = (ObjectId)notice.id().value();
        DateTime historyId = ((HasHistoryActions)this.io$fsq$exceptionator$actions$concrete$ConcreteIncomingActions$$services).historyActions().save(notice);
        Set results = (Set)buckets.map((Function1)new Serializable(this, incoming, incomingId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConcreteIncomingActions $outer;
            private final FilteredIncoming incoming$2;
            private final ObjectId incomingId$1;

            public final SaveResult apply(BucketId bucket) {
                int max = ((BucketSpec)this.$outer.bucketSpecs().apply((Object)bucket.name())).maxRecent();
                return this.$outer.io$fsq$exceptionator$actions$concrete$ConcreteIncomingActions$$services.bucketActions().save(this.incomingId$1, this.incoming$2.incoming(), bucket, max);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.incoming$2 = incoming$2;
                this.incomingId$1 = incomingId$1;
            }
        }, Set$.MODULE$.canBuildFrom());
        if (results.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConcreteIncomingActions $outer;

            public final boolean apply(SaveResult r) {
                return r.oldResult().isDefined() && ((BucketSpec)this.$outer.bucketSpecs().apply((Object)r.bucket().name())).invalidatesFreshness();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })) {
            set = buckets;
        } else {
            BucketId freshKey = new BucketId(FreshBucketFilter$.MODULE$.name(), (String)FreshBucketFilter$.MODULE$.key(incoming).get(), BucketId$.MODULE$.apply$default$3());
            SaveResult res = this.io$fsq$exceptionator$actions$concrete$ConcreteIncomingActions$$services.bucketActions().save(incomingId, incoming.incoming(), freshKey, FreshBucketFilter$.MODULE$.maxRecent());
            Stats$.MODULE$.time("incomingActions.add", (Function0)new Serializable(this, incomingId, freshKey){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ConcreteIncomingActions $outer;
                private final ObjectId incomingId$1;
                private final BucketId freshKey$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    ((HasNoticeActions)this.$outer.io$fsq$exceptionator$actions$concrete$ConcreteIncomingActions$$services).noticeActions().addBucket(this.incomingId$1, this.freshKey$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.incomingId$1 = incomingId$1;
                    this.freshKey$1 = freshKey$1;
                }
            });
            set = (Set)buckets.$plus((Object)freshKey);
        }
        Set finalBuckets = set;
        List remove2 = ((TraversableOnce)results.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<Tuple2<ObjectId, BucketId>> apply(SaveResult r) {
                return (List)r.noticesToRemove().map((Function1)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final SaveResult r$1;

                    public final Tuple2<ObjectId, BucketId> apply(ObjectId x$3) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x$3), (Object)this.r$1.bucket());
                    }
                    {
                        this.r$1 = r$1;
                    }
                }, List$.MODULE$.canBuildFrom());
            }
        }, Set$.MODULE$.canBuildFrom())).toList();
        Stats$.MODULE$.time("incomingActions.remove", (Function0)new Serializable(this, remove2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConcreteIncomingActions $outer;
            private final List remove$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.remove$1.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$save$1 $outer;

                    public final void apply(Tuple2<ObjectId, BucketId> bucketRemoval) {
                        ((HasNoticeActions)this.$outer.io$fsq$exceptionator$actions$concrete$ConcreteIncomingActions$$anonfun$$$outer().io$fsq$exceptionator$actions$concrete$ConcreteIncomingActions$$services).noticeActions().removeBucket((ObjectId)bucketRemoval._1(), (BucketId)bucketRemoval._2());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ConcreteIncomingActions io$fsq$exceptionator$actions$concrete$ConcreteIncomingActions$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.remove$1 = remove$1;
            }
        });
        long now = (long)incomingId.getTimestamp() * 1000L;
        if (now > this.currentTime()) {
            this.currentTime_$eq(now);
            if (this.currentTime() - this.lastHistogramTrim() > 3600000L) {
                this.lastHistogramTrim_$eq(now);
                this.doMaintenance(now);
            }
        }
        return new ProcessedIncoming((Option)new Some((Object)incomingId), incoming.incoming(), tags, kw, finalBuckets);
    }

    public ConcreteIncomingActions(HasBucketActions services) {
        this.io$fsq$exceptionator$actions$concrete$ConcreteIncomingActions$$services = services;
        Logger.class.$init$((io.fsq.common.logging.Logger)this);
        this.saveFuturePool = FuturePool$.MODULE$.apply(Executors.newFixedThreadPool(10));
        this.bucketSpecs = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.incomingFilters = (List)Config$.MODULE$.opt((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<Config> apply(Config x$1) {
                return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$1.getConfigList("incoming.filters")).asScala()).toList();
            }
        }).toList().flatten((Function1)Predef$.MODULE$.$conforms());
        this.currentTime = 0L;
        this.lastHistogramTrim = 0L;
    }
}

