/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.security;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

public class FusionAuthUserDetails
implements UserDetails {
    private static final long serialVersionUID = 1L;
    public JsonNode claims;
    public OAuth2AccessToken token;
    public String userId;
    public String username;
    private List<SimpleGrantedAuthority> roles = new ArrayList<SimpleGrantedAuthority>();

    public FusionAuthUserDetails(JsonNode claims, OAuth2AccessToken token) {
        this.userId = claims.get("sub").asText();
        this.username = claims.get("email").asText();
        List roles = claims.findValuesAsText("roles");
        for (String role : roles) {
            this.roles.add(new SimpleGrantedAuthority(role));
        }
        this.claims = claims;
        this.token = token;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.roles;
    }

    public String getPassword() {
        return null;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }
}

