/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fusionauth.security.FusionAuthUserDetails;
import io.fusionauth.security.OpenIDAuthorizationCodeResourceDetails;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class OpenIDConnectFilter
extends AbstractAuthenticationProcessingFilter {
    private OAuth2RestOperations restTemplate;
    @Autowired
    private OpenIDAuthorizationCodeResourceDetails openIDResourceDetails;

    public OpenIDConnectFilter(String defaultFilterProcessesUrl) {
        super(defaultFilterProcessesUrl);
        this.setAuthenticationManager(new NoopAuthenticationManager());
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        OAuth2AccessToken accessToken;
        try {
            accessToken = this.restTemplate.getAccessToken();
        }
        catch (OAuth2Exception e) {
            throw new BadCredentialsException("Could not obtain access token", (Throwable)e);
        }
        try {
            FusionAuthUserDetails user = new FusionAuthUserDetails(this.getUserInfo(accessToken), accessToken);
            return new UsernamePasswordAuthenticationToken((Object)user, null, user.getAuthorities());
        }
        catch (Exception e) {
            throw new BadCredentialsException("Failed to validate the token", (Throwable)e);
        }
    }

    public void setRestTemplate(OAuth2RestTemplate restTemplate2) {
        this.restTemplate = restTemplate2;
    }

    private JsonNode getUserInfo(OAuth2AccessToken accessToken) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + accessToken.getValue());
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = new RestTemplate().exchange(this.openIDResourceDetails.getUserInfoUri(), HttpMethod.GET, httpEntity, String.class, new Object[0]);
        if (response.getStatusCode() == HttpStatus.OK) {
            return new ObjectMapper().readTree((String)response.getBody());
        }
        throw new BadCredentialsException("Failed to request user details from the UserInfo API. Status code [" + response.getStatusCodeValue() + "] Message [" + (String)response.getBody() + "]");
    }

    private static class NoopAuthenticationManager
    implements AuthenticationManager {
        private NoopAuthenticationManager() {
        }

        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            throw new UnsupportedOperationException("No authentication should be done with this AuthenticationManager");
        }
    }
}

