package com.fxlabs;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fxlabs.dto.base.BaseDto;
import com.fxlabs.dto.base.Response;
import com.fxlabs.dto.project.Job;
import com.fxlabs.dto.run.Run;
import com.fxlabs.dto.run.TaskStatus;
import com.fxlabs.exceptions.FxException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

/**
 * @author Mohammed Shoukath Ali
 */

@Mojo(name = "job")
public class JobMojo
        extends AbstractMojo {

    public final static HashMap<Class, ParameterizedTypeReference> paramTypeRefMap = new HashMap<>();
    static {
        paramTypeRefMap.put(Run.class, new ParameterizedTypeReference<Response<Run>>() {
        });
    }
    @Parameter(property = "job.message", defaultValue = "Testing Job")
    private String message;

    @Parameter(property = "job.jobId")
    private String jobId;

//    @Parameter( property = "job.url", defaultValue = "https://cloud.fxlabs.io")
//    private String url;


    @Parameter(property = "job.region")
    private String region;

    @Parameter(property = "job.host", defaultValue = HOST_URL)
    private String host;

    @Parameter(property = "job.username")
    private String username;

    @Parameter(property = "job.password")
    private String password;

    @Parameter(property = "job.noRegressionPass")
    private boolean noRegressionPass = false;

    private static final String HOST_URL = "https://cloud.fxlabs.io";

    private static final String UAT_HOST_URL = "http://13.56.210.25";

    private static final String LOCAL_HOST_URL = "http://localhost:8080";

    private static final String RUN_JOB_API_ENDPOINT = "/api/v1/runs/job/";

    private static final String RUN_STATUS_JOB_API_ENDPOINT = "/api/v1/runs/";


    public void execute() throws MojoExecutionException {
        try {
            getLog().info("Username : " + username);
            getLog().info("Job Id : " + jobId);
            getLog().info("Region : " + region);

            String hostUrl = HOST_URL;

            String jobRunUrl = host + RUN_JOB_API_ENDPOINT + jobId;

            if (!org.apache.commons.lang3.StringUtils.isEmpty(region)) {
                jobRunUrl += "?region=" + region;
            }
            String runStatusUrl = host + RUN_STATUS_JOB_API_ENDPOINT;

            RestTemplate restTemplate = new RestTemplate(HttpClientFactoryUtil.httpComponentsClientHttpRequestFactory());
            HttpHeaders httpHeaders = new HttpHeaders();

            httpHeaders.setContentType(MediaType.APPLICATION_JSON);
            httpHeaders.set("Accept", "application/json");


            httpHeaders.set("Authorization", AuthBuilder.createBasicAuth(username, password));

            HttpEntity<String> request = new HttpEntity<>("", httpHeaders);

            ResponseEntity<Response<Run>> response = null;
            int statusCode = -1;
            String responseBody = null;
            HttpHeaders headers = null;

            getLog().info("calling " + jobRunUrl);
            response = restTemplate.exchange(jobRunUrl, HttpMethod.POST, request, paramTypeRefMap.get(Run.class));

            Response<Run> response1 = response.getBody();

            String runId = response1.getData().getId();

            //String runId = getByKeyId(response.getBody(), "id", "");

            if (StringUtils.isEmpty(runId)) {
                throw new MojoExecutionException("Invalid runid." + runId);
            }

            getLog().info("Run Id : " + runId);

           // String status = getByKeyId(response.getBody(), "task", "status");

            TaskStatus status1 = response1.getData().getTask().getStatus();

            if (status1 == null || StringUtils.isEmpty(status1.toString())) {
                throw new MojoExecutionException("Invalid status " + status1.toString());
            }

           // getLog().info("status : " + status1.toString());
            Run run = null;
            do {
                //getLog().info("Checking status ........");
                response = restTemplate.exchange(runStatusUrl + runId, HttpMethod.GET, request, paramTypeRefMap.get(Run.class));

                Response<Run> response2 = response.getBody();
                //String ciCdStatus = getByKeyId(response.getBody(), "ciCdStatus", "");

                run = response2.getData();
                if (run == null || run.getTask() == null) {
                    throw new MojoExecutionException("Failed to get status.");
                }
                status1 = run.getTask().getStatus();

                String[] dataArray = run.getCiCdStatus().split(":");

               /// status = dataArray[0];

                if (run.getTask() == null || StringUtils.isEmpty(status1)) {
                    throw new MojoExecutionException("Invalid status." + status1.toString());
                }
                double success = 0;
                try {
                    long l = run.getTask().getTotalTests() - run.getTask().getFailedTests();
                    success = ((l * 100) / run.getTask().getTotalTests());
                } catch (Exception e) {
                    e.getLocalizedMessage();
                }
               // System.out.print("Status: " + status1 + ".....\r");
                getLog().info("Status: " + status1 + ".....\r");

                if (TaskStatus.COMPLETED.equals(run.getTask().getStatus())) {
                    printStatus(dataArray);
                    if (!noRegressionPass && (run.getTask().getIssuesLogged() > 0 || run.getTask().getTotalOpenIssues() > 0)) {
                        throw new MojoExecutionException(String.format("New : %s Open : %s Closed : %s" , run.getTask().getIssuesLogged(), run.getTask().getTotalOpenIssues(), run.getTask().getIssuesClosed()));
                    }

                    if (noRegressionPass && run.getTask().getIssuesLogged() > 0) {
                        throw new MojoExecutionException(String.format("New : %s Open : %s Closed : %s" , run.getTask().getIssuesLogged(), run.getTask().getTotalOpenIssues(), run.getTask().getIssuesClosed()));
                    }
                }

                if (TaskStatus.FAIL.equals(run.getTask().getStatus())) {
                    getLog().info("Reason for Failure : " + dataArray[1]);
                    throw new MojoExecutionException(run.getTask().getDescription());
                }


                if (TaskStatus.TIMEOUT.equals(run.getTask().getStatus())) {
                    printStatus(dataArray);
                    throw new MojoExecutionException("Job timeout.....");
                }

                try {
                    //getLog().info("Waiting for 5 secs ........");k
                    TimeUnit.SECONDS.sleep(5);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } while (TaskStatus.WAITING.equals(status1) || TaskStatus.PROCESSING.equals(status1));


            if (run != null && run.getTask() != null) {
                getLog().info(String.format("New : %s Open : %s Closed : %s", run.getTask().getIssuesLogged(), run.getTask().getTotalOpenIssues(), run.getTask().getIssuesClosed()));
            }

        } catch (HttpStatusCodeException statusCodeException) {
            getLog().info(statusCodeException.toString() + statusCodeException.getResponseBodyAsString() + statusCodeException.getResponseHeaders());
            throw new MojoExecutionException(statusCodeException.toString() + statusCodeException.getResponseBodyAsString() + statusCodeException.getResponseHeaders());
        } catch (FxException fx){
            throw new MojoExecutionException(fx.toString());
        }  catch (Exception e) {
            getLog().info(e.getLocalizedMessage());
            throw new MojoExecutionException(e.getLocalizedMessage());
        }

    }

    private void printStatus(String[] dataArray) {

        getLog().info("----------------------------------------");
        getLog().info("Run detail's link " + host + dataArray[7] + "/" + dataArray[6]);
        getLog().info("----------------------------------------");
        getLog().info("Success : " + dataArray[1] + " % " + " -- Total Tests : " + dataArray[2] + " -- Failed Tests : " + dataArray[3]);
        getLog().info("----------------------------------------");
    }




}
