package io.g740.client.dao.impl;

import io.g740.client.dao.QueryDataDao;
import io.g740.client.dto.PageResultDTO;
import io.g740.client.dto.SQLGenerResultDTO;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import javax.sql.DataSource;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * @function:
 * @author: DAM
 * @date: 2019/7/8 15:25
 * @description:
 * @version: V1.0
 */
@Repository
public class QueryDataDaoImpl implements QueryDataDao {

    @Override
    public PageResultDTO excuteQuery(SQLGenerResultDTO sqlGenerResultDTO, DataSource datasource) throws SQLException {
        QueryRunner queryRunner = new QueryRunner(datasource);

        String countSql=sqlGenerResultDTO.getCountSql();
        String querySql=sqlGenerResultDTO.getQuerySql();
        List<Object> paramList = sqlGenerResultDTO.getParamsValue();
        long total=0L;
        List<Map<String, Object>> content=null;
        if(!CollectionUtils.isEmpty(paramList)){
            //如果有参数
            total = queryRunner.query(countSql, new ScalarHandler<Long>(),paramList.toArray());
            content = queryRunner.query(querySql, new MapListHandler(), paramList.toArray());

        }else {
            //没有参数
            total = queryRunner.query(countSql, new ScalarHandler<Long>());
            content = queryRunner.query(querySql, new MapListHandler());
        }
        PageResultDTO pageResultDTO = new PageResultDTO(content, total);
        return pageResultDTO;
    }
}
