package io.g740.client.executor.impl;

import io.g740.client.entity.DfFormTableSettingDO;
import io.g740.client.executor.Executor;
import io.g740.client.executor.ExportExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.sql.DataSource;
import java.io.File;
import java.nio.file.Path;
import java.util.List;

/**
 * @author :  zxiuwu
 * @date : 2019-03-21 15:33
 */
public class CommonExecutor implements Executor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonExecutor.class);

    private DataSource dataSource;

    private ExportExecutor exportExecutor;

    /**
     * protect化构造函数，只允许通过Builder创建实例
     */
    CommonExecutor(ExecutorBuilder executorBuilder) {
        this.dataSource = executorBuilder.getDataSource();
        this.exportExecutor = executorBuilder.getExportExecutor();
    }

    @Override
    public File exportExcel(String querySql, List<Object> paramList, List<DfFormTableSettingDO> queryTableSettings, Path path) throws Exception {
        if (exportExecutor != null) {
            // 查询sql
            return this.exportExecutor.exportExcel(dataSource, querySql,paramList, queryTableSettings, path);
        }
        throw new Exception("ExportExecutor Not Found" );
    }
}
