package io.g740.client.service;

import io.g740.client.dto.PageResultDTO;
import io.g740.client.dto.SQLGenerResultDTO;

import javax.sql.DataSource;
import java.util.Map;

/**
 * @function:
 * @author: DAM
 * @date: 2019/7/15 16:45
 * @description:
 * @version: V1.0
 */
public interface QueryDataSercive {
    /**
     * 执行查询
     * @param dataFacetKey
     * @param datasource 数据源
     * @param usePaging 是否分页
     * @param formTableSettingUrl
     * @param requestParams
     * @throws Exception
     */
    PageResultDTO executeQuery(String dataFacetKey,
                               DataSource datasource,
                               Boolean usePaging,
                               String formTableSettingUrl,
                               Map<String, String[]> requestParams) throws Exception;

    /**
     * sql翻译
     * @param dataFacetKey
     * @param usePaging
     * @param formTableSettingUrl
     * @param requestParams
     * @return
     * @throws Exception
     */
    SQLGenerResultDTO generalQuery(String dataFacetKey,
                                   Boolean usePaging,
                                   String formTableSettingUrl,
                                   Map<String, String[]> requestParams) throws Exception;
}
