/*
 * Decompiled with CFR 0.152.
 */
package io.gardenerframework.fragrans.api.security.automation.data.advice;

import io.gardenerframework.fragrans.aop.interceptor.EnhanceMethodInterceptor;
import io.gardenerframework.fragrans.api.security.automation.data.annotation.InjectOperator;
import io.gardenerframework.fragrans.api.security.operator.schema.OperatorBrief;
import io.gardenerframework.fragrans.data.trait.security.SecurityTraits;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;

public class OperatorInjector
implements EnhanceMethodInterceptor {
    private final OperatorBrief operatorBrief;

    public Pointcut getPointcut() {
        return new Pointcut(){

            public ClassFilter getClassFilter() {
                return new ClassFilter(){

                    public boolean matches(Class<?> clazz) {
                        return true;
                    }
                };
            }

            public MethodMatcher getMethodMatcher() {
                return new MethodMatcher(){

                    public boolean matches(Method method, Class<?> targetClass) {
                        Class<?>[] parameterTypes = method.getParameterTypes();
                        if (parameterTypes != null) {
                            for (Class<?> type : parameterTypes) {
                                if (!SecurityTraits.AuditingTraits.IdentifierTraits.Operator.class.isAssignableFrom(type) && !SecurityTraits.AuditingTraits.IdentifierTraits.Creator.class.isAssignableFrom(type) && !SecurityTraits.AuditingTraits.IdentifierTraits.Updater.class.isAssignableFrom(type) && !SecurityTraits.AuditingTraits.IdentifierTraits.Deleter.class.isAssignableFrom(type)) continue;
                                return true;
                            }
                            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
                            int parameterIndex = 0;
                            Annotation[][] annotationArray = parameterAnnotations;
                            int n = annotationArray.length;
                            for (int i = 0; i < n; ++i) {
                                Annotation[] annotations;
                                for (Annotation annotation : annotations = annotationArray[i]) {
                                    if (!(annotation instanceof InjectOperator) || !String.class.isAssignableFrom(parameterTypes[parameterIndex])) continue;
                                    return true;
                                }
                                ++parameterIndex;
                            }
                        }
                        return false;
                    }

                    public boolean isRuntime() {
                        return false;
                    }

                    public boolean matches(Method method, Class<?> targetClass, Object ... args) {
                        return false;
                    }
                };
            }
        };
    }

    public void before(Object target, Method method, Object[] arguments) throws Exception {
        if (RequestContextHolder.getRequestAttributes() != null && StringUtils.hasText((String)this.operatorBrief.getUserId())) {
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < arguments.length; ++i) {
                if (arguments[i] instanceof SecurityTraits.AuditingTraits.IdentifierTraits.Operator && !StringUtils.hasText((String)((SecurityTraits.AuditingTraits.IdentifierTraits.Operator)arguments[i]).getOperator())) {
                    ((SecurityTraits.AuditingTraits.IdentifierTraits.Operator)arguments[i]).setOperator(this.operatorBrief.getUserId());
                }
                if (arguments[i] instanceof SecurityTraits.AuditingTraits.IdentifierTraits.Creator && !StringUtils.hasText((String)((SecurityTraits.AuditingTraits.IdentifierTraits.Creator)arguments[i]).getCreator())) {
                    ((SecurityTraits.AuditingTraits.IdentifierTraits.Creator)arguments[i]).setCreator(this.operatorBrief.getUserId());
                }
                if (arguments[i] instanceof SecurityTraits.AuditingTraits.IdentifierTraits.Updater && !StringUtils.hasText((String)((SecurityTraits.AuditingTraits.IdentifierTraits.Updater)arguments[i]).getUpdater())) {
                    ((SecurityTraits.AuditingTraits.IdentifierTraits.Updater)arguments[i]).setUpdater(this.operatorBrief.getUserId());
                }
                if (arguments[i] instanceof SecurityTraits.AuditingTraits.IdentifierTraits.Deleter && !StringUtils.hasText((String)((SecurityTraits.AuditingTraits.IdentifierTraits.Deleter)arguments[i]).getDeleter())) {
                    ((SecurityTraits.AuditingTraits.IdentifierTraits.Deleter)arguments[i]).setDeleter(this.operatorBrief.getUserId());
                }
                for (Annotation annotation : parameterAnnotations[i]) {
                    if (!(annotation instanceof InjectOperator) || !String.class.isAssignableFrom(parameterTypes[i]) || StringUtils.hasText((CharSequence)((CharSequence)arguments[i]))) continue;
                    arguments[i] = this.operatorBrief.getUserId();
                }
            }
        }
    }

    public OperatorInjector(OperatorBrief operatorBrief) {
        this.operatorBrief = operatorBrief;
    }
}

