/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.shared.model.assertion;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.shared.model.assertion.Assertion;
import io.gatling.shared.model.assertion.AssertionPath;
import io.gatling.shared.model.assertion.AssertionPath$ForAll$;
import io.gatling.shared.model.assertion.AssertionPath$Global$;
import io.gatling.shared.model.assertion.AssertionResult;
import io.gatling.shared.model.assertion.AssertionStatsRepository;
import io.gatling.shared.model.assertion.Condition;
import io.gatling.shared.model.assertion.CountMetric;
import io.gatling.shared.model.assertion.CountMetric$AllRequests$;
import io.gatling.shared.model.assertion.CountMetric$FailedRequests$;
import io.gatling.shared.model.assertion.CountMetric$SuccessfulRequests$;
import io.gatling.shared.model.assertion.Stat;
import io.gatling.shared.model.assertion.Stat$Max$;
import io.gatling.shared.model.assertion.Stat$Mean$;
import io.gatling.shared.model.assertion.Stat$Min$;
import io.gatling.shared.model.assertion.Stat$StandardDeviation$;
import io.gatling.shared.model.assertion.Target;
import io.gatling.shared.model.assertion.Target$MeanRequestsPerSecond$;
import io.gatling.shared.model.assertion.TimeMetric;
import io.gatling.shared.model.assertion.TimeMetric$ResponseTime$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t\u001ds!B\u0014)\u0011\u0003\u0019d!B\u001b)\u0011\u00031\u0004\"B\u001f\u0002\t\u0003qT\u0001B \u0002\t\u00013A!V\u0001G-\"Aa\r\u0002BK\u0002\u0013\u0005q\r\u0003\u0005l\t\tE\t\u0015!\u0003i\u0011!aGA!f\u0001\n\u0003i\u0007\u0002\u00039\u0005\u0005#\u0005\u000b\u0011\u00028\t\u000bu\"A\u0011A9\t\u000fU$\u0011\u0011!C\u0001m\"9\u0011\u0010BI\u0001\n\u0003Q\b\"CA\u0006\tE\u0005I\u0011AA\u0007\u0011%\t\t\u0002BA\u0001\n\u0003\n\u0019\u0002C\u0005\u0002&\u0011\t\t\u0011\"\u0001\u0002(!I\u0011q\u0006\u0003\u0002\u0002\u0013\u0005\u0011\u0011\u0007\u0005\n\u0003{!\u0011\u0011!C!\u0003\u007fA\u0011\"!\u0014\u0005\u0003\u0003%\t!a\u0014\t\u0013\u0005eC!!A\u0005B\u0005m\u0003\"CA0\t\u0005\u0005I\u0011IA1\u0011%\t\u0019\u0007BA\u0001\n\u0003\n)\u0007C\u0005\u0002h\u0011\t\t\u0011\"\u0011\u0002j\u001dI\u0011QN\u0001\u0002\u0002#%\u0011q\u000e\u0004\t+\u0006\t\t\u0011#\u0003\u0002r!1Qh\u0006C\u0001\u0003\u000fC\u0011\"a\u0019\u0018\u0003\u0003%)%!\u001a\t\u0013\u0005%u#!A\u0005\u0002\u0006-\u0005\"CAI/\u0005\u0005I\u0011QAJ\u0011%\t\tkFA\u0001\n\u0013\t\u0019KB\u00036Q\t\tY\u000b\u0003\u0006\u0002.v\u0011\t\u0011)A\u0005\u0003_Ca!P\u000f\u0005\u0002\u0005U\u0006bBA^;\u0011\u0005\u0011Q\u0018\u0005\b\u0003#lB\u0011BAj\u0011\u001d\t)0\bC\u0005\u0003oDqAa\u0002\u001e\t\u0013\u0011I\u0001C\u0004\u0003\u001eu!IAa\b\t\u000f\t\u0015R\u0004\"\u0003\u0003(!9!QH\u000f\u0005\n\t}\u0012AE!tg\u0016\u0014H/[8o-\u0006d\u0017\u000eZ1u_JT!!\u000b\u0016\u0002\u0013\u0005\u001c8/\u001a:uS>t'BA\u0016-\u0003\u0015iw\u000eZ3m\u0015\tic&\u0001\u0004tQ\u0006\u0014X\r\u001a\u0006\u0003_A\nqaZ1uY&twMC\u00012\u0003\tIwn\u0001\u0001\u0011\u0005Q\nQ\"\u0001\u0015\u0003%\u0005\u001b8/\u001a:uS>tg+\u00197jI\u0006$xN]\n\u0003\u0003]\u0002\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00014\u00055\u0019F/\u0019;t\u0005f\u001cF/\u0019;vgB!\u0001(Q\"O\u0013\t\u0011\u0015HA\u0005Gk:\u001cG/[8ocA\u0019\u0001\b\u0012$\n\u0005\u0015K$AB(qi&|g\u000e\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006)1\u000f^1ug*\u00111JL\u0001\bG>lWn\u001c8t\u0013\ti\u0005J\u0001\u0004Ti\u0006$Xo\u001d\t\u0003\u001fJs!\u0001\u000e)\n\u0005EC\u0013\u0001G!tg\u0016\u0014H/[8o'R\fGo\u001d*fa>\u001c\u0018\u000e^8ss&\u00111\u000b\u0016\u0002\u0006'R\fGo\u001d\u0006\u0003#\"\u0012a\u0002U1uQJ+7o\u001c7vi&|gn\u0005\u0003\u0005o]S\u0006C\u0001\u001dY\u0013\tI\u0016HA\u0004Qe>$Wo\u0019;\u0011\u0005m\u001bgB\u0001/b\u001d\ti\u0006-D\u0001_\u0015\ty&'\u0001\u0004=e>|GOP\u0005\u0002u%\u0011!-O\u0001\ba\u0006\u001c7.Y4f\u0013\t!WM\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002cs\u0005\tRO\u001c4pY\u0012,G-Q:tKJ$\u0018n\u001c8\u0016\u0003!\u0004\"\u0001N5\n\u0005)D#!C!tg\u0016\u0014H/[8o\u0003I)hNZ8mI\u0016$\u0017i]:feRLwN\u001c\u0011\u0002\u001bM$\u0018\r^:CsN#\u0018\r^;t+\u0005q\u0007CA8\u0004\u001b\u0005\t\u0011AD:uCR\u001c()_*uCR,8\u000f\t\u000b\u0004eN$\bCA8\u0005\u0011\u00151\u0017\u00021\u0001i\u0011\u0015a\u0017\u00021\u0001o\u0003\u0011\u0019w\u000e]=\u0015\u0007I<\b\u0010C\u0004g\u0015A\u0005\t\u0019\u00015\t\u000f1T\u0001\u0013!a\u0001]\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A>+\u0005!d8&A?\u0011\u0007y\f9!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0003s\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005%qPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0010)\u0012a\u000e`\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005U\u0001\u0003BA\f\u0003Ci!!!\u0007\u000b\t\u0005m\u0011QD\u0001\u0005Y\u0006twM\u0003\u0002\u0002 \u0005!!.\u0019<b\u0013\u0011\t\u0019#!\u0007\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\u0003E\u00029\u0003WI1!!\f:\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019$!\u000f\u0011\u0007a\n)$C\u0002\u00028e\u00121!\u00118z\u0011%\tYdDA\u0001\u0002\u0004\tI#A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0003\u0002b!a\u0011\u0002J\u0005MRBAA#\u0015\r\t9%O\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA&\u0003\u000b\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011KA,!\rA\u00141K\u0005\u0004\u0003+J$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003w\t\u0012\u0011!a\u0001\u0003g\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011QCA/\u0011%\tYDEA\u0001\u0002\u0004\tI#\u0001\u0005iCND7i\u001c3f)\t\tI#\u0001\u0005u_N#(/\u001b8h)\t\t)\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003#\nY\u0007C\u0005\u0002<U\t\t\u00111\u0001\u00024\u0005q\u0001+\u0019;i%\u0016\u001cx\u000e\\;uS>t\u0007CA8\u0018'\u00159\u00121OA@!\u001d\t)(a\u001fi]Jl!!a\u001e\u000b\u0007\u0005e\u0014(A\u0004sk:$\u0018.\\3\n\t\u0005u\u0014q\u000f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BAA\u0003\u000bk!!a!\u000b\u0007E\ni\"C\u0002e\u0003\u0007#\"!a\u001c\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bI\fi)a$\t\u000b\u0019T\u0002\u0019\u00015\t\u000b1T\u0002\u0019\u00018\u0002\u000fUt\u0017\r\u001d9msR!\u0011QSAO!\u0011AD)a&\u0011\u000ba\nI\n\u001b8\n\u0007\u0005m\u0015H\u0001\u0004UkBdWM\r\u0005\t\u0003?[\u0012\u0011!a\u0001e\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005\u0015\u0006\u0003BA\f\u0003OKA!!+\u0002\u001a\t1qJ\u00196fGR\u001c\"!H\u001c\u0002\u0015I,\u0007o\\:ji>\u0014\u0018\u0010E\u00025\u0003cK1!a-)\u0005a\t5o]3si&|gn\u0015;biN\u0014V\r]8tSR|'/\u001f\u000b\u0005\u0003o\u000bI\f\u0005\u00025;!9\u0011QV\u0010A\u0002\u0005=\u0016A\u0005<bY&$\u0017\r^3BgN,'\u000f^5p]N$B!a0\u0002LB)1,!1\u0002F&\u0019\u00111Y3\u0003\t1K7\u000f\u001e\t\u0004i\u0005\u001d\u0017bAAeQ\ty\u0011i]:feRLwN\u001c*fgVdG\u000fC\u0004\u0002N\u0002\u0002\r!a4\u0002\u0015\u0005\u001c8/\u001a:uS>t7\u000f\u0005\u0003\\\u0003\u0003D\u0017a\u0003:fg>dg/\u001a)bi\"$b!!6\u0002p\u0006E\bcB.\u0002X\u0006m\u0017\u0011^\u0005\u0004\u00033,'AB#ji\",'\u000f\u0005\u0003\u0002^\u0006\u0015h\u0002BAp\u0003C\u0004\"!X\u001d\n\u0007\u0005\r\u0018(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003G\t9OC\u0002\u0002df\u0002RaWAa\u0003W\u00042!!<\u0005\u001d\t!\u0004\u0001C\u0003*C\u0001\u0007\u0001\u000eC\u0004\u0002t\u0006\u0002\r!a,\u0002\u0017M$\u0018\r^:T_V\u00148-Z\u0001\u000ee\u0016\u001cx\u000e\u001c<f)\u0006\u0014x-\u001a;\u0015\r\u0005e(\u0011\u0001B\u0002!\u001dA\u0014\u0011TA~\u0003#\u00022\u0001OA\u007f\u0013\r\ty0\u000f\u0002\u0007\t>,(\r\\3\t\u000b%\u0012\u0003\u0019\u00015\t\r%\u0013\u0003\u0019\u0001B\u0003!\r\tioA\u0001\u001ee\u0016\u001cx\u000e\u001c<f\u0007>,h\u000e\u001e+be\u001e,G/Q2uk\u0006dg+\u00197vKR1!1\u0002B\t\u00057\u00012\u0001\u000fB\u0007\u0013\r\u0011y!\u000f\u0002\u0005\u0019>tw\rC\u0004\u0003\u0014\r\u0002\rA!\u0006\u0002\r5,GO]5d!\r!$qC\u0005\u0004\u00053A#aC\"pk:$X*\u001a;sS\u000eDa!S\u0012A\u0002\t\u0015\u0011a\b:fg>dg/\u001a)fe\u000e,g\u000e\u001e+be\u001e,G/Q2uk\u0006dg+\u00197vKR1\u00111 B\u0011\u0005GAqAa\u0005%\u0001\u0004\u0011)\u0002\u0003\u0004JI\u0001\u0007!QA\u0001\u001de\u0016\u001cx\u000e\u001c<f)&lW\rV1sO\u0016$\u0018i\u0019;vC24\u0016\r\\;f)!\tIC!\u000b\u00032\tm\u0002b\u0002B\nK\u0001\u0007!1\u0006\t\u0004i\t5\u0012b\u0001B\u0018Q\tQA+[7f\u001b\u0016$(/[2\t\u000f\tMR\u00051\u0001\u00036\u0005!1\u000f^1u!\r!$qG\u0005\u0004\u0005sA#\u0001B*uCRDa!S\u0013A\u0002\t\u0015\u0011\u0001\u0005:fg>dg/Z\"p]\u0012LG/[8o)\u0019\t\tF!\u0011\u0003D!)\u0011F\na\u0001Q\"9!Q\t\u0014A\u0002\u0005m\u0018aC1diV\fGNV1mk\u0016\u0004")
public final class AssertionValidator {
    private final AssertionStatsRepository repository;

    public List<AssertionResult> validateAssertions(List<Assertion> assertions) {
        return assertions.flatMap((Function1 & Serializable)rawAssertion -> {
            Either<String, List<PathResolution>> either = this.resolvePath((Assertion)rawAssertion, $this.repository);
            if (either instanceof Left) {
                Left left = (Left)either;
                String error = (String)left.value();
                AssertionResult.ResolutionError resolutionError = new AssertionResult.ResolutionError((Assertion)rawAssertion, error);
                return Nil$.MODULE$.$colon$colon((Object)resolutionError);
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                List pathResolutions = (List)right.value();
                return pathResolutions.map((Function1 & Serializable)x0$1 -> {
                    PathResolution pathResolution = x0$1;
                    if (pathResolution != null) {
                        Function1<Option<Status>, AssertionStatsRepository.Stats> statsByStatus;
                        Assertion unfoldedAssertion = pathResolution.unfoldedAssertion();
                        Tuple2<Object, Object> tuple2 = this.resolveTarget(unfoldedAssertion, statsByStatus = pathResolution.statsByStatus());
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        double actualValue = tuple2._1$mcD$sp();
                        boolean success = tuple2._2$mcZ$sp();
                        Tuple2.mcDZ.sp sp2 = new Tuple2.mcDZ.sp(actualValue, success);
                        double actualValue2 = sp2._1$mcD$sp();
                        boolean success2 = sp2._2$mcZ$sp();
                        return new AssertionResult.Resolved(unfoldedAssertion, success2, actualValue2);
                    }
                    throw new MatchError((Object)pathResolution);
                });
            }
            throw new MatchError(either);
        });
    }

    private Either<String, List<PathResolution>> resolvePath(Assertion assertion, AssertionStatsRepository statsSource) {
        AssertionPath.Details details;
        List<String> list;
        AssertionPath assertionPath = assertion.path();
        if (AssertionPath$Global$.MODULE$.equals(assertionPath) ? true : assertionPath instanceof AssertionPath.Details && Nil$.MODULE$.equals(list = (details = (AssertionPath.Details)assertionPath).parts())) {
            PathResolution pathResolution = new PathResolution(assertion, (Function1<Option<Status>, AssertionStatsRepository.Stats>)(Function1 & Serializable)x$2 -> statsSource.requestGeneralStats((List<String>)Nil$.MODULE$, (Option<String>)None$.MODULE$, (Option<Status>)x$2));
            return package$.MODULE$.Right().apply((Object)Nil$.MODULE$.$colon$colon((Object)pathResolution));
        }
        if (AssertionPath$ForAll$.MODULE$.equals(assertionPath)) {
            return package$.MODULE$.Right().apply((Object)statsSource.allRequestPaths().map((Function1 & Serializable)x0$1 -> {
                AssertionStatsRepository.StatsPath.Request request = x0$1;
                if (request != null) {
                    List<String> group = request.group();
                    String request2 = request.request();
                    List<String> list = group;
                    String string = request2;
                    return new PathResolution(assertion.copy(new AssertionPath.Details((List<String>)Nil$.MODULE$.$colon$colon((Object)string).$colon$colon$colon(list)), assertion.copy$default$2(), assertion.copy$default$3()), (Function1<Option<Status>, AssertionStatsRepository.Stats>)(Function1 & Serializable)x$3 -> statsSource.requestGeneralStats(group, (Option<String>)new Some((Object)request2), (Option<Status>)x$3));
                }
                throw new MatchError((Object)request);
            }));
        }
        if (assertionPath instanceof AssertionPath.Details) {
            AssertionStatsRepository.StatsPath statsPath;
            AssertionPath.Details details2 = (AssertionPath.Details)assertionPath;
            List<String> parts = details2.parts();
            boolean bl = false;
            Some some = null;
            Option<AssertionStatsRepository.StatsPath> option = statsSource.findPathByParts(parts);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                AssertionStatsRepository.StatsPath statsPath2 = (AssertionStatsRepository.StatsPath)some.value();
                if (statsPath2 instanceof AssertionStatsRepository.StatsPath.Request) {
                    AssertionStatsRepository.StatsPath.Request request = (AssertionStatsRepository.StatsPath.Request)statsPath2;
                    List<String> group = request.group();
                    String request2 = request.request();
                    PathResolution pathResolution = new PathResolution(assertion, (Function1<Option<Status>, AssertionStatsRepository.Stats>)(Function1 & Serializable)x$4 -> statsSource.requestGeneralStats(group, (Option<String>)new Some((Object)request2), (Option<Status>)x$4));
                    return package$.MODULE$.Right().apply((Object)Nil$.MODULE$.$colon$colon((Object)pathResolution));
                }
            }
            if (bl && (statsPath = (AssertionStatsRepository.StatsPath)some.value()) instanceof AssertionStatsRepository.StatsPath.Group) {
                AssertionStatsRepository.StatsPath.Group group = (AssertionStatsRepository.StatsPath.Group)statsPath;
                List<String> group2 = group.group();
                PathResolution pathResolution = new PathResolution(assertion, (Function1<Option<Status>, AssertionStatsRepository.Stats>)(Function1 & Serializable)x$5 -> statsSource.groupCumulatedResponseTimeGeneralStats(group2, (Option<Status>)x$5));
                return package$.MODULE$.Right().apply((Object)Nil$.MODULE$.$colon$colon((Object)pathResolution));
            }
            return package$.MODULE$.Left().apply((Object)("Could not find stats matching assertion path " + parts));
        }
        throw new MatchError((Object)assertionPath);
    }

    private Tuple2<Object, Object> resolveTarget(Assertion assertion, Function1<Option<Status>, AssertionStatsRepository.Stats> stats) {
        double d;
        Target target = assertion.target();
        if (Target$MeanRequestsPerSecond$.MODULE$.equals(target)) {
            d = ((AssertionStatsRepository.Stats)stats.apply((Object)None$.MODULE$)).meanRequestsPerSec();
        } else if (target instanceof Target.Count) {
            Target.Count count = (Target.Count)target;
            CountMetric metric = count.metric();
            d = this.resolveCountTargetActualValue(metric, stats);
        } else if (target instanceof Target.Percent) {
            Target.Percent percent = (Target.Percent)target;
            CountMetric metric = percent.metric();
            d = this.resolvePercentTargetActualValue(metric, stats);
        } else if (target instanceof Target.Time) {
            Target.Time time = (Target.Time)target;
            TimeMetric metric = time.metric();
            Stat stat = time.stat();
            d = this.resolveTimeTargetActualValue(metric, stat, stats);
        } else {
            throw new MatchError((Object)target);
        }
        double actualValue = d;
        return new Tuple2.mcDZ.sp(actualValue, this.resolveCondition(assertion, actualValue));
    }

    private long resolveCountTargetActualValue(CountMetric metric, Function1<Option<Status>, AssertionStatsRepository.Stats> stats) {
        AssertionStatsRepository.Stats stats2;
        CountMetric countMetric = metric;
        if (CountMetric$AllRequests$.MODULE$.equals(countMetric)) {
            stats2 = (AssertionStatsRepository.Stats)stats.apply((Object)None$.MODULE$);
        } else if (CountMetric$FailedRequests$.MODULE$.equals(countMetric)) {
            stats2 = (AssertionStatsRepository.Stats)stats.apply((Object)new Some((Object)KO$.MODULE$));
        } else if (CountMetric$SuccessfulRequests$.MODULE$.equals(countMetric)) {
            stats2 = (AssertionStatsRepository.Stats)stats.apply((Object)new Some((Object)OK$.MODULE$));
        } else {
            throw new MatchError((Object)countMetric);
        }
        AssertionStatsRepository.Stats resolvedStats = stats2;
        return resolvedStats.count();
    }

    private double resolvePercentTargetActualValue(CountMetric metric, Function1<Option<Status>, AssertionStatsRepository.Stats> stats) {
        long allCount = ((AssertionStatsRepository.Stats)stats.apply((Object)None$.MODULE$)).count();
        CountMetric countMetric = metric;
        if (CountMetric$SuccessfulRequests$.MODULE$.equals(countMetric)) {
            if (allCount == 0L) {
                return 0.0;
            }
            return (double)((AssertionStatsRepository.Stats)stats.apply((Object)new Some((Object)OK$.MODULE$))).count() / (double)allCount * (double)100;
        }
        if (CountMetric$FailedRequests$.MODULE$.equals(countMetric)) {
            if (allCount == 0L) {
                return 100.0;
            }
            return (double)((AssertionStatsRepository.Stats)stats.apply((Object)new Some((Object)KO$.MODULE$))).count() / (double)allCount * (double)100;
        }
        return 100.0;
    }

    private int resolveTimeTargetActualValue(TimeMetric metric, Stat stat, Function1<Option<Status>, AssertionStatsRepository.Stats> stats) {
        TimeMetric timeMetric = metric;
        if (!TimeMetric$ResponseTime$.MODULE$.equals(timeMetric)) {
            throw new MatchError((Object)timeMetric);
        }
        AssertionStatsRepository.Stats resolvedStats = (AssertionStatsRepository.Stats)stats.apply((Object)None$.MODULE$);
        Stat stat2 = stat;
        if (Stat$Min$.MODULE$.equals(stat2)) {
            return resolvedStats.min();
        }
        if (Stat$Max$.MODULE$.equals(stat2)) {
            return resolvedStats.max();
        }
        if (Stat$Mean$.MODULE$.equals(stat2)) {
            return resolvedStats.mean();
        }
        if (Stat$StandardDeviation$.MODULE$.equals(stat2)) {
            return resolvedStats.stdDev();
        }
        if (stat2 instanceof Stat.Percentile) {
            Stat.Percentile percentile = (Stat.Percentile)stat2;
            double value = percentile.value();
            return resolvedStats.percentile().apply$mcID$sp(value);
        }
        throw new MatchError((Object)stat2);
    }

    private boolean resolveCondition(Assertion assertion, double actualValue) {
        boolean bl = false;
        Condition.Between between = null;
        Condition condition = assertion.condition();
        if (condition instanceof Condition.Lt) {
            Condition.Lt lt = (Condition.Lt)condition;
            double upper = lt.value();
            return actualValue < upper;
        }
        if (condition instanceof Condition.Lte) {
            Condition.Lte lte = (Condition.Lte)condition;
            double upper = lte.value();
            return actualValue <= upper;
        }
        if (condition instanceof Condition.Gt) {
            Condition.Gt gt = (Condition.Gt)condition;
            double lower = gt.value();
            return actualValue > lower;
        }
        if (condition instanceof Condition.Gte) {
            Condition.Gte gte = (Condition.Gte)condition;
            double lower = gte.value();
            return actualValue >= lower;
        }
        if (condition instanceof Condition.Is) {
            Condition.Is is = (Condition.Is)condition;
            double exactValue = is.value();
            return actualValue == exactValue;
        }
        if (condition instanceof Condition.Between) {
            bl = true;
            between = (Condition.Between)condition;
            double lower = between.lowerBound();
            double upper = between.upperBound();
            boolean bl2 = between.inclusive();
            if (bl2) {
                return actualValue >= lower && actualValue <= upper;
            }
        }
        if (bl) {
            double lower = between.lowerBound();
            double upper = between.upperBound();
            boolean bl3 = between.inclusive();
            if (!bl3) {
                return actualValue > lower && actualValue < upper;
            }
        }
        if (condition instanceof Condition.In) {
            Condition.In in = (Condition.In)condition;
            List<Object> elements = in.elements();
            return elements.contains((Object)BoxesRunTime.boxToDouble((double)actualValue));
        }
        throw new MatchError((Object)condition);
    }

    public AssertionValidator(AssertionStatsRepository repository) {
        this.repository = repository;
    }

    private static final class PathResolution
    implements Product,
    Serializable {
        private final Assertion unfoldedAssertion;
        private final Function1<Option<Status>, AssertionStatsRepository.Stats> statsByStatus;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Assertion unfoldedAssertion() {
            return this.unfoldedAssertion;
        }

        public Function1<Option<Status>, AssertionStatsRepository.Stats> statsByStatus() {
            return this.statsByStatus;
        }

        public PathResolution copy(Assertion unfoldedAssertion, Function1<Option<Status>, AssertionStatsRepository.Stats> statsByStatus) {
            return new PathResolution(unfoldedAssertion, statsByStatus);
        }

        public Assertion copy$default$1() {
            return this.unfoldedAssertion();
        }

        public Function1<Option<Status>, AssertionStatsRepository.Stats> copy$default$2() {
            return this.statsByStatus();
        }

        public String productPrefix() {
            return "PathResolution";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.unfoldedAssertion();
                }
                case 1: {
                    return this.statsByStatus();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PathResolution;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "unfoldedAssertion";
                }
                case 1: {
                    return "statsByStatus";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PathResolution)) return false;
            boolean bl = true;
            if (!bl) return false;
            PathResolution pathResolution = (PathResolution)x$1;
            Assertion assertion = this.unfoldedAssertion();
            Assertion assertion2 = pathResolution.unfoldedAssertion();
            if (assertion == null) {
                if (assertion2 != null) {
                    return false;
                }
            } else if (!((Object)assertion).equals(assertion2)) return false;
            Function1<Option<Status>, AssertionStatsRepository.Stats> function1 = this.statsByStatus();
            Function1<Option<Status>, AssertionStatsRepository.Stats> function12 = pathResolution.statsByStatus();
            if (function1 == null) {
                if (function12 == null) return true;
                return false;
            } else {
                if (!function1.equals(function12)) return false;
                return true;
            }
        }

        public PathResolution(Assertion unfoldedAssertion, Function1<Option<Status>, AssertionStatsRepository.Stats> statsByStatus) {
            this.unfoldedAssertion = unfoldedAssertion;
            this.statsByStatus = statsByStatus;
            Product.$init$((Product)this);
        }
    }
}

