/*
 * Decompiled with CFR 0.152.
 */
package coursier.bootstrap;

import coursier.bootstrap.BootstrapException;
import coursier.bootstrap.BootstrapException$;
import coursier.bootstrap.ClassLoaderContent;
import coursier.bootstrap.ClassLoaderContent$;
import coursier.bootstrap.ClasspathEntry;
import coursier.bootstrap.Preamble$;
import coursier.bootstrap.util.FileUtil$;
import coursier.bootstrap.util.Zip$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class Bootstrap$ {
    public static final Bootstrap$ MODULE$ = new Bootstrap$();

    public String resourceDir() {
        return "coursier/bootstrap/launcher/";
    }

    public String resourcePath(String name) {
        return new StringBuilder(5).append(this.resourceDir()).append("jars/").append(name).toString();
    }

    public void writeZip(OutputStream output, Seq<ClassLoaderContent> content, String mainClass, String bootstrapResourcePath, boolean deterministic, Seq<Tuple2<ZipEntry, byte[]>> extraZipEntries, Seq<Tuple2<String, String>> properties) {
        Seq<ClassLoaderContent> content0 = ClassLoaderContent$.MODULE$.withUniqueFileNames(content);
        byte[] bootstrapJar = FileUtil$.MODULE$.readFully((Function0<InputStream>)(Function0 & Serializable)() -> {
            void var1_1;
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(bootstrapResourcePath);
            if (is == null) {
                throw new BootstrapException("Error: bootstrap JAR not found", BootstrapException$.MODULE$.$lessinit$greater$default$2());
            }
            return var1_1;
        });
        ZipInputStream bootstrapZip = new ZipInputStream(new ByteArrayInputStream(bootstrapJar));
        ZipOutputStream outputZip = new ZipOutputStream(output);
        extraZipEntries.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Bootstrap$.$anonfun$writeZip$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
            Bootstrap$.$anonfun$writeZip$3(outputZip, x$1);
            return BoxedUnit.UNIT;
        });
        Zip$.MODULE$.zipEntries(bootstrapZip).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Bootstrap$.$anonfun$writeZip$4(check$ifrefutable$2))).foreach((Function1 & Serializable)x$2 -> {
            Bootstrap$.$anonfun$writeZip$5(outputZip, x$2);
            return BoxedUnit.UNIT;
        });
        long time = deterministic ? 0L : System.currentTimeMillis();
        int len = content0.length();
        ((IterableOps)content0.zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)Bootstrap$.$anonfun$writeZip$6(check$ifrefutable$3))).foreach((Function1 & Serializable)x$3 -> {
            Bootstrap$.$anonfun$writeZip$7(len, time, outputZip, x$3);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)((IterableOps)content0.flatMap((Function1 & Serializable)x$4 -> x$4.entries())).collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends ClasspathEntry, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof ClasspathEntry.Resource) {
                    ClasspathEntry.Resource resource = (ClasspathEntry.Resource)A1;
                    object = resource;
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ClasspathEntry x3) {
                ClasspathEntry classpathEntry = x3;
                boolean bl = classpathEntry instanceof ClasspathEntry.Resource;
                return bl;
            }
        })).foreach((Function1 & Serializable)e -> {
            Bootstrap$.putBinaryEntry$1(Bootstrap$.MODULE$.resourcePath(e.fileName()), e.lastModified(), e.content(), false, outputZip);
            return BoxedUnit.UNIT;
        });
        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.mainClass"), (Object)mainClass);
        String propFileContent = ((IterableOnceOps)((IterableOps)properties.$plus$colon((Object)tuple2)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Predef$.MODULE$.assert(!v.contains("\n"), (Function0 & Serializable)() -> new StringBuilder(33).append("Invalid \\n character in property ").append(k).toString());
            String string = new StringBuilder(1).append(k).append("=").append(v).toString();
            return string;
        })).mkString("\n");
        Bootstrap$.putStringEntry$1(new StringBuilder(20).append(this.resourceDir()).append("bootstrap.properties").toString(), propFileContent, time, outputZip);
        outputZip.closeEntry();
        outputZip.close();
    }

    public String proguardedBootstrapResourcePath() {
        return "bootstrap.jar";
    }

    public String bootstrapResourcePath() {
        return "bootstrap-orig.jar";
    }

    public String proguardedResourcesBootstrapResourcePath() {
        return "bootstrap-resources.jar";
    }

    public String resourcesBootstrapResourcePath() {
        return "bootstrap-resources-orig.jar";
    }

    public boolean defaultDisableJarChecking(Seq<ClassLoaderContent> content) {
        return content.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Bootstrap$.$anonfun$defaultDisableJarChecking$1(x$5)));
    }

    public void create(Seq<ClassLoaderContent> content, String mainClass, Path output, Seq<String> javaOpts, Seq<Tuple2<String, String>> javaProperties, Option<String> bootstrapResourcePathOpt, boolean deterministic, boolean withPreamble, boolean proguarded, Boolean disableJarChecking, Seq<Tuple2<ZipEntry, byte[]>> extraZipEntries) {
        boolean disableJarChecking0 = BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)disableJarChecking).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> MODULE$.defaultDisableJarChecking(content), (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x))));
        String bootstrapResourcePath = (String)bootstrapResourcePathOpt.getOrElse((Function0 & Serializable)() -> {
            boolean hasResources = content.exists((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)Bootstrap$.$anonfun$create$4(c)));
            Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(hasResources, proguarded);
            if (sp2 != null) {
                boolean bl = sp2._1$mcZ$sp();
                boolean bl2 = sp2._2$mcZ$sp();
                if (bl && bl2) {
                    return MODULE$.proguardedResourcesBootstrapResourcePath();
                }
            }
            if (sp2 != null) {
                boolean bl = sp2._1$mcZ$sp();
                boolean bl3 = sp2._2$mcZ$sp();
                if (bl && !bl3) {
                    return MODULE$.resourcesBootstrapResourcePath();
                }
            }
            if (sp2 != null) {
                boolean bl = sp2._1$mcZ$sp();
                boolean bl4 = sp2._2$mcZ$sp();
                if (!bl && bl4) {
                    return MODULE$.proguardedBootstrapResourcePath();
                }
            }
            if (sp2 == null) throw new MatchError((Object)sp2);
            boolean bl = sp2._1$mcZ$sp();
            boolean bl5 = sp2._2$mcZ$sp();
            if (false != bl) throw new MatchError((Object)sp2);
            if (false != bl5) throw new MatchError((Object)sp2);
            return MODULE$.bootstrapResourcePath();
        });
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        if (withPreamble) {
            buffer.write(Preamble$.MODULE$.shellPreamble(javaOpts, disableJarChecking0).getBytes(StandardCharsets.UTF_8));
        }
        this.writeZip(buffer, content, mainClass, bootstrapResourcePath, deterministic, extraZipEntries, javaProperties);
        Files.write(output, buffer.toByteArray(), new OpenOption[0]);
        FileUtil$.MODULE$.tryMakeExecutable(output);
    }

    public Seq<String> create$default$4() {
        return Nil$.MODULE$;
    }

    public Seq<Tuple2<String, String>> create$default$5() {
        return Nil$.MODULE$;
    }

    public Option<String> create$default$6() {
        return None$.MODULE$;
    }

    public boolean create$default$7() {
        return false;
    }

    public boolean create$default$8() {
        return true;
    }

    public boolean create$default$9() {
        return true;
    }

    public Boolean create$default$10() {
        return null;
    }

    public Seq<Tuple2<ZipEntry, byte[]>> create$default$11() {
        return Nil$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$writeZip$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$writeZip$3(ZipOutputStream outputZip$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ZipEntry ent = (ZipEntry)tuple2._1();
        byte[] content = (byte[])tuple2._2();
        outputZip$1.putNextEntry(ent);
        outputZip$1.write(content);
        outputZip$1.closeEntry();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$writeZip$4(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$writeZip$5(ZipOutputStream outputZip$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ZipEntry ent = (ZipEntry)tuple2._1();
        byte[] data = (byte[])tuple2._2();
        outputZip$1.putNextEntry(ent);
        outputZip$1.write(data);
        outputZip$1.closeEntry();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void putStringEntry$1(String name, String content, long time$1, ZipOutputStream outputZip$1) {
        ZipEntry entry = new ZipEntry(name);
        entry.setTime(time$1);
        outputZip$1.putNextEntry(entry);
        outputZip$1.write(content.getBytes(StandardCharsets.UTF_8));
        outputZip$1.closeEntry();
    }

    private static final void putBinaryEntry$1(String name, long lastModified, byte[] b, boolean compressed, ZipOutputStream outputZip$1) {
        ZipEntry entry = new ZipEntry(name);
        entry.setTime(lastModified);
        entry.setSize(b.length);
        if (!compressed) {
            CRC32 crc32 = new CRC32();
            crc32.update(b);
            entry.setCrc(crc32.getValue());
            entry.setMethod(0);
        }
        outputZip$1.putNextEntry(entry);
        outputZip$1.write(b);
        outputZip$1.closeEntry();
    }

    private static final boolean putBinaryEntry$default$4$1() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$writeZip$6(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$writeZip$7(int len$1, long time$1, ZipOutputStream outputZip$1, Tuple2 x$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$3;
        if (tuple2 != null) {
            ClassLoaderContent c = (ClassLoaderContent)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            Seq urls = (Seq)c.entries().collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends ClasspathEntry, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof ClasspathEntry.Url) {
                        ClasspathEntry.Url url = (ClasspathEntry.Url)A1;
                        String url2 = url.url();
                        object = url2;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(ClasspathEntry x1) {
                    ClasspathEntry classpathEntry = x1;
                    boolean bl = classpathEntry instanceof ClasspathEntry.Url;
                    return bl;
                }
            });
            Seq resources = (Seq)c.entries().collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends ClasspathEntry, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof ClasspathEntry.Resource) {
                        ClasspathEntry.Resource resource = (ClasspathEntry.Resource)A1;
                        object = resource.fileName();
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(ClasspathEntry x2) {
                    ClasspathEntry classpathEntry = x2;
                    boolean bl = classpathEntry instanceof ClasspathEntry.Resource;
                    return bl;
                }
            });
            String suffix = idx == len$1 - 1 ? "" : new StringBuilder(1).append("-").append(idx + 1).toString();
            Bootstrap$.putStringEntry$1(new StringBuilder(18).append(MODULE$.resourceDir()).append("bootstrap-jar-urls").append(suffix).toString(), ((IterableOnceOps)urls.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), time$1, outputZip$1);
            Bootstrap$.putStringEntry$1(new StringBuilder(23).append(MODULE$.resourceDir()).append("bootstrap-jar-resources").append(suffix).toString(), ((IterableOnceOps)resources.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n"), time$1, outputZip$1);
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(c.loaderName()))) {
                Bootstrap$.putStringEntry$1(new StringBuilder(21).append(MODULE$.resourceDir()).append("bootstrap-loader-name").append(suffix).toString(), c.loaderName(), time$1, outputZip$1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$defaultDisableJarChecking$2(ClasspathEntry x0$1) {
        ClasspathEntry classpathEntry = x0$1;
        boolean bl = classpathEntry instanceof ClasspathEntry.Resource;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$defaultDisableJarChecking$1(ClassLoaderContent x$5) {
        return x$5.entries().exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Bootstrap$.$anonfun$defaultDisableJarChecking$2(x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$create$5(ClasspathEntry x0$1) {
        ClasspathEntry classpathEntry = x0$1;
        boolean bl = classpathEntry instanceof ClasspathEntry.Resource;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$create$4(ClassLoaderContent c) {
        return c.entries().exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)Bootstrap$.$anonfun$create$5(x0$1)));
    }

    private Bootstrap$() {
    }
}

