/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.CacheParse$;
import coursier.cache.LocalRepositories$;
import coursier.core.Repository;
import coursier.paths.CachePath;
import coursier.util.Repositories$;
import coursier.util.Schedulable$;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

public final class CacheDefaults$ {
    public static CacheDefaults$ MODULE$;
    private File location;
    private int concurrentDownloadCount;
    private ExecutorService pool;
    private Option<Duration> ttl;
    private int sslRetryCount;
    private Seq<Repository> defaultRepositories;
    private final Seq<Option<String>> checksums;
    private final int bufferSize;
    private volatile byte bitmap$0;

    static {
        new CacheDefaults$();
    }

    private File location$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.location = CachePath.defaultCacheDirectory();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.location;
    }

    public File location() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.location$lzycompute() : this.location;
    }

    private int defaultConcurrentDownloadCount() {
        return 6;
    }

    private int concurrentDownloadCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.concurrentDownloadCount = BoxesRunTime.unboxToInt((Object)scala.sys.package$.MODULE$.props().get("coursier.parallel-download-count").flatMap((Function1 & Serializable & scala.Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(s)).toInt()).toOption()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.defaultConcurrentDownloadCount()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.concurrentDownloadCount;
    }

    public int concurrentDownloadCount() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.concurrentDownloadCount$lzycompute() : this.concurrentDownloadCount;
    }

    private ExecutorService pool$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.pool = Schedulable$.MODULE$.fixedThreadPool(this.concurrentDownloadCount());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.pool;
    }

    public ExecutorService pool() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.pool$lzycompute() : this.pool;
    }

    private Option<Duration> ttl$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                Option fromEnv = scala.sys.package$.MODULE$.env().get((Object)"COURSIER_TTL").flatMap((Function1 & Serializable & scala.Serializable)s -> CacheDefaults$.fromString$1(s));
                this.ttl = fromEnv.orElse((Function0 & Serializable & scala.Serializable)() -> CacheDefaults$.fromProps$1()).orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)CacheDefaults$.default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.ttl;
    }

    public Option<Duration> ttl() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.ttl$lzycompute() : this.ttl;
    }

    public Seq<Option<String>> checksums() {
        return this.checksums;
    }

    private int defaultSslRetryCount() {
        return 3;
    }

    private int sslRetryCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.sslRetryCount = BoxesRunTime.unboxToInt((Object)scala.sys.package$.MODULE$.props().get("coursier.sslexception-retry").flatMap((Function1 & Serializable & scala.Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(s)).toInt()).toOption()).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 >= 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.defaultSslRetryCount()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.sslRetryCount;
    }

    public int sslRetryCount() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.sslRetryCount$lzycompute() : this.sslRetryCount;
    }

    public int defaultRetryCount() {
        return 1;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    private Seq<Repository> defaultRepositories$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                Option fromEnvOpt = scala.sys.package$.MODULE$.env().get((Object)"COURSIER_REPOSITORIES").filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CacheDefaults$.$anonfun$defaultRepositories$3(x$4))).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> CacheDefaults$.fromString$2(x$5, "environment variable COURSIER_REPOSITORIES"));
                Option fromPropsOpt = scala.sys.package$.MODULE$.props().get("coursier.repositories").filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CacheDefaults$.$anonfun$defaultRepositories$5(x$6))).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> CacheDefaults$.fromString$2(x$7, "Java property coursier.repositories"));
                Seq seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Repository[]{LocalRepositories$.MODULE$.ivy2Local(), Repositories$.MODULE$.central()}));
                this.defaultRepositories = (Seq)fromEnvOpt.orElse((Function0 & Serializable & scala.Serializable)() -> fromPropsOpt).getOrElse((Function0 & Serializable & scala.Serializable)() -> seq);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.defaultRepositories;
    }

    public Seq<Repository> defaultRepositories() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.defaultRepositories$lzycompute() : this.defaultRepositories;
    }

    private static final Option fromString$1(String s) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Duration$.MODULE$.apply(s)).toOption();
    }

    private static final Option fromProps$1() {
        return scala.sys.package$.MODULE$.props().get("coursier.ttl").flatMap((Function1 & Serializable & scala.Serializable)s -> CacheDefaults$.fromString$1(s));
    }

    private static final FiniteDuration default$1() {
        return new package.DurationInt(package$.MODULE$.DurationInt(24)).hours();
    }

    public static final /* synthetic */ boolean $anonfun$defaultRepositories$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    private static final Option fromString$2(String str, String origin) {
        Some some;
        Seq l = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(str)).split('|'))).toSeq().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CacheDefaults$.$anonfun$defaultRepositories$1(x$2)));
        Either either = CacheParse$.MODULE$.repositories((Seq<String>)l).either();
        if (either instanceof Left) {
            Left left = (Left)either;
            .colon.colon errs = (.colon.colon)left.value();
            System.err.println(new StringBuilder(47).append("Ignoring ").append(origin).append(", error parsing repositories from it:\n").append(((TraversableOnce)errs.map((Function1 & Serializable & scala.Serializable)x$3 -> new StringBuilder(3).append("  ").append((String)x$3).append("\n").toString(), List$.MODULE$.canBuildFrom())).mkString()).toString());
            some = None$.MODULE$;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Seq repos = (Seq)right.value();
            some = new Some((Object)repos);
        } else {
            throw new MatchError((Object)either);
        }
        return some;
    }

    public static final /* synthetic */ boolean $anonfun$defaultRepositories$3(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$defaultRepositories$5(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
    }

    private CacheDefaults$() {
        MODULE$ = this;
        this.checksums = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)"SHA-1"), None$.MODULE$}));
        this.bufferSize = 0x100000;
    }
}

