/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.AuthenticatedURLConnection;
import coursier.core.Authentication;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Try$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class CacheUrl$ {
    public static CacheUrl$ MODULE$;
    private final ConcurrentHashMap<String, Option<URLStreamHandler>> handlerClsCache;
    private final Regex coursier$cache$CacheUrl$$BasicRealm;

    static {
        new CacheUrl$();
    }

    private ConcurrentHashMap<String, Option<URLStreamHandler>> handlerClsCache() {
        return this.handlerClsCache;
    }

    private Option<URLStreamHandler> handlerFor(String url) {
        Option option;
        String protocol = (String)new StringOps(Predef$.MODULE$.augmentString(url)).takeWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CacheUrl$.$anonfun$handlerFor$1(BoxesRunTime.unboxToChar((Object)x$1))));
        Option option2 = Option$.MODULE$.apply(this.handlerClsCache().get(protocol));
        if (None$.MODULE$.equals(option2)) {
            String clsName = new StringBuilder(31).append("coursier.cache.protocol.").append(new StringOps(Predef$.MODULE$.augmentString(protocol)).capitalize()).append("Handler").toString();
            Option clsOpt0 = CacheUrl$.clsOpt$1(Thread.currentThread().getContextClassLoader(), clsName).orElse((Function0 & Serializable & scala.Serializable)() -> CacheUrl$.clsOpt$1(MODULE$.getClass().getClassLoader(), clsName));
            Option handlerFactoryOpt = clsOpt0.flatMap((Function1 & Serializable & scala.Serializable)cls -> {
                Some some;
                try {
                    some = new Some((Object)((URLStreamHandlerFactory)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
                }
                catch (InstantiationException e) {
                    CacheUrl$.printError$1(e, clsName);
                    some = None$.MODULE$;
                }
                catch (IllegalAccessException e) {
                    CacheUrl$.printError$1(e, clsName);
                    some = None$.MODULE$;
                }
                catch (ClassCastException e) {
                    CacheUrl$.printError$1(e, clsName);
                    some = None$.MODULE$;
                }
                return some;
            });
            Option handlerOpt = handlerFactoryOpt.flatMap((Function1 & Serializable & scala.Serializable)factory -> {
                Some some;
                try {
                    some = new Some((Object)factory.createURLStreamHandler(protocol));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    Console$.MODULE$.err().println(new StringBuilder(31).append("Cannot get handler for ").append(protocol).append(" from ").append(clsName).append(": ").append(e).append(Option$.MODULE$.apply((Object)e.getMessage()).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)x$3 -> new StringBuilder(3).append(" (").append((String)x$3).append(")").toString())).toString());
                    None$ none$ = None$.MODULE$;
                    some = none$;
                }
                return some;
            });
            Option prevOpt = Option$.MODULE$.apply(this.handlerClsCache().putIfAbsent(protocol, (Option<URLStreamHandler>)handlerOpt));
            option = (Option)prevOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> handlerOpt);
        } else if (option2 instanceof Some) {
            Option handlerOpt;
            Some some = (Some)option2;
            option = handlerOpt = (Option)some.value();
        } else {
            throw new MatchError((Object)option2);
        }
        return option;
    }

    public URL url(String s) {
        return new URL(null, s, (URLStreamHandler)this.handlerFor(s).orNull(Predef$.MODULE$.$conforms()));
    }

    private String basicAuthenticationEncode(String user, String password) {
        return Base64.getEncoder().encodeToString(new StringBuilder(1).append(user).append(":").append(password).toString().getBytes(StandardCharsets.UTF_8));
    }

    public URLConnection urlConnection(String url0, Option<Authentication> authentication) {
        URLConnection uRLConnection;
        ObjectRef conn = ObjectRef.create(null);
        try {
            conn.elem = this.url(url0).openConnection();
            URLConnection uRLConnection2 = (URLConnection)conn.elem;
            if (uRLConnection2 instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection2;
                httpURLConnection.setRequestProperty("User-Agent", "");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            authentication.foreach((Function1 & Serializable & scala.Serializable)auth -> {
                CacheUrl$.$anonfun$urlConnection$1(conn, auth);
                return BoxedUnit.UNIT;
            });
            uRLConnection = (URLConnection)conn.elem;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                if ((URLConnection)conn.elem != null) {
                    this.closeConn((URLConnection)conn.elem);
                }
                throw e;
            }
            throw throwable;
        }
        return uRLConnection;
    }

    public Option<Object> responseCode(URLConnection conn) {
        None$ none$;
        URLConnection uRLConnection = conn;
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)httpURLConnection.getResponseCode()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Regex coursier$cache$CacheUrl$$BasicRealm() {
        return this.coursier$cache$CacheUrl$$BasicRealm;
    }

    public Option<String> realm(URLConnection conn) {
        None$ none$;
        URLConnection uRLConnection = conn;
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            none$ = Option$.MODULE$.apply((Object)httpURLConnection.getHeaderField("WWW-Authenticate")).collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    Option option = CacheUrl$.MODULE$.coursier$cache$CacheUrl$$BasicRealm().unapplySeq(A1);
                    if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                        String realm2 = (String)((LinearSeqOptimized)option.get()).apply(0);
                        object = realm2;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(String x1) {
                    String string = x1;
                    Option option = CacheUrl$.MODULE$.coursier$cache$CacheUrl$$BasicRealm().unapplySeq((CharSequence)string);
                    boolean bl = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0;
                    return bl;
                }
            });
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void closeConn(URLConnection conn) {
        Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> conn.getInputStream()).toOption().filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CacheUrl$.$anonfun$closeConn$2(x$4))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.close();
            return BoxedUnit.UNIT;
        });
        URLConnection uRLConnection = conn;
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> httpURLConnection.getErrorStream()).toOption().filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CacheUrl$.$anonfun$closeConn$5(x$6))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.close();
                return BoxedUnit.UNIT;
            });
            httpURLConnection.disconnect();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$handlerFor$1(char x$1) {
        return x$1 != ':';
    }

    private static final Option clsOpt$1(ClassLoader loader, String clsName$1) {
        Some some;
        try {
            some = new Some(Class.forName(clsName$1, false, loader));
        }
        catch (ClassNotFoundException classNotFoundException) {
            some = None$.MODULE$;
        }
        return some;
    }

    private static final void printError$1(Exception e, String clsName$1) {
        Console$.MODULE$.err().println(new StringBuilder(21).append("Cannot instantiate ").append(clsName$1).append(": ").append(e).append(Option$.MODULE$.apply((Object)e.getMessage()).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)x$2 -> new StringBuilder(3).append(" (").append((String)x$2).append(")").toString())).toString());
    }

    public static final /* synthetic */ void $anonfun$urlConnection$1(ObjectRef conn$1, Authentication auth) {
        URLConnection uRLConnection = (URLConnection)conn$1.elem;
        if (uRLConnection instanceof AuthenticatedURLConnection) {
            AuthenticatedURLConnection authenticatedURLConnection = (AuthenticatedURLConnection)((Object)uRLConnection);
            authenticatedURLConnection.authenticate(auth);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setRequestProperty("Authorization", new StringBuilder(6).append("Basic ").append(MODULE$.basicAuthenticationEncode(auth.user(), auth.password())).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$closeConn$2(InputStream x$4) {
        return x$4 != null;
    }

    public static final /* synthetic */ boolean $anonfun$closeConn$5(InputStream x$6) {
        return x$6 != null;
    }

    private CacheUrl$() {
        MODULE$ = this;
        this.handlerClsCache = new ConcurrentHashMap();
        this.coursier$cache$CacheUrl$$BasicRealm = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(8).append("^").append(Pattern.quote("Basic realm=\"")).append("([^").append(Pattern.quote("\"")).append("]*)").append(Pattern.quote("\"")).append("$").toString())).r();
    }
}

