/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.cache.ArtifactError;
import coursier.cache.ArtifactError$NotFound$;
import coursier.cache.CacheDefaults$;
import coursier.cache.CacheLocks$;
import coursier.cache.CacheLogger;
import coursier.cache.CacheLogger$;
import coursier.cache.CacheUrl$;
import coursier.cache.FileCache;
import coursier.core.Authentication;
import coursier.credentials.DirectCredentials;
import coursier.paths.CachePath;
import coursier.util.Sync;
import coursier.util.Task$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class FileCache$ {
    public static FileCache$ MODULE$;

    static {
        new FileCache$();
    }

    public File localFile0(String url, File cache, Option<String> user, boolean localArtifactsShouldBeCached) {
        return CachePath.localFile(url, cache, (String)user.orNull(Predef$.MODULE$.$conforms()), localArtifactsShouldBeCached);
    }

    public void coursier$cache$FileCache$$readFullyTo(InputStream in, OutputStream out, CacheLogger logger, String url, long alreadyDownloaded, int bufferSize) {
        byte[] b = (byte[])Array$.MODULE$.fill(bufferSize, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte());
        this.helper$1(alreadyDownloaded, in, b, out, logger, url);
    }

    public <T> Either<ArtifactError, T> coursier$cache$FileCache$$downloading(String url, File file2, int sslRetry, Function0<Either<ArtifactError, T>> f) {
        return this.helper$2(sslRetry, url, f);
    }

    public Either<ArtifactError, Option<Object>> coursier$cache$FileCache$$contentLength(String url, Option<Authentication> authentication, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Seq<DirectCredentials> credentials, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, CacheLogger logger) {
        Left left;
        block10: {
            URLConnection conn = null;
            try {
                Left left2;
                URLConnection uRLConnection = conn = CacheUrl$.MODULE$.urlConnection(url, authentication, followHttpToHttpsRedirections, followHttpsToHttpRedirections, credentials, sslSocketFactoryOpt, hostnameVerifierOpt, "HEAD");
                if (uRLConnection instanceof HttpURLConnection) {
                    Right right;
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    logger.gettingLength(url);
                    boolean success = false;
                    try {
                        Option len = new Some((Object)BoxesRunTime.boxToLong((long)httpURLConnection.getContentLengthLong())).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$39 -> x$39 >= 0L);
                        success = true;
                        logger.gettingLengthResult(url, (Option<Object>)len);
                        right = package$.MODULE$.Right().apply((Object)len);
                    }
                    finally {
                        if (!success) {
                            logger.gettingLengthResult(url, (Option<Object>)None$.MODULE$);
                        }
                    }
                    left2 = right;
                } else {
                    left2 = package$.MODULE$.Left().apply((Object)new ArtifactError.DownloadError(new StringBuilder(42).append("Cannot do HEAD request with connection ").append(uRLConnection).append(" (").append(url).append(")").toString()));
                }
                left = left2;
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    CacheUrl$.MODULE$.closeConn(conn);
                }
                throw throwable;
            }
            if (conn == null) break block10;
            CacheUrl$.MODULE$.closeConn(conn);
        }
        return left;
    }

    public <F> FileCache<F> apply(Sync<F> S) {
        return new FileCache<F>(new FileCache.Params<F>(CacheDefaults$.MODULE$.location(), CacheDefaults$.MODULE$.cachePolicies(), CacheDefaults$.MODULE$.checksums(), CacheDefaults$.MODULE$.credentials(), CacheLogger$.MODULE$.nop(), CacheDefaults$.MODULE$.pool(), CacheDefaults$.MODULE$.ttl(), false, false, false, CacheDefaults$.MODULE$.maxRedirections(), CacheDefaults$.MODULE$.sslRetryCount(), (Option<SSLSocketFactory>)None$.MODULE$, (Option<HostnameVerifier>)None$.MODULE$, CacheDefaults$.MODULE$.defaultRetryCount(), CacheDefaults$.MODULE$.bufferSize(), S));
    }

    public <F> Sync<Function1<ExecutionContext, Future<Object>>> apply$default$1() {
        return Task$.MODULE$.sync();
    }

    private final void helper$1(long count, InputStream in$1, byte[] b$1, OutputStream out$1, CacheLogger logger$2, String url$7) {
        int read;
        while ((read = in$1.read(b$1)) >= 0) {
            out$1.write(b$1, 0, read);
            out$1.flush();
            logger$2.downloadProgress(url$7, count + (long)read);
            count += (long)read;
        }
    }

    private final Either helper$2(int retry, String url$8, Function0 f$3) {
        Either res;
        Some some;
        block7: {
            while (true) {
                Some resOpt;
                Some some2;
                try {
                    Option res0 = CacheLocks$.MODULE$.withUrlLock(url$8, (Function0 & Serializable & scala.Serializable)() -> {
                        Either either;
                        try {
                            either = (Either)f$3.apply();
                        }
                        catch (Throwable throwable) {
                            FileNotFoundException fileNotFoundException;
                            Throwable throwable2 = throwable;
                            if (!(throwable2 instanceof FileNotFoundException) || (fileNotFoundException = (FileNotFoundException)throwable2).getMessage() == null) {
                                throw throwable;
                            }
                            Left left = package$.MODULE$.Left().apply((Object)new ArtifactError.NotFound(fileNotFoundException.getMessage(), ArtifactError$NotFound$.MODULE$.apply$default$2()));
                            either = left;
                        }
                        return either;
                    });
                    Either res2 = (Either)res0.getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply((Object)new ArtifactError.ConcurrentDownload(url$8)));
                    some2 = new Some((Object)res2);
                }
                catch (Throwable throwable) {
                    None$ none$;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof SSLException && retry >= 1) {
                        none$ = None$.MODULE$;
                    } else {
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            none$ = new Some((Object)package$.MODULE$.Left().apply((Object)new ArtifactError.DownloadError(new StringBuilder(26).append("Caught ").append(e).append(Option$.MODULE$.apply((Object)e.getMessage()).fold((Function0 & Serializable & scala.Serializable)() -> "", (Function1 & Serializable & scala.Serializable)x$38 -> new StringBuilder(3).append(" (").append((String)x$38).append(")").toString())).append(" while downloading ").append(url$8).toString())));
                        } else {
                            throw throwable;
                        }
                    }
                    some2 = none$;
                }
                some = resOpt = some2;
                if (some instanceof Some) break block7;
                if (!None$.MODULE$.equals(some)) break;
                --retry;
            }
            throw new MatchError((Object)some);
        }
        Some some3 = some;
        Either either = res = (Either)some3.value();
        return either;
    }

    private FileCache$() {
        MODULE$ = this;
    }
}

