/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.cache.ArchiveType;
import coursier.cache.ArchiveType$Gzip$;
import coursier.cache.ArchiveType$Tbz2$;
import coursier.cache.ArchiveType$Tgz$;
import coursier.cache.ArchiveType$Zip$;
import coursier.cache.UnArchiver$;
import coursier.cache.UnArchiver$DefaultUnArchiver$;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import org.codehaus.plexus.archiver.tar.TarBZip2UnArchiver;
import org.codehaus.plexus.archiver.tar.TarGZipUnArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.AbstractLogger;
import org.codehaus.plexus.logging.Logger;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Left;
import scala.util.Right;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0005M3qAC\u0006\u0011\u0002G\u0005\u0001\u0003C\u0003\u0018\u0001\u0019\u0005\u0001dB\u00034\u0017!\u0005AGB\u0003\u000b\u0017!\u0005Q\u0007C\u00037\u0007\u0011\u0005qG\u0002\u00039\u0007\u0019I\u0004\"\u0002\u001c\u0006\t\u0003Y\u0004\"\u0002 \u0006\t\u0013y\u0004\"B\f\u0006\t\u0003a\u0005\"B)\u0004\t\u0003\u0011&AC+o\u0003J\u001c\u0007.\u001b<fe*\u0011A\"D\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0005A1m\\;sg&,'o\u0001\u0001\u0014\u0005\u0001\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g-A\u0004fqR\u0014\u0018m\u0019;\u0015\u000bea\"\u0005\f\u0018\u0011\u0005IQ\u0012BA\u000e\u0014\u0005\u0011)f.\u001b;\t\u000bu\t\u0001\u0019\u0001\u0010\u0002\u0017\u0005\u00148\r[5wKRK\b/\u001a\t\u0003?\u0001j\u0011aC\u0005\u0003C-\u00111\"\u0011:dQ&4X\rV=qK\")1%\u0001a\u0001I\u00059\u0011M]2iSZ,\u0007CA\u0013+\u001b\u00051#BA\u0014)\u0003\tIwNC\u0001*\u0003\u0011Q\u0017M^1\n\u0005-2#\u0001\u0002$jY\u0016DQ!L\u0001A\u0002\u0011\nq\u0001Z3ti\u0012K'\u000fC\u00030\u0003\u0001\u0007\u0001'A\u0005pm\u0016\u0014xO]5uKB\u0011!#M\u0005\u0003eM\u0011qAQ8pY\u0016\fg.\u0001\u0006V]\u0006\u00138\r[5wKJ\u0004\"aH\u0002\u0014\u0005\r\t\u0012A\u0002\u001fj]&$h\bF\u00015\u0005E!UMZ1vYR,f.\u0011:dQ&4XM]\n\u0004\u000bEQ\u0004CA\u0010\u0001)\u0005a\u0004CA\u001f\u0006\u001b\u0005\u0019\u0011!\u00038pa2{wmZ3s)\u0005\u0001\u0005CA!K\u001b\u0005\u0011%BA\"E\u0003\u001dawnZ4j]\u001eT!!\u0012$\u0002\rAdW\r_;t\u0015\t9\u0005*\u0001\u0005d_\u0012,\u0007.Y;t\u0015\u0005I\u0015aA8sO&\u00111J\u0011\u0002\u0007\u0019><w-\u001a:\u0015\u000beiej\u0014)\t\u000buA\u0001\u0019\u0001\u0010\t\u000b\rB\u0001\u0019\u0001\u0013\t\u000b5B\u0001\u0019\u0001\u0013\t\u000b=B\u0001\u0019\u0001\u0019\u0002\u000f\u0011,g-Y;miR\t!\b")
public interface UnArchiver {
    public static UnArchiver default() {
        return UnArchiver$.MODULE$.default();
    }

    public void extract(ArchiveType var1, File var2, File var3, boolean var4);

    private static final class DefaultUnArchiver
    implements UnArchiver {
        private Logger nopLogger() {
            return new AbstractLogger(null){

                public void debug(String message, Throwable throwable) {
                }

                public void info(String message, Throwable throwable) {
                }

                public void warn(String message, Throwable throwable) {
                }

                public void error(String message, Throwable throwable) {
                }

                public void fatalError(String message, Throwable throwable) {
                }

                public DefaultUnArchiver$$anon$1 getChildLogger(String name) {
                    return this;
                }
            };
        }

        @Override
        public void extract(ArchiveType archiveType, File archive, File destDir, boolean overwrite) {
            Right right;
            ArchiveType archiveType2 = archiveType;
            if (ArchiveType$Zip$.MODULE$.equals(archiveType2)) {
                ZipUnArchiver u = new ZipUnArchiver();
                u.enableLogging(this.nopLogger());
                right = package$.MODULE$.Right().apply((Object)u);
            } else if (ArchiveType$Tgz$.MODULE$.equals(archiveType2)) {
                TarGZipUnArchiver u = new TarGZipUnArchiver();
                u.enableLogging(this.nopLogger());
                right = package$.MODULE$.Right().apply((Object)u);
            } else if (ArchiveType$Tbz2$.MODULE$.equals(archiveType2)) {
                TarBZip2UnArchiver u = new TarBZip2UnArchiver();
                u.enableLogging(this.nopLogger());
                right = package$.MODULE$.Right().apply((Object)u);
            } else if (ArchiveType$Gzip$.MODULE$.equals(archiveType2)) {
                right = package$.MODULE$.Left().apply((JFunction0.mcV.sp & Serializable)() -> {
                    File dest = new File(destDir, StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(archive.getName()), ".gz"));
                    FileInputStream fis = null;
                    FileOutputStream fos = null;
                    GZIPInputStream gzis = null;
                    try {
                        fis = new FileInputStream(archive);
                        gzis = new GZIPInputStream(fis);
                        fos = new FileOutputStream(dest);
                        byte[] buf = (byte[])Array$.MODULE$.ofDim(16384, (ClassTag)ClassTag$.MODULE$.Byte());
                        int read = -1;
                        while ((read = gzis.read(buf)) >= 0) {
                            if (read <= 0) continue;
                            fos.write(buf, 0, read);
                        }
                        fos.flush();
                    }
                    finally {
                        if (gzis != null) {
                            gzis.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                });
            } else {
                throw new MatchError((Object)archiveType2);
            }
            Right unArchiver = right;
            destDir.mkdirs();
            Right right2 = unArchiver;
            if (right2 instanceof Left) {
                Left left = (Left)right2;
                Function0 f = (Function0)left.value();
                f.apply$mcV$sp();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (right2 instanceof Right) {
                Right right3 = right2;
                org.codehaus.plexus.archiver.UnArchiver u = (org.codehaus.plexus.archiver.UnArchiver)right3.value();
                u.setOverwrite(false);
                u.setSourceFile(archive);
                u.setDestDirectory(destDir);
                u.extract();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)right2);
            }
        }
    }
}

