/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.commonscompress.archivers.zip;

import coursierapi.shaded.commonscompress.archivers.ArchiveOutputStream;
import coursierapi.shaded.commonscompress.archivers.zip.GeneralPurposeBit;
import coursierapi.shaded.commonscompress.archivers.zip.StreamCompressor;
import coursierapi.shaded.commonscompress.archivers.zip.Zip64ExtendedInformationExtraField;
import coursierapi.shaded.commonscompress.archivers.zip.Zip64Mode;
import coursierapi.shaded.commonscompress.archivers.zip.Zip64RequiredException;
import coursierapi.shaded.commonscompress.archivers.zip.ZipArchiveEntry;
import coursierapi.shaded.commonscompress.archivers.zip.ZipEightByteInteger;
import coursierapi.shaded.commonscompress.archivers.zip.ZipEncoding;
import coursierapi.shaded.commonscompress.archivers.zip.ZipEncodingHelper;
import coursierapi.shaded.commonscompress.archivers.zip.ZipExtraField;
import coursierapi.shaded.commonscompress.archivers.zip.ZipLong;
import coursierapi.shaded.commonscompress.archivers.zip.ZipShort;
import coursierapi.shaded.commonscompress.archivers.zip.ZipSplitOutputStream;
import coursierapi.shaded.commonscompress.archivers.zip.ZipUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.List;
import java.util.Map;

public class ZipArchiveOutputStream
extends ArchiveOutputStream {
    private static final byte[] ZERO = new byte[]{0, 0};
    private static final byte[] LZERO = new byte[]{0, 0, 0, 0};
    private static final byte[] ONE = ZipLong.getBytes(1L);
    static final byte[] LFH_SIG = ZipLong.LFH_SIG.getBytes();
    static final byte[] DD_SIG = ZipLong.DD_SIG.getBytes();
    static final byte[] CFH_SIG = ZipLong.CFH_SIG.getBytes();
    static final byte[] EOCD_SIG = ZipLong.getBytes(101010256L);
    static final byte[] ZIP64_EOCD_SIG = ZipLong.getBytes(101075792L);
    static final byte[] ZIP64_EOCD_LOC_SIG = ZipLong.getBytes(117853008L);
    protected boolean finished;
    private CurrentEntry entry;
    private String comment;
    private final List<ZipArchiveEntry> entries;
    private final StreamCompressor streamCompressor;
    private long cdOffset;
    private long cdLength;
    private long cdDiskNumberStart;
    private long eocdLength;
    private final Map<ZipArchiveEntry, EntryMetaData> metaData;
    private ZipEncoding zipEncoding;
    private final SeekableByteChannel channel;
    private final OutputStream outputStream;
    private boolean useUTF8Flag;
    private boolean fallbackToUTF8;
    private boolean hasUsedZip64;
    private Zip64Mode zip64Mode;
    private final boolean isSplitZip;
    private final Map<Integer, Integer> numberOfCDInDiskData;

    @Override
    public void close() throws IOException {
        try {
            if (!this.finished) {
                this.finish();
            }
        }
        finally {
            this.destroy();
        }
    }

    private byte[] createCentralFileHeader(ZipArchiveEntry ze) throws IOException {
        boolean needsZip64Extra;
        EntryMetaData entryMetaData = this.metaData.get(ze);
        boolean bl = needsZip64Extra = this.hasZip64Extra(ze) || ze.getCompressedSize() >= 0xFFFFFFFFL || ze.getSize() >= 0xFFFFFFFFL || entryMetaData.offset >= 0xFFFFFFFFL || ze.getDiskNumberStart() >= 65535L || this.zip64Mode == Zip64Mode.Always || this.zip64Mode == Zip64Mode.AlwaysWithCompatibility;
        if (needsZip64Extra && this.zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException("Archive's size exceeds the limit of 4GByte.");
        }
        this.handleZip64Extra(ze, entryMetaData.offset, needsZip64Extra);
        return this.createCentralFileHeader(ze, this.getName(ze), entryMetaData, needsZip64Extra);
    }

    private byte[] createCentralFileHeader(ZipArchiveEntry ze, ByteBuffer name, EntryMetaData entryMetaData, boolean needsZip64Extra) throws IOException {
        if (this.isSplitZip) {
            int currentSplitSegment = ((ZipSplitOutputStream)this.outputStream).getCurrentSplitSegmentIndex();
            if (this.numberOfCDInDiskData.get(currentSplitSegment) == null) {
                this.numberOfCDInDiskData.put(currentSplitSegment, 1);
            } else {
                int originalNumberOfCD = this.numberOfCDInDiskData.get(currentSplitSegment);
                this.numberOfCDInDiskData.put(currentSplitSegment, originalNumberOfCD + 1);
            }
        }
        byte[] extra = ze.getCentralDirectoryExtra();
        int extraLength = extra.length;
        String comm = ze.getComment();
        if (comm == null) {
            comm = "";
        }
        ByteBuffer commentB = this.getEntryEncoding(ze).encode(comm);
        int nameLen = name.limit() - name.position();
        int commentLen = commentB.limit() - commentB.position();
        int len = 46 + nameLen + extraLength + commentLen;
        byte[] buf = new byte[len];
        System.arraycopy(CFH_SIG, 0, buf, 0, 4);
        ZipShort.putShort(ze.getPlatform() << 8 | (!this.hasUsedZip64 ? 20 : 45), buf, 4);
        int zipMethod = ze.getMethod();
        boolean encodable = this.zipEncoding.canEncode(ze.getName());
        ZipShort.putShort(this.versionNeededToExtract(zipMethod, needsZip64Extra, entryMetaData.usesDataDescriptor), buf, 6);
        this.getGeneralPurposeBits(!encodable && this.fallbackToUTF8, entryMetaData.usesDataDescriptor).encode(buf, 8);
        ZipShort.putShort(zipMethod, buf, 10);
        ZipUtil.toDosTime(ze.getTime(), buf, 12);
        ZipLong.putLong(ze.getCrc(), buf, 16);
        if (ze.getCompressedSize() >= 0xFFFFFFFFL || ze.getSize() >= 0xFFFFFFFFL || this.zip64Mode == Zip64Mode.Always || this.zip64Mode == Zip64Mode.AlwaysWithCompatibility) {
            ZipLong.ZIP64_MAGIC.putLong(buf, 20);
            ZipLong.ZIP64_MAGIC.putLong(buf, 24);
        } else {
            ZipLong.putLong(ze.getCompressedSize(), buf, 20);
            ZipLong.putLong(ze.getSize(), buf, 24);
        }
        ZipShort.putShort(nameLen, buf, 28);
        ZipShort.putShort(extraLength, buf, 30);
        ZipShort.putShort(commentLen, buf, 32);
        if (this.isSplitZip) {
            if (ze.getDiskNumberStart() >= 65535L || this.zip64Mode == Zip64Mode.Always) {
                ZipShort.putShort(65535, buf, 34);
            } else {
                ZipShort.putShort((int)ze.getDiskNumberStart(), buf, 34);
            }
        } else {
            System.arraycopy(ZERO, 0, buf, 34, 2);
        }
        ZipShort.putShort(ze.getInternalAttributes(), buf, 36);
        ZipLong.putLong(ze.getExternalAttributes(), buf, 38);
        if (entryMetaData.offset >= 0xFFFFFFFFL || this.zip64Mode == Zip64Mode.Always) {
            ZipLong.putLong(0xFFFFFFFFL, buf, 42);
        } else {
            ZipLong.putLong(Math.min(entryMetaData.offset, 0xFFFFFFFFL), buf, 42);
        }
        System.arraycopy(name.array(), name.arrayOffset(), buf, 46, nameLen);
        int extraStart = 46 + nameLen;
        System.arraycopy(extra, 0, buf, extraStart, extraLength);
        int commentStart = extraStart + extraLength;
        System.arraycopy(commentB.array(), commentB.arrayOffset(), buf, commentStart, commentLen);
        return buf;
    }

    void destroy() throws IOException {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        finally {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
    }

    public void finish() throws IOException {
        long cdOverallOffset;
        if (this.finished) {
            throw new IOException("This archive has already been finished");
        }
        if (this.entry != null) {
            throw new IOException("This archive contains unclosed entries.");
        }
        this.cdOffset = cdOverallOffset = this.streamCompressor.getTotalBytesWritten();
        if (this.isSplitZip) {
            ZipSplitOutputStream zipSplitOutputStream = (ZipSplitOutputStream)this.outputStream;
            this.cdOffset = zipSplitOutputStream.getCurrentSplitSegmentBytesWritten();
            this.cdDiskNumberStart = zipSplitOutputStream.getCurrentSplitSegmentIndex();
        }
        this.writeCentralDirectoryInChunks();
        this.cdLength = this.streamCompressor.getTotalBytesWritten() - cdOverallOffset;
        ByteBuffer commentData = this.zipEncoding.encode(this.comment);
        long commentLength = (long)commentData.limit() - (long)commentData.position();
        this.eocdLength = 22L + commentLength;
        this.writeZip64CentralDirectory();
        this.writeCentralDirectoryEnd();
        this.metaData.clear();
        this.entries.clear();
        this.streamCompressor.close();
        if (this.isSplitZip) {
            this.outputStream.close();
        }
        this.finished = true;
    }

    @Override
    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    private ZipEncoding getEntryEncoding(ZipArchiveEntry ze) {
        boolean encodable = this.zipEncoding.canEncode(ze.getName());
        return !encodable && this.fallbackToUTF8 ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
    }

    private GeneralPurposeBit getGeneralPurposeBits(boolean utfFallback, boolean usesDataDescriptor) {
        GeneralPurposeBit b = new GeneralPurposeBit();
        b.useUTF8ForNames(this.useUTF8Flag || utfFallback);
        if (usesDataDescriptor) {
            b.useDataDescriptor(true);
        }
        return b;
    }

    private ByteBuffer getName(ZipArchiveEntry ze) throws IOException {
        return this.getEntryEncoding(ze).encode(ze.getName());
    }

    private Zip64ExtendedInformationExtraField getZip64Extra(ZipArchiveEntry ze) {
        Zip64ExtendedInformationExtraField z64;
        if (this.entry != null) {
            this.entry.causedUseOfZip64 = !this.hasUsedZip64;
        }
        this.hasUsedZip64 = true;
        ZipExtraField extra = ze.getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
        Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = z64 = extra instanceof Zip64ExtendedInformationExtraField ? (Zip64ExtendedInformationExtraField)extra : null;
        if (z64 == null) {
            z64 = new Zip64ExtendedInformationExtraField();
        }
        ze.addAsFirstExtraField(z64);
        return z64;
    }

    private void handleZip64Extra(ZipArchiveEntry ze, long lfhOffset, boolean needsZip64Extra) {
        if (needsZip64Extra) {
            boolean needsToEncodeDiskNumberStart;
            Zip64ExtendedInformationExtraField z64 = this.getZip64Extra(ze);
            if (ze.getCompressedSize() >= 0xFFFFFFFFL || ze.getSize() >= 0xFFFFFFFFL || this.zip64Mode == Zip64Mode.Always || this.zip64Mode == Zip64Mode.AlwaysWithCompatibility) {
                z64.setCompressedSize(new ZipEightByteInteger(ze.getCompressedSize()));
                z64.setSize(new ZipEightByteInteger(ze.getSize()));
            } else {
                z64.setCompressedSize(null);
                z64.setSize(null);
            }
            boolean needsToEncodeLfhOffset = lfhOffset >= 0xFFFFFFFFL || this.zip64Mode == Zip64Mode.Always;
            boolean bl = needsToEncodeDiskNumberStart = ze.getDiskNumberStart() >= 65535L || this.zip64Mode == Zip64Mode.Always;
            if (needsToEncodeLfhOffset || needsToEncodeDiskNumberStart) {
                z64.setRelativeHeaderOffset(new ZipEightByteInteger(lfhOffset));
            }
            if (needsToEncodeDiskNumberStart) {
                z64.setDiskStartNumber(new ZipLong(ze.getDiskNumberStart()));
            }
            ze.setExtra();
        }
    }

    private boolean hasZip64Extra(ZipArchiveEntry ze) {
        return ze.getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID) instanceof Zip64ExtendedInformationExtraField;
    }

    private boolean shouldUseZip64EOCD() {
        int numberOfThisDisk = 0;
        if (this.isSplitZip) {
            numberOfThisDisk = ((ZipSplitOutputStream)this.outputStream).getCurrentSplitSegmentIndex();
        }
        int numOfEntriesOnThisDisk = this.numberOfCDInDiskData.getOrDefault(numberOfThisDisk, 0);
        return numberOfThisDisk >= 65535 || this.cdDiskNumberStart >= 65535L || numOfEntriesOnThisDisk >= 65535 || this.entries.size() >= 65535 || this.cdLength >= 0xFFFFFFFFL || this.cdOffset >= 0xFFFFFFFFL;
    }

    private void validateIfZip64IsNeededInEOCD() throws Zip64RequiredException {
        if (this.zip64Mode != Zip64Mode.Never) {
            return;
        }
        int numberOfThisDisk = 0;
        if (this.isSplitZip) {
            numberOfThisDisk = ((ZipSplitOutputStream)this.outputStream).getCurrentSplitSegmentIndex();
        }
        if (numberOfThisDisk >= 65535) {
            throw new Zip64RequiredException("Number of the disk of End Of Central Directory exceeds the limit of 65535.");
        }
        if (this.cdDiskNumberStart >= 65535L) {
            throw new Zip64RequiredException("Number of the disk with the start of Central Directory exceeds the limit of 65535.");
        }
        int numOfEntriesOnThisDisk = this.numberOfCDInDiskData.getOrDefault(numberOfThisDisk, 0);
        if (numOfEntriesOnThisDisk >= 65535) {
            throw new Zip64RequiredException("Number of entries on this disk exceeds the limit of 65535.");
        }
        if (this.entries.size() >= 65535) {
            throw new Zip64RequiredException("Archive contains more than 65535 entries.");
        }
        if (this.cdLength >= 0xFFFFFFFFL) {
            throw new Zip64RequiredException("The size of the entire central directory exceeds the limit of 4GByte.");
        }
        if (this.cdOffset >= 0xFFFFFFFFL) {
            throw new Zip64RequiredException("Archive's size exceeds the limit of 4GByte.");
        }
    }

    private int versionNeededToExtract(int zipMethod, boolean zip64, boolean usedDataDescriptor) {
        if (zip64) {
            return 45;
        }
        if (usedDataDescriptor) {
            return 20;
        }
        return this.versionNeededToExtractMethod(zipMethod);
    }

    private int versionNeededToExtractMethod(int zipMethod) {
        return zipMethod == 8 ? 20 : 10;
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        if (this.entry == null) {
            throw new IllegalStateException("No current entry");
        }
        ZipUtil.checkRequestedFeatures(this.entry.entry);
        long writtenThisTime = this.streamCompressor.write(b, offset, length, this.entry.entry.getMethod());
        this.count(writtenThisTime);
    }

    protected void writeCentralDirectoryEnd() throws IOException {
        if (!this.hasUsedZip64 && this.isSplitZip) {
            ((ZipSplitOutputStream)this.outputStream).prepareToWriteUnsplittableContent(this.eocdLength);
        }
        this.validateIfZip64IsNeededInEOCD();
        this.writeCounted(EOCD_SIG);
        int numberOfThisDisk = 0;
        if (this.isSplitZip) {
            numberOfThisDisk = ((ZipSplitOutputStream)this.outputStream).getCurrentSplitSegmentIndex();
        }
        this.writeCounted(ZipShort.getBytes(numberOfThisDisk));
        this.writeCounted(ZipShort.getBytes((int)this.cdDiskNumberStart));
        int numberOfEntries = this.entries.size();
        int numOfEntriesOnThisDisk = this.isSplitZip ? this.numberOfCDInDiskData.getOrDefault(numberOfThisDisk, 0) : numberOfEntries;
        byte[] numOfEntriesOnThisDiskData = ZipShort.getBytes(Math.min(numOfEntriesOnThisDisk, 65535));
        this.writeCounted(numOfEntriesOnThisDiskData);
        byte[] num = ZipShort.getBytes(Math.min(numberOfEntries, 65535));
        this.writeCounted(num);
        this.writeCounted(ZipLong.getBytes(Math.min(this.cdLength, 0xFFFFFFFFL)));
        this.writeCounted(ZipLong.getBytes(Math.min(this.cdOffset, 0xFFFFFFFFL)));
        ByteBuffer data = this.zipEncoding.encode(this.comment);
        int dataLen = data.limit() - data.position();
        this.writeCounted(ZipShort.getBytes(dataLen));
        this.streamCompressor.writeCounted(data.array(), data.arrayOffset(), dataLen);
    }

    private void writeCentralDirectoryInChunks() throws IOException {
        int NUM_PER_WRITE = 1000;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(70000);
        int count = 0;
        for (ZipArchiveEntry ze : this.entries) {
            byteArrayOutputStream.write(this.createCentralFileHeader(ze));
            if (++count <= 1000) continue;
            this.writeCounted(byteArrayOutputStream.toByteArray());
            byteArrayOutputStream.reset();
            count = 0;
        }
        this.writeCounted(byteArrayOutputStream.toByteArray());
    }

    private void writeCounted(byte[] data) throws IOException {
        this.streamCompressor.writeCounted(data);
    }

    protected final void writeOut(byte[] data) throws IOException {
        this.streamCompressor.writeOut(data, 0, data.length);
    }

    protected void writeZip64CentralDirectory() throws IOException {
        if (this.zip64Mode == Zip64Mode.Never) {
            return;
        }
        if (!this.hasUsedZip64 && this.shouldUseZip64EOCD()) {
            this.hasUsedZip64 = true;
        }
        if (!this.hasUsedZip64) {
            return;
        }
        long offset = this.streamCompressor.getTotalBytesWritten();
        long diskNumberStart = 0L;
        if (this.isSplitZip) {
            ZipSplitOutputStream zipSplitOutputStream = (ZipSplitOutputStream)this.outputStream;
            offset = zipSplitOutputStream.getCurrentSplitSegmentBytesWritten();
            diskNumberStart = zipSplitOutputStream.getCurrentSplitSegmentIndex();
        }
        this.writeOut(ZIP64_EOCD_SIG);
        this.writeOut(ZipEightByteInteger.getBytes(44L));
        this.writeOut(ZipShort.getBytes(45));
        this.writeOut(ZipShort.getBytes(45));
        int numberOfThisDisk = 0;
        if (this.isSplitZip) {
            numberOfThisDisk = ((ZipSplitOutputStream)this.outputStream).getCurrentSplitSegmentIndex();
        }
        this.writeOut(ZipLong.getBytes(numberOfThisDisk));
        this.writeOut(ZipLong.getBytes(this.cdDiskNumberStart));
        int numOfEntriesOnThisDisk = this.isSplitZip ? this.numberOfCDInDiskData.getOrDefault(numberOfThisDisk, 0).intValue() : this.entries.size();
        byte[] numOfEntriesOnThisDiskData = ZipEightByteInteger.getBytes(numOfEntriesOnThisDisk);
        this.writeOut(numOfEntriesOnThisDiskData);
        byte[] num = ZipEightByteInteger.getBytes(this.entries.size());
        this.writeOut(num);
        this.writeOut(ZipEightByteInteger.getBytes(this.cdLength));
        this.writeOut(ZipEightByteInteger.getBytes(this.cdOffset));
        if (this.isSplitZip) {
            int zip64EOCDLOCLength = 20;
            long unsplittableContentSize = 20L + this.eocdLength;
            ((ZipSplitOutputStream)this.outputStream).prepareToWriteUnsplittableContent(unsplittableContentSize);
        }
        this.writeOut(ZIP64_EOCD_LOC_SIG);
        this.writeOut(ZipLong.getBytes(diskNumberStart));
        this.writeOut(ZipEightByteInteger.getBytes(offset));
        if (this.isSplitZip) {
            int totalNumberOfDisks = ((ZipSplitOutputStream)this.outputStream).getCurrentSplitSegmentIndex() + 1;
            this.writeOut(ZipLong.getBytes(totalNumberOfDisks));
        } else {
            this.writeOut(ONE);
        }
    }

    private static final class CurrentEntry {
        private final ZipArchiveEntry entry;
        private boolean causedUseOfZip64;
    }

    private static final class EntryMetaData {
        private final long offset;
        private final boolean usesDataDescriptor;
    }
}

