/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.commonscompress.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.util.List;

public class MultiReadOnlySeekableByteChannel
implements SeekableByteChannel {
    private static final Path[] EMPTY_PATH_ARRAY = new Path[0];
    private final List<SeekableByteChannel> channels;
    private long globalPosition;
    private int currentChannelIdx;

    @Override
    public void close() throws IOException {
        IOException first = null;
        for (SeekableByteChannel ch : this.channels) {
            try {
                ch.close();
            }
            catch (IOException ex) {
                if (first != null) continue;
                first = ex;
            }
        }
        if (first != null) {
            throw new IOException("failed to close wrapped channel", first);
        }
    }

    @Override
    public boolean isOpen() {
        return this.channels.stream().allMatch(Channel::isOpen);
    }

    @Override
    public long position() {
        return this.globalPosition;
    }

    @Override
    public synchronized SeekableByteChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("Negative position: " + newPosition);
        }
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.globalPosition = newPosition;
        long pos = newPosition;
        for (int i = 0; i < this.channels.size(); ++i) {
            long newChannelPos;
            SeekableByteChannel currentChannel = this.channels.get(i);
            long size = currentChannel.size();
            if (pos == -1L) {
                newChannelPos = 0L;
            } else if (pos <= size) {
                this.currentChannelIdx = i;
                long tmp = pos;
                pos = -1L;
                newChannelPos = tmp;
            } else {
                pos -= size;
                newChannelPos = size;
            }
            currentChannel.position(newChannelPos);
        }
        return this;
    }

    public synchronized SeekableByteChannel position(long channelNumber, long relativeOffset) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        long globalPosition = relativeOffset;
        int i = 0;
        while ((long)i < channelNumber) {
            globalPosition += this.channels.get(i).size();
            ++i;
        }
        return this.position(globalPosition);
    }

    @Override
    public synchronized int read(ByteBuffer dst) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!dst.hasRemaining()) {
            return 0;
        }
        int totalBytesRead = 0;
        while (dst.hasRemaining() && this.currentChannelIdx < this.channels.size()) {
            SeekableByteChannel currentChannel = this.channels.get(this.currentChannelIdx);
            int newBytesRead = currentChannel.read(dst);
            if (newBytesRead == -1) {
                ++this.currentChannelIdx;
                continue;
            }
            if (currentChannel.position() >= currentChannel.size()) {
                ++this.currentChannelIdx;
            }
            totalBytesRead += newBytesRead;
        }
        if (totalBytesRead > 0) {
            this.globalPosition += (long)totalBytesRead;
            return totalBytesRead;
        }
        return -1;
    }

    @Override
    public long size() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        long acc2 = 0L;
        for (SeekableByteChannel ch : this.channels) {
            acc2 += ch.size();
        }
        return acc2;
    }

    @Override
    public SeekableByteChannel truncate(long size) {
        throw new NonWritableChannelException();
    }

    @Override
    public int write(ByteBuffer src) {
        throw new NonWritableChannelException();
    }
}

