/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache;

import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.Serializable;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.Seq;
import coursierapi.shaded.scala.collection.Seq$;
import coursierapi.shaded.scala.collection.TraversableOnce;

public abstract class ArtifactError
extends Exception {
    private final String type;
    private final String message;

    public String describe() {
        return this.getMessage();
    }

    public final boolean notFound() {
        ArtifactError artifactError = this;
        return artifactError instanceof NotFound;
    }

    public final boolean forbidden() {
        ArtifactError artifactError = this;
        return artifactError instanceof Forbidden;
    }

    public ArtifactError(String type, String message, Option<Throwable> parentOpt) {
        this.type = type;
        this.message = message;
        super(new StringBuilder(2).append(type).append(": ").append(message).toString(), (Throwable)parentOpt.orNull(Predef$.MODULE$.$conforms()));
    }

    public ArtifactError(String type, String message) {
        this(type, message, None$.MODULE$);
    }

    public static final class ChecksumErrors
    extends ArtifactError {
        private final Seq<Tuple2<String, String>> errors;

        public ChecksumErrors(Seq<Tuple2<String, String>> errors) {
            this.errors = errors;
            super("checksum errors", ((TraversableOnce)errors.map(new Serializable(){

                public final String apply(Tuple2<String, String> x0$1) {
                    Tuple2<String, String> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = tuple2._1();
                        String v = tuple2._2();
                        return new StringBuilder(2).append(k).append(": ").append(v).toString();
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(", "));
        }
    }

    public static final class ChecksumFormatError
    extends ArtifactError {
        private final String sumType;
        private final String file;

        public ChecksumFormatError(String sumType, String file) {
            this.sumType = sumType;
            this.file = file;
            super("checksum format error", file);
        }
    }

    public static final class ChecksumNotFound
    extends ArtifactError {
        private final String sumType;
        private final String file;

        public ChecksumNotFound(String sumType, String file) {
            this.sumType = sumType;
            this.file = file;
            super("checksum not found", file);
        }
    }

    public static final class DownloadError
    extends ArtifactError {
        public DownloadError(String reason, Option<Throwable> e) {
            super("download error", reason, e);
        }
    }

    public static final class FileTooOldOrNotFound
    extends ArtifactError {
        private final String file;

        public FileTooOldOrNotFound(String file) {
            this.file = file;
            super("file in cache not found or too old", file);
        }
    }

    public static final class Forbidden
    extends ArtifactError {
        private final String file;

        public Forbidden(String file) {
            this.file = file;
            super("forbidden", file);
        }
    }

    public static final class ForbiddenChangingArtifact
    extends ArtifactError {
        private final String url;

        public ForbiddenChangingArtifact(String url) {
            this.url = url;
            super("changing artifact found", url);
        }
    }

    public static final class NotFound
    extends ArtifactError {
        private final String file;
        private final Option<Object> permanent;

        public Option<Object> permanent() {
            return this.permanent;
        }

        public NotFound(String file, Option<Object> permanent) {
            this.file = file;
            this.permanent = permanent;
            super("not found", file);
        }
    }

    public static final class Unauthorized
    extends ArtifactError {
        private final String file;
        private final Option<String> realm;

        public Unauthorized(String file, Option<String> realm2) {
            this.file = file;
            this.realm = realm2;
            super("unauthorized", new StringBuilder(0).append(file).append((Object)realm2.fold(new Serializable(){

                public final String apply() {
                    return "";
                }
            }, new Serializable(){

                public final String apply(String x$1) {
                    return new StringBuilder(3).append(" (").append(x$1).append(")").toString();
                }
            })).toString());
        }
    }

    public static final class WrongChecksum
    extends ArtifactError {
        private final String sumType;
        private final String got;
        private final String expected;
        private final String file;
        private final String sumFile;

        public String sumFile() {
            return this.sumFile;
        }

        public WrongChecksum(String sumType, String got, String expected, String file, String sumFile) {
            this.sumType = sumType;
            this.got = got;
            this.expected = expected;
            this.file = file;
            this.sumFile = sumFile;
            super("wrong checksum", new StringBuilder(23).append(file).append(" (expected ").append(sumType).append(" ").append(expected).append(" in ").append(sumFile).append(", got ").append(got).append(")").toString());
        }
    }

    public static final class WrongLength
    extends ArtifactError {
        private final long got;
        private final long expected;
        private final String file;

        public WrongLength(long got, long expected, String file) {
            this.got = got;
            this.expected = expected;
            this.file = file;
            super("wrong length", new StringBuilder(22).append(file).append(" (expected ").append(expected).append(" B, got ").append(got).append(" B)").toString());
        }
    }
}

