/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache;

import coursierapi.shaded.coursier.cache.CachePolicy;
import coursierapi.shaded.coursier.cache.CachePolicy$LocalOnly$;
import coursierapi.shaded.coursier.cache.CachePolicy$LocalUpdateChanging$;
import coursierapi.shaded.coursier.cache.CachePolicy$Update$;
import coursierapi.shaded.coursier.cache.internal.TmpConfig$;
import coursierapi.shaded.coursier.credentials.Credentials;
import coursierapi.shaded.coursier.credentials.FileCredentials;
import coursierapi.shaded.coursier.credentials.FileCredentials$;
import coursierapi.shaded.coursier.parse.CachePolicyParser$;
import coursierapi.shaded.coursier.parse.CredentialsParser$;
import coursierapi.shaded.coursier.paths.CachePath;
import coursierapi.shaded.coursier.paths.CoursierPaths;
import coursierapi.shaded.coursier.util.Sync$;
import coursierapi.shaded.scala.Console$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.cli.config.ConfigDb;
import coursierapi.shaded.scala.cli.config.ConfigDb$;
import coursierapi.shaded.scala.collection.GenSeq;
import coursierapi.shaded.scala.collection.Seq;
import coursierapi.shaded.scala.collection.Seq$;
import coursierapi.shaded.scala.collection.SeqLike;
import coursierapi.shaded.scala.collection.TraversableLike;
import coursierapi.shaded.scala.collection.immutable.$colon$colon;
import coursierapi.shaded.scala.collection.immutable.List;
import coursierapi.shaded.scala.collection.immutable.Nil$;
import coursierapi.shaded.scala.collection.immutable.StringOps;
import coursierapi.shaded.scala.collection.mutable.ArrayOps;
import coursierapi.shaded.scala.concurrent.duration.Duration;
import coursierapi.shaded.scala.concurrent.duration.Duration$;
import coursierapi.shaded.scala.concurrent.duration.FiniteDuration;
import coursierapi.shaded.scala.concurrent.duration.package;
import coursierapi.shaded.scala.concurrent.duration.package$;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Nothing$;
import coursierapi.shaded.scala.runtime.RichChar$;
import coursierapi.shaded.scala.runtime.java8.JFunction0$mcD$sp;
import coursierapi.shaded.scala.runtime.java8.JFunction0$mcI$sp;
import coursierapi.shaded.scala.runtime.java8.JFunction1$mcZD$sp;
import coursierapi.shaded.scala.runtime.java8.JFunction1$mcZI$sp;
import coursierapi.shaded.scala.util.Either;
import coursierapi.shaded.scala.util.Failure;
import coursierapi.shaded.scala.util.Left;
import coursierapi.shaded.scala.util.Right;
import coursierapi.shaded.scala.util.Success;
import coursierapi.shaded.scala.util.Try;
import coursierapi.shaded.scala.util.Try$;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;

public final class CacheDefaults$ {
    public static CacheDefaults$ MODULE$;
    private File location;
    private File archiveCacheLocation;
    private int concurrentDownloadCount;
    private ExecutorService pool;
    private Option<Duration> ttl;
    private int retryCount;
    private FiniteDuration retryBackoffInitialDelay;
    private double retryBackoffMultiplier;
    private Option<Object> maxRedirections;
    private final Seq<Option<String>> checksums;
    private final int bufferSize;
    private final Seq<CachePolicy.Mixed> noEnvCachePolicies;
    private volatile int bitmap$0;

    static {
        new CacheDefaults$();
    }

    private File location$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.location = CachePath.defaultCacheDirectory();
                this.bitmap$0 |= 1;
            }
        }
        return this.location;
    }

    public File location() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.location$lzycompute();
        }
        return this.location;
    }

    private File archiveCacheLocation$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((this.bitmap$0 & 2) == 0) {
                this.archiveCacheLocation = CachePath.defaultArchiveCacheDirectory();
                this.bitmap$0 |= 2;
            }
        }
        return this.archiveCacheLocation;
    }

    public File archiveCacheLocation() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.archiveCacheLocation$lzycompute();
        }
        return this.archiveCacheLocation;
    }

    private int defaultConcurrentDownloadCount() {
        return 6;
    }

    private int concurrentDownloadCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((this.bitmap$0 & 4) == 0) {
                this.concurrentDownloadCount = BoxesRunTime.unboxToInt(coursierapi.shaded.scala.sys.package$.MODULE$.props().get("coursierapi.shaded.coursier.parallel-download-count").flatMap((Function1<String, Option> & Serializable & coursierapi.shaded.scala.Serializable)s -> Try$.MODULE$.apply((JFunction0$mcI$sp & coursierapi.shaded.scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString((String)s)).toInt()).toOption()).getOrElse((JFunction0$mcI$sp & coursierapi.shaded.scala.Serializable)() -> MODULE$.defaultConcurrentDownloadCount()));
                this.bitmap$0 |= 4;
            }
        }
        return this.concurrentDownloadCount;
    }

    public int concurrentDownloadCount() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.concurrentDownloadCount$lzycompute();
        }
        return this.concurrentDownloadCount;
    }

    private ExecutorService pool$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((this.bitmap$0 & 8) == 0) {
                this.pool = Sync$.MODULE$.fixedThreadPool(this.concurrentDownloadCount());
                this.bitmap$0 |= 8;
            }
        }
        return this.pool;
    }

    public ExecutorService pool() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.pool$lzycompute();
        }
        return this.pool;
    }

    public Either<Throwable, Duration> parseDuration(String s) {
        if (new StringOps(Predef$.MODULE$.augmentString(s)).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(s)).forall((Function1<Object, Object> & Serializable & coursierapi.shaded.scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(CacheDefaults$.$anonfun$parseDuration$1(BoxesRunTime.unboxToChar(x$1))))) {
            return coursierapi.shaded.scala.package$.MODULE$.Right().apply(Duration$.MODULE$.Zero());
        }
        Try try_ = Try$.MODULE$.apply((Function0<Duration> & Serializable & coursierapi.shaded.scala.Serializable)() -> Duration$.MODULE$.apply(s));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Duration s2 = (Duration)success.value();
            return coursierapi.shaded.scala.package$.MODULE$.Right().apply(s2);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            return coursierapi.shaded.scala.package$.MODULE$.Left().apply(t);
        }
        throw new MatchError(try_);
    }

    private Option<Duration> ttl$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((this.bitmap$0 & 0x10) == 0) {
                Option fromEnv = Option$.MODULE$.apply(System.getenv("COURSIER_TTL")).flatMap((Function1<String, Option> & Serializable & coursierapi.shaded.scala.Serializable)x$2 -> MODULE$.parseDuration((String)x$2).toOption());
                this.ttl = fromEnv.orElse((Function0<Option> & Serializable & coursierapi.shaded.scala.Serializable)() -> CacheDefaults$.fromProps$1()).orElse((Function0<Some> & Serializable & coursierapi.shaded.scala.Serializable)() -> new Some<FiniteDuration>(CacheDefaults$.default$1()));
                this.bitmap$0 |= 0x10;
            }
        }
        return this.ttl;
    }

    public Option<Duration> ttl() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.ttl$lzycompute();
        }
        return this.ttl;
    }

    public Seq<Option<String>> checksums() {
        return this.checksums;
    }

    public int defaultRetryCount() {
        return 5;
    }

    private FiniteDuration defaultRetryBackoffInitialDelay() {
        return new package.DurationInt(package$.MODULE$.DurationInt(10)).milliseconds();
    }

    private double defaultRetryBackoffMultiplier() {
        return 2.0;
    }

    private int retryCount$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.retryCount = BoxesRunTime.unboxToInt(coursierapi.shaded.scala.sys.package$.MODULE$.props().get("coursierapi.shaded.coursier.exception-retry").flatMap((Function1<String, Option> & Serializable & coursierapi.shaded.scala.Serializable)s -> Try$.MODULE$.apply((JFunction0$mcI$sp & coursierapi.shaded.scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString((String)s)).toInt()).toOption()).filter((JFunction1$mcZI$sp & coursierapi.shaded.scala.Serializable)x$4 -> x$4 >= 0).getOrElse((JFunction0$mcI$sp & coursierapi.shaded.scala.Serializable)() -> MODULE$.defaultRetryCount()));
                this.bitmap$0 |= 0x20;
            }
        }
        return this.retryCount;
    }

    public int retryCount() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.retryCount$lzycompute();
        }
        return this.retryCount;
    }

    private FiniteDuration retryBackoffInitialDelay$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.retryBackoffInitialDelay = (FiniteDuration)coursierapi.shaded.scala.sys.package$.MODULE$.props().get("coursierapi.shaded.coursier.exception-retry-backoff-initial-delay").flatMap((Function1<String, Option> & Serializable & coursierapi.shaded.scala.Serializable)s -> MODULE$.parseDuration((String)s).toOption()).collect(new coursierapi.shaded.scala.Serializable(){

                    public final <A1 extends Duration, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof FiniteDuration) {
                            FiniteDuration finiteDuration = (FiniteDuration)A1;
                            return (B1)finiteDuration;
                        }
                        return function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Duration x1) {
                        Duration duration = x1;
                        return duration instanceof FiniteDuration;
                    }
                }).getOrElse((Function0<FiniteDuration> & Serializable & coursierapi.shaded.scala.Serializable)() -> MODULE$.defaultRetryBackoffInitialDelay());
                this.bitmap$0 |= 0x40;
            }
        }
        return this.retryBackoffInitialDelay;
    }

    public FiniteDuration retryBackoffInitialDelay() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.retryBackoffInitialDelay$lzycompute();
        }
        return this.retryBackoffInitialDelay;
    }

    private double retryBackoffMultiplier$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.retryBackoffMultiplier = BoxesRunTime.unboxToDouble(coursierapi.shaded.scala.sys.package$.MODULE$.props().get("coursierapi.shaded.coursier.exception-retry-backoff-multiplier").flatMap((Function1<String, Option> & Serializable & coursierapi.shaded.scala.Serializable)s -> Try$.MODULE$.apply((JFunction0$mcD$sp & coursierapi.shaded.scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString((String)s)).toDouble()).toOption()).filter((JFunction1$mcZD$sp & coursierapi.shaded.scala.Serializable)x$5 -> x$5 > 0.0).getOrElse((JFunction0$mcD$sp & coursierapi.shaded.scala.Serializable)() -> MODULE$.defaultRetryBackoffMultiplier()));
                this.bitmap$0 |= 0x80;
            }
        }
        return this.retryBackoffMultiplier;
    }

    public double retryBackoffMultiplier() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.retryBackoffMultiplier$lzycompute();
        }
        return this.retryBackoffMultiplier;
    }

    private Option<Object> defaultMaxRedirections() {
        return Option$.MODULE$.apply(BoxesRunTime.boxToInteger(20));
    }

    private Option<Object> maxRedirections$lzycompute() {
        CacheDefaults$ cacheDefaults$ = this;
        synchronized (cacheDefaults$) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.maxRedirections = CacheDefaults$.prop$1("coursierapi.shaded.coursier.http.maxRedirects").orElse((Function0<Option> & Serializable & coursierapi.shaded.scala.Serializable)() -> CacheDefaults$.prop$1("http.maxRedirects")).orElse((Function0<Option> & Serializable & coursierapi.shaded.scala.Serializable)() -> MODULE$.defaultMaxRedirections());
                this.bitmap$0 |= 0x100;
            }
        }
        return this.maxRedirections;
    }

    public Option<Object> maxRedirections() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.maxRedirections$lzycompute();
        }
        return this.maxRedirections;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    private Option<String> credentialPropOpt() {
        return Option$.MODULE$.apply(System.getenv("COURSIER_CREDENTIALS")).orElse((Function0<Option> & Serializable & coursierapi.shaded.scala.Serializable)() -> coursierapi.shaded.scala.sys.package$.MODULE$.props().get("coursierapi.shaded.coursier.credentials")).map((Function1<String, String> & Serializable & coursierapi.shaded.scala.Serializable)s -> (String)new StringOps(Predef$.MODULE$.augmentString((String)s)).dropWhile((Function1<Object, Object> & Serializable & coursierapi.shaded.scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean(RichChar$.MODULE$.isSpaceChar$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar(x$8))))));
    }

    private boolean isPropFile(String s) {
        return s.startsWith("/") || s.startsWith("file:");
    }

    public Seq<Credentials> credentials() {
        Seq seq;
        if (this.credentialPropOpt().isEmpty()) {
            GenSeq configDirs = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])CoursierPaths.configDirectories())).toSeq();
            Seq mainCredentialsFiles = configDirs.map((Function1<File, File> & Serializable & coursierapi.shaded.scala.Serializable)configDir -> new File((File)configDir, "credentials.properties"), Seq$.MODULE$.canBuildFrom());
            Seq dirs = configDirs.map((Function1<File, File> & Serializable & coursierapi.shaded.scala.Serializable)configDir -> new File((File)configDir, "credentials"), Seq$.MODULE$.canBuildFrom());
            Seq files = dirs.flatMap((Function1<File, Seq> & Serializable & coursierapi.shaded.scala.Serializable)dir2 -> {
                File[] listOrNull = dir2.listFiles((dir, name) -> !name.startsWith(".") && name.endsWith(".properties"));
                return (Seq)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(listOrNull)).toSeq().flatten((Function1<File[], Object> & Serializable & coursierapi.shaded.scala.Serializable)xs -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])xs)));
            }, Seq$.MODULE$.canBuildFrom());
            Seq otherFiles = ((TraversableLike)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(files)).toSeq().flatten(Predef$.MODULE$.$conforms())).map((Function1<File, FileCredentials> & Serializable & coursierapi.shaded.scala.Serializable)f -> FileCredentials$.MODULE$.apply(f.getAbsolutePath(), true), Seq$.MODULE$.canBuildFrom());
            seq = ((TraversableLike)mainCredentialsFiles.map((Function1<File, FileCredentials> & Serializable & coursierapi.shaded.scala.Serializable)f -> FileCredentials$.MODULE$.apply(f.getAbsolutePath(), true), Seq$.MODULE$.canBuildFrom())).$plus$plus(otherFiles, Seq$.MODULE$.canBuildFrom());
        } else {
            seq = Option$.MODULE$.option2Iterable(this.credentialPropOpt()).toSeq().flatMap((Function1<String, Seq> & Serializable & coursierapi.shaded.scala.Serializable)x0$1 -> {
                String string = x0$1;
                if (MODULE$.isPropFile(string)) {
                    String path0 = string.startsWith("file:") ? new File(new URI(string)).getAbsolutePath() : string;
                    return new $colon$colon<Nothing$>((Nothing$)((Object)FileCredentials$.MODULE$.apply(path0, true)), Nil$.MODULE$);
                }
                return (Seq)CredentialsParser$.MODULE$.parseSeq(string).either().toSeq().flatten(Predef$.MODULE$.$conforms());
            }, Seq$.MODULE$.canBuildFrom());
        }
        Seq legacyCredentials = seq;
        Path configPath = CoursierPaths.scalaConfigFile();
        Seq<Credentials> configCredentials = this.credentialsFromConfig(configPath);
        return configCredentials.$plus$plus(legacyCredentials, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Credentials> credentialsFromConfig(Path configPath) {
        ConfigDb configDb = (ConfigDb)ConfigDb$.MODULE$.open(configPath).fold((Function1<Exception, Nothing$> & Serializable & coursierapi.shaded.scala.Serializable)e -> {
            throw new Exception((Throwable)e);
        }, (Function1<ConfigDb, ConfigDb> & Serializable & coursierapi.shaded.scala.Serializable)x -> Predef$.MODULE$.identity(x));
        return (Seq)configDb.get(TmpConfig$.MODULE$.credentialsKey()).fold((Function1<ConfigDb.ConfigDbFormatError, Nothing$> & Serializable & coursierapi.shaded.scala.Serializable)e -> {
            throw new Exception((Throwable)e);
        }, (Function1<Option, List> & Serializable & coursierapi.shaded.scala.Serializable)x$9 -> (List)x$9.getOrElse((Function0<Nil$> & Serializable & coursierapi.shaded.scala.Serializable)() -> Nil$.MODULE$));
    }

    public Seq<CachePolicy.Mixed> noEnvCachePolicies() {
        return this.noEnvCachePolicies;
    }

    public Seq<CachePolicy> cachePolicies() {
        Option fromEnv = CacheDefaults$.fromOption$1(Option$.MODULE$.apply(System.getenv("COURSIER_MODE")), "COURSIER_MODE environment variable");
        return (Seq)fromEnv.orElse((Function0<Option> & Serializable & coursierapi.shaded.scala.Serializable)() -> CacheDefaults$.fromProps$2()).getOrElse((Function0<Seq> & Serializable & coursierapi.shaded.scala.Serializable)() -> MODULE$.noEnvCachePolicies());
    }

    public static final /* synthetic */ boolean $anonfun$parseDuration$1(char x$1) {
        return x$1 == '0';
    }

    private static final Option fromProps$1() {
        return coursierapi.shaded.scala.sys.package$.MODULE$.props().get("coursierapi.shaded.coursier.ttl").flatMap((Function1<String, Option> & Serializable & coursierapi.shaded.scala.Serializable)x$3 -> MODULE$.parseDuration((String)x$3).toOption());
    }

    private static final FiniteDuration default$1() {
        return new package.DurationInt(package$.MODULE$.DurationInt(24)).hours();
    }

    private static final Option prop$1(String name) {
        return coursierapi.shaded.scala.sys.package$.MODULE$.props().get(name).flatMap((Function1<String, Option> & Serializable & coursierapi.shaded.scala.Serializable)s -> Try$.MODULE$.apply((JFunction0$mcI$sp & coursierapi.shaded.scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString((String)s)).toInt()).toOption()).filter((JFunction1$mcZI$sp & coursierapi.shaded.scala.Serializable)x$7 -> x$7 >= 0);
    }

    public static final /* synthetic */ boolean $anonfun$cachePolicies$1(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).nonEmpty();
    }

    private static final Option fromOption$1(Option value, String description) {
        return value.filter((Function1<String, Object> & Serializable & coursierapi.shaded.scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean(CacheDefaults$.$anonfun$cachePolicies$1(x$10))).flatMap((Function1<String, Option> & Serializable & coursierapi.shaded.scala.Serializable)str -> {
            boolean bl = false;
            Right right = null;
            Either<$colon$colon<String>, Seq<CachePolicy>> either = CachePolicyParser$.MODULE$.cachePolicies((String)str, MODULE$.noEnvCachePolicies()).either();
            if (either instanceof Right) {
                bl = true;
                right = (Right)either;
                Seq seq = (Seq)right.value();
                Some<Seq> some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
                    Console$.MODULE$.err().println(new StringBuilder(40).append("Warning: no mode found in ").append(description).append(", ignoring it.").toString());
                    return None$.MODULE$;
                }
            }
            if (bl) {
                Seq policies = (Seq)right.value();
                return new Some<Seq>(policies);
            }
            if (either instanceof Left) {
                Console$.MODULE$.err().println(new StringBuilder(44).append("Warning: unrecognized mode in ").append(description).append(", ignoring it.").toString());
                return None$.MODULE$;
            }
            throw new MatchError(either);
        });
    }

    private static final Option fromProps$2() {
        return CacheDefaults$.fromOption$1(coursierapi.shaded.scala.sys.package$.MODULE$.props().get("coursierapi.shaded.coursier.mode"), "Java property coursier.mode");
    }

    private CacheDefaults$() {
        MODULE$ = this;
        this.checksums = new $colon$colon<Nothing$>((Nothing$)((Object)new Some<String>("SHA-1")), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)None$.MODULE$), Nil$.MODULE$));
        this.bufferSize = 0x100000;
        this.noEnvCachePolicies = new $colon$colon<Nothing$>((Nothing$)((Object)CachePolicy$LocalUpdateChanging$.MODULE$), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)CachePolicy$LocalOnly$.MODULE$), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)CachePolicy$Update$.MODULE$), Nil$.MODULE$)));
    }
}

