/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache.internal;

import coursierapi.shaded.coursier.cache.ArtifactError;
import coursierapi.shaded.coursier.cache.ArtifactError$NotFound$;
import coursierapi.shaded.coursier.cache.CacheDefaults$;
import coursierapi.shaded.coursier.cache.CacheLocks$;
import coursierapi.shaded.coursier.cache.CacheLogger;
import coursierapi.shaded.coursier.cache.CachePolicy;
import coursierapi.shaded.coursier.cache.CacheUrl$;
import coursierapi.shaded.coursier.cache.ConnectionBuilder$;
import coursierapi.shaded.coursier.cache.internal.Downloader;
import coursierapi.shaded.coursier.cache.internal.Downloader$UnknownProtocol$;
import coursierapi.shaded.coursier.cache.internal.Retry;
import coursierapi.shaded.coursier.core.Authentication;
import coursierapi.shaded.coursier.credentials.DirectCredentials;
import coursierapi.shaded.coursier.util.Artifact;
import coursierapi.shaded.coursier.util.Sync;
import coursierapi.shaded.scala.Array$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.PartialFunction;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.Seq;
import coursierapi.shaded.scala.collection.immutable.$colon$colon;
import coursierapi.shaded.scala.collection.immutable.List;
import coursierapi.shaded.scala.collection.immutable.Nil$;
import coursierapi.shaded.scala.concurrent.duration.Duration;
import coursierapi.shaded.scala.package$;
import coursierapi.shaded.scala.reflect.ClassTag$;
import coursierapi.shaded.scala.runtime.BoxedUnit;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Nothing$;
import coursierapi.shaded.scala.runtime.java8.JFunction0$mcB$sp;
import coursierapi.shaded.scala.runtime.java8.JFunction1$mcZJ$sp;
import coursierapi.shaded.scala.util.Either;
import coursierapi.shaded.scala.util.Left;
import coursierapi.shaded.scala.util.Properties$;
import coursierapi.shaded.scala.util.control.NonFatal$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.nio.file.AccessDeniedException;
import java.time.Clock;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;

public final class Downloader$
implements coursierapi.shaded.scala.Serializable {
    public static Downloader$ MODULE$;
    private boolean throwExceptions;
    private final Seq<String> coursier$cache$internal$Downloader$$checksumHeader;
    private volatile boolean bitmap$0;

    static {
        new Downloader$();
    }

    private boolean throwExceptions$lzycompute() {
        Downloader$ downloader$ = this;
        synchronized (downloader$) {
            if (!this.bitmap$0) {
                this.throwExceptions = Boolean.getBoolean("coursierapi.shaded.coursier.cache.throw-exceptions");
                this.bitmap$0 = true;
            }
        }
        return this.throwExceptions;
    }

    public boolean throwExceptions() {
        if (!this.bitmap$0) {
            return this.throwExceptions$lzycompute();
        }
        return this.throwExceptions;
    }

    public Seq<String> coursier$cache$internal$Downloader$$checksumHeader() {
        return this.coursier$cache$internal$Downloader$$checksumHeader;
    }

    public void coursier$cache$internal$Downloader$$readFullyTo(InputStream in, OutputStream out, CacheLogger logger, String url, long alreadyDownloaded, int bufferSize) {
        byte[] b = (byte[])Array$.MODULE$.fill(bufferSize, (JFunction0$mcB$sp & coursierapi.shaded.scala.Serializable)() -> 0, ClassTag$.MODULE$.Byte());
        this.helper$1(alreadyDownloaded, in, b, out, logger, url);
    }

    public <T> Either<ArtifactError, T> coursier$cache$internal$Downloader$$downloading(String url, File file, Retry retry, Function0<Either<ArtifactError, T>> f, Function0<Option<Either<ArtifactError, T>>> ifLocked) {
        return (Either)retry.retryOpt((Function0<Option> & Serializable & coursierapi.shaded.scala.Serializable)() -> {
            Some some;
            try {
                Option res0 = CacheLocks$.MODULE$.withUrlLock(url, (Function0<Either> & Serializable & coursierapi.shaded.scala.Serializable)() -> {
                    Left left;
                    try {
                        left = (Left)f.apply();
                    }
                    catch (Throwable throwable) {
                        FileNotFoundException fileNotFoundException;
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof FileNotFoundException && (fileNotFoundException = (FileNotFoundException)throwable2).getMessage() != null) {
                            left = package$.MODULE$.Left().apply(new ArtifactError.NotFound(fileNotFoundException.getMessage(), ArtifactError$NotFound$.MODULE$.$lessinit$greater$default$2()));
                        }
                        throw throwable;
                    }
                    return left;
                });
                some = res0.orElse(ifLocked);
            }
            catch (Throwable throwable) {
                Option<Tuple2<MalformedURLException, String>> option;
                Throwable throwable2 = throwable;
                Option<Throwable> option2 = NonFatal$.MODULE$.unapply(throwable2);
                if (!option2.isEmpty()) {
                    Throwable e = option2.get();
                    if (MODULE$.throwExceptions()) {
                        ArtifactError.DownloadError ex = new ArtifactError.DownloadError(new StringBuilder(26).append("Caught ").append(e.getClass().getName()).append(Option$.MODULE$.apply(e.getMessage()).fold((Function0<String> & Serializable & coursierapi.shaded.scala.Serializable)() -> "", (Function1<String, String> & Serializable & coursierapi.shaded.scala.Serializable)x$20 -> new StringBuilder(3).append(" (").append((String)x$20).append(")").toString())).append(" while downloading ").append(url).toString(), new Some<Throwable>(e));
                        throw ex;
                    }
                }
                if (!(option = Downloader$UnknownProtocol$.MODULE$.unapply(throwable2)).isEmpty()) {
                    MalformedURLException e = option.get()._1();
                    String msg0 = option.get()._2();
                    String docUrl = "https://get-coursier.io/docs/extra.html#extra-protocols";
                    String msg = new $colon$colon<Nothing$>((Nothing$)((Object)new StringBuilder(30).append("Caught ").append(e.getClass().getName()).append(" (").append(msg0).append(") while downloading ").append(url).append(".").toString()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new StringBuilder(47).append("Visit ").append(docUrl).append(" to learn how to handle custom protocols.").toString()), Nil$.MODULE$)).mkString(" ");
                    ArtifactError.DownloadError ex = new ArtifactError.DownloadError(msg, new Some<Throwable>(e));
                    some = new Some(package$.MODULE$.Left().apply(ex));
                }
                Option<Throwable> option3 = NonFatal$.MODULE$.unapply(throwable2);
                if (!option3.isEmpty()) {
                    Throwable e = option3.get();
                    ArtifactError.DownloadError ex = new ArtifactError.DownloadError(new StringBuilder(26).append("Caught ").append(e.getClass().getName()).append(Option$.MODULE$.apply(e.getMessage()).fold((Function0<String> & Serializable & coursierapi.shaded.scala.Serializable)() -> "", (Function1<String, String> & Serializable & coursierapi.shaded.scala.Serializable)x$21 -> new StringBuilder(3).append(" (").append((String)x$21).append(")").toString())).append(" while downloading ").append(url).toString(), new Some<Throwable>(e));
                    some = new Some(package$.MODULE$.Left().apply(ex));
                }
                throw throwable;
            }
            return some;
        }, (PartialFunction<Throwable, BoxedUnit>)((Object)new coursierapi.shaded.scala.Serializable(){

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AccessDeniedException && Properties$.MODULE$.isWin()) {
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof SSLException) {
                    return (B1)BoxedUnit.UNIT;
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                if (throwable instanceof AccessDeniedException && Properties$.MODULE$.isWin()) {
                    return true;
                }
                return throwable instanceof SSLException;
            }
        }));
    }

    public Either<ArtifactError, Option<Object>> coursier$cache$internal$Downloader$$contentLength(String url, Option<Authentication> authentication, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Seq<DirectCredentials> credentials, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, CacheLogger logger, Option<Object> maxRedirectionsOpt) {
        Left<ArtifactError, Option<Object>> left;
        block9: {
            URLConnection conn;
            block8: {
                conn = null;
                try {
                    URLConnection uRLConnection = conn = ConnectionBuilder$.MODULE$.apply(url).withAuthentication(authentication).withFollowHttpToHttpsRedirections(followHttpToHttpsRedirections).withFollowHttpsToHttpRedirections(followHttpsToHttpRedirections).withAutoCredentials(credentials).withSslSocketFactoryOpt(sslSocketFactoryOpt).withHostnameVerifierOpt(hostnameVerifierOpt).withMethod("HEAD").withMaxRedirectionsOpt(maxRedirectionsOpt).connection();
                    if (uRLConnection instanceof HttpURLConnection) {
                        HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                        logger.gettingLength(url);
                        boolean success = false;
                        try {
                            Option<Object> len = new Some<Long>(BoxesRunTime.boxToLong(httpURLConnection.getContentLengthLong())).filter((JFunction1$mcZJ$sp & coursierapi.shaded.scala.Serializable)x$22 -> x$22 >= 0L);
                            success = true;
                            logger.gettingLengthResult(url, len);
                            left = package$.MODULE$.Right().apply(len);
                            break block8;
                        }
                        finally {
                            if (!success) {
                                logger.gettingLengthResult(url, None$.MODULE$);
                            }
                        }
                    }
                    left = package$.MODULE$.Left().apply(new ArtifactError.DownloadError(new StringBuilder(42).append("Cannot do HEAD request with connection ").append(uRLConnection).append(" (").append(url).append(")").toString(), None$.MODULE$));
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        CacheUrl$.MODULE$.closeConn(conn);
                    }
                    throw throwable;
                }
            }
            if (conn == null) break block9;
            CacheUrl$.MODULE$.closeConn(conn);
        }
        return left;
    }

    public <F> Downloader<F> apply(Artifact artifact, CachePolicy cachePolicy, File location, Seq<String> actualChecksums, F allCredentials, CacheLogger logger, ExecutorService pool, Option<Duration> ttl, boolean localArtifactsShouldBeCached, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Option<Object> maxRedirections, int sslRetry, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, int bufferSize, Seq<ClassLoader> classLoaders, Clock clock, Sync<F> S) {
        return new Downloader<F>(artifact, cachePolicy, location, actualChecksums, allCredentials, logger, pool, ttl, localArtifactsShouldBeCached, followHttpToHttpsRedirections, followHttpsToHttpRedirections, maxRedirections, sslRetry, sslSocketFactoryOpt, hostnameVerifierOpt, bufferSize, classLoaders, clock, CacheDefaults$.MODULE$.retryCount(), CacheDefaults$.MODULE$.retryBackoffInitialDelay(), CacheDefaults$.MODULE$.retryBackoffMultiplier(), S);
    }

    private final void helper$1(long count, InputStream in$1, byte[] b$1, OutputStream out$1, CacheLogger logger$2, String url$9) {
        int read;
        while ((read = in$1.read(b$1)) >= 0) {
            out$1.write(b$1, 0, read);
            out$1.flush();
            logger$2.downloadProgress(url$9, count + (long)read);
            count += (long)read;
        }
    }

    private Downloader$() {
        MODULE$ = this;
        this.coursier$cache$internal$Downloader$$checksumHeader = new $colon$colon<Nothing$>((Nothing$)((Object)"MD5"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"SHA1"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"SHA256"), Nil$.MODULE$)));
    }
}

