/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.credentials;

import coursierapi.shaded.coursier.credentials.Credentials;
import coursierapi.shaded.coursier.credentials.DirectCredentials;
import coursierapi.shaded.coursier.credentials.FileCredentials$;
import coursierapi.shaded.scala.Product;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.Seq;
import coursierapi.shaded.scala.collection.immutable.Nil$;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Statics;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class FileCredentials
extends Credentials
implements Product {
    private final String path;
    private final boolean optional;

    @Override
    public Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    public String path() {
        return this.path;
    }

    public boolean optional() {
        return this.optional;
    }

    @Override
    public Seq<DirectCredentials> get() {
        Path f = Paths.get(this.path(), new String[0]);
        if (Files.isRegularFile(f, new LinkOption[0])) {
            String content = new String(Files.readAllBytes(f), Charset.defaultCharset());
            return FileCredentials$.MODULE$.parse(content, this.path());
        }
        if (this.optional()) {
            return Nil$.MODULE$;
        }
        throw new Exception(new StringBuilder(26).append("Credential file ").append(this.path()).append(" not found").toString());
    }

    public String toString() {
        StringBuilder b = new StringBuilder("FileCredentials(");
        b.append(String.valueOf(this.path()));
        b.append(", ");
        b.append(String.valueOf(this.optional()));
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof FileCredentials && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        FileCredentials other = (FileCredentials)obj;
        if (!true) return false;
        String string = this.path();
        String string2 = other.path();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.optional() != other.optional()) return false;
        return true;
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash("FileCredentials");
        code = 37 * code + Statics.anyHash(this.path());
        code = 37 * code + (this.optional() ? 1231 : 1237);
        return 37 * code;
    }

    @Override
    public String productPrefix() {
        return "FileCredentials";
    }

    @Override
    public int productArity() {
        return 2;
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this.path();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean(this.optional());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public FileCredentials(String path, boolean optional) {
        this.path = path;
        this.optional = optional;
        Product.$init$(this);
    }
}

