/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.cli.config;

import coursierapi.shaded.jsoniter.JsonReaderException;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.Serializable;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.cli.config.Key$;
import coursierapi.shaded.scala.cli.config.Key$EntryError$;
import coursierapi.shaded.scala.cli.config.Key$MalformedValue$;
import coursierapi.shaded.scala.cli.config.PasswordOption;
import coursierapi.shaded.scala.cli.config.PasswordOption$;
import coursierapi.shaded.scala.collection.Seq;
import coursierapi.shaded.scala.collection.Seq$;
import coursierapi.shaded.scala.collection.TraversableOnce;
import coursierapi.shaded.scala.collection.immutable.$colon$colon;
import coursierapi.shaded.scala.collection.immutable.List;
import coursierapi.shaded.scala.collection.immutable.Nil$;
import coursierapi.shaded.scala.package$;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Nothing$;
import coursierapi.shaded.scala.util.Either;
import coursierapi.shaded.scala.util.Left;

public abstract class Key<T> {
    public abstract Seq<String> prefix();

    public abstract String name();

    public abstract Either<EntryError, T> parse(byte[] var1);

    public final String fullName() {
        return ((TraversableOnce)this.prefix().$colon$plus(this.name(), Seq$.MODULE$.canBuildFrom())).mkString(".");
    }

    public static final class BooleanEntry
    extends Key<Object> {
        private final Seq<String> prefix;
        private final String name;
        private final String description;
        private final boolean hidden;

        @Override
        public Seq<String> prefix() {
            return this.prefix;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Either<EntryError, Object> parse(byte[] json) {
            Left<EntryError, Object> left;
            try {
                left = package$.MODULE$.Right().apply(BoxesRunTime.boxToBoolean(coursierapi.shaded.jsoniter.package$.MODULE$.readFromArray$mZc$sp(json, coursierapi.shaded.jsoniter.package$.MODULE$.readFromArray$default$2(), Key$.MODULE$.scala$cli$config$Key$$booleanCodec())));
            }
            catch (JsonReaderException e) {
                left = package$.MODULE$.Left().apply(new JsonReaderError(e));
            }
            return left;
        }

        public BooleanEntry(Seq<String> prefix, String name, String description, boolean hidden) {
            this.prefix = prefix;
            this.name = name;
            this.description = description;
            this.hidden = hidden;
        }
    }

    public static abstract class EntryError
    extends Exception {
        public EntryError(String message, Option<Throwable> causeOpt) {
            super(message, (Throwable)causeOpt.orNull(Predef$.MODULE$.$conforms()));
        }
    }

    public static final class JsonReaderError
    extends EntryError {
        public JsonReaderError(JsonReaderException cause) {
            super("Error parsing config JSON", new Some<Throwable>(cause));
        }
    }

    public static final class MalformedEntry
    extends EntryError {
        public MalformedEntry(Key<?> entry, $colon$colon<String> messages) {
            super(new StringBuilder(18).append("Malformed entry ").append(entry.fullName()).append(", ").append(messages.mkString(", ")).toString(), Key$EntryError$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public static final class MalformedValue
    extends EntryError {
        public MalformedValue(Key<?> entry, Seq<String> input, Either<String, String> messageOrExpectedShape, Option<Throwable> cause) {
            super(new StringBuilder(24).append("Malformed values ").append(input.mkString(", ")).append(" for ").append(entry.fullName()).append(", ").append((Object)messageOrExpectedShape.fold(new Serializable(){

                public final String apply(String shape) {
                    return new StringBuilder(9).append("expected ").append(shape).toString();
                }
            }, new Serializable(){

                public final String apply(String x) {
                    return Predef$.MODULE$.identity(x);
                }
            })).toString(), cause);
        }
    }

    public static final class PasswordEntry
    extends Key<PasswordOption> {
        private final Seq<String> prefix;
        private final String name;
        private final String description;
        private final boolean hidden;

        @Override
        public Seq<String> prefix() {
            return this.prefix;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Either<EntryError, PasswordOption> parse(byte[] json) {
            Either either;
            try {
                String str = coursierapi.shaded.jsoniter.package$.MODULE$.readFromArray(json, coursierapi.shaded.jsoniter.package$.MODULE$.readFromArray$default$2(), Key$.MODULE$.scala$cli$config$Key$$stringCodec());
                either = PasswordOption$.MODULE$.parse(str).left().map((Function1<String, MalformedValue> & java.io.Serializable & Serializable)e -> new MalformedValue(this, (Seq<String>)new $colon$colon<Nothing$>((Nothing$)((Object)str), Nil$.MODULE$), package$.MODULE$.Right().apply(e), Key$MalformedValue$.MODULE$.$lessinit$greater$default$4()));
            }
            catch (JsonReaderException e2) {
                either = package$.MODULE$.Left().apply(new JsonReaderError(e2));
            }
            return either;
        }

        public PasswordEntry(Seq<String> prefix, String name, String description, boolean hidden) {
            this.prefix = prefix;
            this.name = name;
            this.description = description;
            this.hidden = hidden;
        }
    }

    public static final class StringEntry
    extends Key<String> {
        private final Seq<String> prefix;
        private final String name;
        private final String description;
        private final boolean hidden;

        @Override
        public Seq<String> prefix() {
            return this.prefix;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Either<EntryError, String> parse(byte[] json) {
            Left<EntryError, String> left;
            try {
                left = package$.MODULE$.Right().apply(coursierapi.shaded.jsoniter.package$.MODULE$.readFromArray(json, coursierapi.shaded.jsoniter.package$.MODULE$.readFromArray$default$2(), Key$.MODULE$.scala$cli$config$Key$$stringCodec()));
            }
            catch (JsonReaderException e) {
                left = package$.MODULE$.Left().apply(new JsonReaderError(e));
            }
            return left;
        }

        public StringEntry(Seq<String> prefix, String name, String description, boolean hidden) {
            this.prefix = prefix;
            this.name = name;
            this.description = description;
            this.hidden = hidden;
        }
    }

    public static final class StringListEntry
    extends Key<List<String>> {
        private final Seq<String> prefix;
        private final String name;
        private final String description;
        private final boolean hidden;

        @Override
        public Seq<String> prefix() {
            return this.prefix;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Either<EntryError, List<String>> parse(byte[] json) {
            Left<EntryError, List<String>> left;
            try {
                left = package$.MODULE$.Right().apply(coursierapi.shaded.jsoniter.package$.MODULE$.readFromArray(json, coursierapi.shaded.jsoniter.package$.MODULE$.readFromArray$default$2(), Key$.MODULE$.scala$cli$config$Key$$stringListCodec()));
            }
            catch (JsonReaderException e) {
                left = package$.MODULE$.Left().apply(new JsonReaderError(e));
            }
            return left;
        }

        public StringListEntry(Seq<String> prefix, String name, String description, boolean hidden) {
            this.prefix = prefix;
            this.name = name;
            this.description = description;
            this.hidden = hidden;
        }
    }
}

