/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.collection;

import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.Function2;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.PartialFunction;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.Serializable;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.AbstractIterator;
import coursierapi.shaded.scala.collection.GenTraversableOnce;
import coursierapi.shaded.scala.collection.Iterator$;
import coursierapi.shaded.scala.collection.Seq;
import coursierapi.shaded.scala.collection.Traversable;
import coursierapi.shaded.scala.collection.TraversableOnce;
import coursierapi.shaded.scala.collection.generic.CanBuildFrom;
import coursierapi.shaded.scala.collection.immutable.IndexedSeq;
import coursierapi.shaded.scala.collection.immutable.List;
import coursierapi.shaded.scala.collection.immutable.Map;
import coursierapi.shaded.scala.collection.immutable.Set;
import coursierapi.shaded.scala.collection.immutable.Stream;
import coursierapi.shaded.scala.collection.immutable.Stream$;
import coursierapi.shaded.scala.collection.immutable.Stream$cons$;
import coursierapi.shaded.scala.collection.immutable.Vector;
import coursierapi.shaded.scala.collection.mutable.Buffer;
import coursierapi.shaded.scala.collection.mutable.StringBuilder;
import coursierapi.shaded.scala.math.Numeric;
import coursierapi.shaded.scala.math.Ordering;
import coursierapi.shaded.scala.math.package$;
import coursierapi.shaded.scala.reflect.ClassTag;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Nothing$;
import coursierapi.shaded.scala.runtime.RichInt$;
import coursierapi.shaded.scala.runtime.ScalaRunTime$;

public interface Iterator<A>
extends TraversableOnce<A> {
    @Override
    default public Iterator<A> seq() {
        return this;
    }

    public boolean hasNext();

    public A next();

    @Override
    default public boolean isEmpty() {
        return !this.hasNext();
    }

    @Override
    default public boolean isTraversableAgain() {
        return false;
    }

    default public Iterator<A> take(int n) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return this.sliceIterator(0, RichInt$.MODULE$.max$extension(n, 0));
    }

    default public Iterator<A> drop(int n) {
        for (int j = 0; j < n && this.hasNext(); ++j) {
            this.next();
        }
        return this;
    }

    default public Iterator<A> slice(int from, int until) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return this.sliceIterator(from, RichInt$.MODULE$.max$extension(until, 0));
    }

    default public Iterator<A> sliceIterator(int from, int until) {
        int rest;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        int lo = RichInt$.MODULE$.max$extension(from, 0);
        int n = until < 0 ? -1 : (rest = until <= lo ? 0 : until - lo);
        if (rest == 0) {
            return Iterator$.MODULE$.empty();
        }
        return new SliceIterator(this, lo, rest);
    }

    default public <B> Iterator<B> map(Function1<A, B> f) {
        return new AbstractIterator<B>(this, f){
            private final /* synthetic */ Iterator $outer;
            private final Function1 f$3;

            public boolean hasNext() {
                return this.$outer.hasNext();
            }

            public B next() {
                return (B)this.f$3.apply(this.$outer.next());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$3 = f$3;
            }
        };
    }

    public static /* synthetic */ Iterator $plus$plus$(Iterator $this, Function0 that) {
        return $this.$plus$plus(that);
    }

    default public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
        return new ConcatIterator(this).$plus$plus(that);
    }

    default public <B> Iterator<B> flatMap(Function1<A, GenTraversableOnce<B>> f) {
        return new AbstractIterator<B>(this, f){
            private Iterator<B> cur;
            private final /* synthetic */ Iterator $outer;
            private final Function1 f$4;

            private Iterator<B> cur() {
                return this.cur;
            }

            private void cur_$eq(Iterator<B> x$1) {
                this.cur = x$1;
            }

            private void nextCur() {
                this.cur_$eq(null);
                this.cur_$eq(((GenTraversableOnce)this.f$4.apply(this.$outer.next())).toIterator());
            }

            public boolean hasNext() {
                while (!this.cur().hasNext()) {
                    if (!this.$outer.hasNext()) {
                        return false;
                    }
                    this.nextCur();
                }
                return true;
            }

            public B next() {
                return (B)(this.hasNext() ? this.cur() : Iterator$.MODULE$.empty()).next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.f$4 = f$4;
                this.cur = Iterator$.MODULE$.empty();
            }
        };
    }

    default public Iterator<A> filter(Function1<A, Object> p) {
        return new AbstractIterator<A>(this, p){
            private A hd;
            private boolean hdDefined;
            private final /* synthetic */ Iterator $outer;
            private final Function1 p$1;

            private A hd() {
                return this.hd;
            }

            private void hd_$eq(A x$1) {
                this.hd = x$1;
            }

            private boolean hdDefined() {
                return this.hdDefined;
            }

            private void hdDefined_$eq(boolean x$1) {
                this.hdDefined = x$1;
            }

            public boolean hasNext() {
                if (!this.hdDefined()) {
                    do {
                        if (!this.$outer.hasNext()) {
                            return false;
                        }
                        this.hd_$eq(this.$outer.next());
                    } while (!BoxesRunTime.unboxToBoolean(this.p$1.apply(this.hd())));
                    this.hdDefined_$eq(true);
                }
                return true;
            }

            public A next() {
                if (this.hasNext()) {
                    this.hdDefined_$eq(false);
                    return this.hd();
                }
                return (A)Iterator$.MODULE$.empty().next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.p$1 = p$1;
                this.hdDefined = false;
            }
        };
    }

    default public Iterator<A> withFilter(Function1<A, Object> p) {
        return this.filter(p);
    }

    default public <B> Iterator<B> collect(PartialFunction<A, B> pf) {
        return new AbstractIterator<B>(this, pf){
            private A hd;
            private int status;
            private final /* synthetic */ Iterator $outer;
            private final PartialFunction pf$1;

            public boolean hasNext() {
                while (this.status == 0) {
                    if (this.$outer.hasNext()) {
                        this.hd = this.$outer.next();
                        if (!this.pf$1.isDefinedAt(this.hd)) continue;
                        this.status = 1;
                        continue;
                    }
                    this.status = -1;
                }
                return this.status == 1;
            }

            public B next() {
                if (this.hasNext()) {
                    this.status = 0;
                    return (B)this.pf$1.apply(this.hd);
                }
                return (B)Iterator$.MODULE$.empty().next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.pf$1 = pf$1;
                this.status = 0;
            }
        };
    }

    default public Iterator<A> takeWhile(Function1<A, Object> p) {
        return new AbstractIterator<A>(this, p){
            private A hd;
            private boolean hdDefined;
            private Iterator<A> tail;
            private final Function1 p$3;

            private A hd() {
                return this.hd;
            }

            private void hd_$eq(A x$1) {
                this.hd = x$1;
            }

            private boolean hdDefined() {
                return this.hdDefined;
            }

            private void hdDefined_$eq(boolean x$1) {
                this.hdDefined = x$1;
            }

            private Iterator<A> tail() {
                return this.tail;
            }

            private void tail_$eq(Iterator<A> x$1) {
                this.tail = x$1;
            }

            public boolean hasNext() {
                block6: {
                    block5: {
                        if (this.hdDefined()) break block5;
                        if (!this.tail().hasNext()) break block6;
                        this.hd_$eq(this.tail().next());
                        if (BoxesRunTime.unboxToBoolean(this.p$3.apply(this.hd()))) {
                            this.hdDefined_$eq(true);
                        } else {
                            this.tail_$eq(Iterator$.MODULE$.empty());
                        }
                        if (!this.hdDefined()) break block6;
                    }
                    return true;
                }
                return false;
            }

            public A next() {
                if (this.hasNext()) {
                    this.hdDefined_$eq(false);
                    return this.hd();
                }
                return (A)Iterator$.MODULE$.empty().next();
            }
            {
                this.p$3 = p$3;
                this.hdDefined = false;
                this.tail = $outer;
            }
        };
    }

    default public Iterator<A> dropWhile(Function1<A, Object> p) {
        return new AbstractIterator<A>(this, p){
            private int status;
            private A fst;
            private final /* synthetic */ Iterator $outer;
            private final Function1 p$6;

            public boolean hasNext() {
                if (this.status == 1) {
                    return this.$outer.hasNext();
                }
                if (this.status == 0) {
                    return true;
                }
                while (this.$outer.hasNext()) {
                    A a = this.$outer.next();
                    if (BoxesRunTime.unboxToBoolean(this.p$6.apply(a))) continue;
                    this.fst = a;
                    this.status = 0;
                    return true;
                }
                this.status = 1;
                return false;
            }

            public A next() {
                if (this.hasNext()) {
                    if (this.status == 1) {
                        return this.$outer.next();
                    }
                    this.status = 1;
                    return this.fst;
                }
                return (A)Iterator$.MODULE$.empty().next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.p$6 = p$6;
                this.status = -1;
            }
        };
    }

    default public <B> Iterator<Tuple2<A, B>> zip(Iterator<B> that) {
        return new AbstractIterator<Tuple2<A, B>>(this, that){
            private final /* synthetic */ Iterator $outer;
            private final Iterator that$1;

            public boolean hasNext() {
                return this.$outer.hasNext() && this.that$1.hasNext();
            }

            public Tuple2<A, B> next() {
                return new Tuple2<A, A>(this.$outer.next(), this.that$1.next());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.that$1 = that$1;
            }
        };
    }

    default public Iterator<Tuple2<A, Object>> zipWithIndex() {
        return new AbstractIterator<Tuple2<A, Object>>(this){
            private int idx;
            private final /* synthetic */ Iterator $outer;

            private int idx() {
                return this.idx;
            }

            private void idx_$eq(int x$1) {
                this.idx = x$1;
            }

            public boolean hasNext() {
                return this.$outer.hasNext();
            }

            public Tuple2<A, Object> next() {
                Tuple2<A, Integer> ret = new Tuple2<A, Integer>(this.$outer.next(), BoxesRunTime.boxToInteger(this.idx()));
                this.idx_$eq(this.idx() + 1);
                return ret;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.idx = 0;
            }
        };
    }

    default public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
        return new AbstractIterator<Tuple2<A1, B1>>(this, that, thatElem, thisElem){
            private final /* synthetic */ Iterator $outer;
            private final Iterator that$2;
            private final Object thatElem$1;
            private final Object thisElem$1;

            public boolean hasNext() {
                return this.$outer.hasNext() || this.that$2.hasNext();
            }

            public Tuple2<A1, B1> next() {
                if (this.$outer.hasNext()) {
                    if (this.that$2.hasNext()) {
                        return new Tuple2<A, A>(this.$outer.next(), this.that$2.next());
                    }
                    return new Tuple2<A, Object>(this.$outer.next(), this.thatElem$1);
                }
                if (this.that$2.hasNext()) {
                    return new Tuple2<Object, A>(this.thisElem$1, this.that$2.next());
                }
                return (Tuple2)((Object)Iterator$.MODULE$.empty().next());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.that$2 = that$2;
                this.thatElem$1 = thatElem$1;
                this.thisElem$1 = thisElem$1;
            }
        };
    }

    @Override
    default public <U> void foreach(Function1<A, U> f) {
        while (this.hasNext()) {
            f.apply(this.next());
        }
    }

    @Override
    default public boolean forall(Function1<A, Object> p) {
        boolean res = true;
        while (res && this.hasNext()) {
            res = BoxesRunTime.unboxToBoolean(p.apply(this.next()));
        }
        return res;
    }

    default public boolean exists(Function1<A, Object> p) {
        boolean res = false;
        while (!res && this.hasNext()) {
            res = BoxesRunTime.unboxToBoolean(p.apply(this.next()));
        }
        return res;
    }

    default public Option<A> find(Function1<A, Object> p) {
        while (this.hasNext()) {
            A a = this.next();
            if (!BoxesRunTime.unboxToBoolean(p.apply(a))) continue;
            return new Some<A>(a);
        }
        return None$.MODULE$;
    }

    default public int indexWhere(Function1<A, Object> p) {
        return this.indexWhere(p, 0);
    }

    default public int indexWhere(Function1<A, Object> p, int from) {
        int i;
        for (i = 0; i < from && this.hasNext(); ++i) {
            this.next();
        }
        while (this.hasNext()) {
            if (BoxesRunTime.unboxToBoolean(p.apply(this.next()))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    default public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
        return new AbstractIterator<B>(this, from, replaced, patchElems){
            private Iterator<A> origElems;
            private int i;
            private final int replaced$1;
            private final Iterator patchElems$1;

            private Iterator<A> origElems() {
                return this.origElems;
            }

            private void origElems_$eq(Iterator<A> x$1) {
                this.origElems = x$1;
            }

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                if (this.i() == 0) {
                    this.origElems_$eq(this.origElems().drop(this.replaced$1));
                    this.i_$eq(-1);
                }
                return this.origElems().hasNext() || this.patchElems$1.hasNext();
            }

            public B next() {
                if (this.i() == 0) {
                    this.origElems_$eq(this.origElems().drop(this.replaced$1));
                    this.i_$eq(-1);
                }
                if (this.i() < 0) {
                    if (this.patchElems$1.hasNext()) {
                        return (B)this.patchElems$1.next();
                    }
                    return (B)this.origElems().next();
                }
                if (this.origElems().hasNext()) {
                    this.i_$eq(this.i() - 1);
                    return (B)this.origElems().next();
                }
                this.i_$eq(-1);
                return (B)this.patchElems$1.next();
            }
            {
                this.replaced$1 = replaced$1;
                this.patchElems$1 = patchElems$1;
                this.origElems = $outer;
                this.i = from$1 > 0 ? from$1 : 0;
            }
        };
    }

    @Override
    default public <B> void copyToArray(Object xs, int start, int len) {
        int end = start + package$.MODULE$.min(len, ScalaRunTime$.MODULE$.array_length(xs) - start);
        for (int i = start; i < end && this.hasNext(); ++i) {
            ScalaRunTime$.MODULE$.array_update(xs, i, this.next());
        }
    }

    default public boolean sameElements(Iterator<?> that) {
        while (this.hasNext() && that.hasNext()) {
            if (BoxesRunTime.equals(this.next(), that.next())) continue;
            return false;
        }
        return !this.hasNext() && !that.hasNext();
    }

    @Override
    default public Traversable<A> toTraversable() {
        return this.toStream();
    }

    @Override
    default public Iterator<A> toIterator() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    default public Stream<A> toStream() {
        if (this.hasNext()) {
            void apply_tl;
            void apply_hd;
            Function0<Stream> & java.io.Serializable & Serializable intersect = (Function0<Stream> & java.io.Serializable & Serializable)() -> this.toStream();
            A a = this.next();
            if (Stream$cons$.MODULE$ == null) {
                throw null;
            }
            return new Stream.Cons<void>(apply_hd, (Function0<Stream<void>>)apply_tl);
        }
        return Stream$.MODULE$.empty();
    }

    default public String toString() {
        return "<iterator>";
    }

    public static void $init$(Iterator $this) {
    }

    private static final class ConcatIterator<A>
    implements Iterator<A> {
        private Iterator<A> current;
        private ConcatIteratorCell<A> tail;
        private ConcatIteratorCell<A> last;
        private boolean currentHasNextChecked;

        @Override
        public Iterator<A> seq() {
            return ((Iterator)this).seq();
        }

        @Override
        public boolean isEmpty() {
            return ((Iterator)this).isEmpty();
        }

        @Override
        public boolean isTraversableAgain() {
            return ((Iterator)this).isTraversableAgain();
        }

        @Override
        public Iterator<A> take(int n) {
            return ((Iterator)this).take(n);
        }

        @Override
        public Iterator<A> drop(int n) {
            return ((Iterator)this).drop(n);
        }

        @Override
        public Iterator<A> slice(int from, int until) {
            return ((Iterator)this).slice(from, until);
        }

        @Override
        public Iterator<A> sliceIterator(int from, int until) {
            return ((Iterator)this).sliceIterator(from, until);
        }

        @Override
        public <B> Iterator<B> map(Function1<A, B> f) {
            return ((Iterator)this).map(f);
        }

        @Override
        public <B> Iterator<B> flatMap(Function1<A, GenTraversableOnce<B>> f) {
            return ((Iterator)this).flatMap(f);
        }

        @Override
        public Iterator<A> filter(Function1<A, Object> p) {
            return ((Iterator)this).filter(p);
        }

        @Override
        public Iterator<A> withFilter(Function1<A, Object> p) {
            return ((Iterator)this).withFilter(p);
        }

        @Override
        public <B> Iterator<B> collect(PartialFunction<A, B> pf) {
            return ((Iterator)this).collect(pf);
        }

        @Override
        public Iterator<A> takeWhile(Function1<A, Object> p) {
            return ((Iterator)this).takeWhile(p);
        }

        @Override
        public Iterator<A> dropWhile(Function1<A, Object> p) {
            return ((Iterator)this).dropWhile(p);
        }

        @Override
        public <B> Iterator<Tuple2<A, B>> zip(Iterator<B> that) {
            return ((Iterator)this).zip((Iterator)that);
        }

        @Override
        public Iterator<Tuple2<A, Object>> zipWithIndex() {
            return ((Iterator)this).zipWithIndex();
        }

        @Override
        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
            return ((Iterator)this).zipAll((Iterator)that, thisElem, thatElem);
        }

        @Override
        public <U> void foreach(Function1<A, U> f) {
            ((Iterator)this).foreach(f);
        }

        @Override
        public boolean forall(Function1<A, Object> p) {
            return ((Iterator)this).forall(p);
        }

        @Override
        public boolean exists(Function1<A, Object> p) {
            return ((Iterator)this).exists(p);
        }

        @Override
        public Option<A> find(Function1<A, Object> p) {
            return ((Iterator)this).find(p);
        }

        @Override
        public int indexWhere(Function1<A, Object> p) {
            return ((Iterator)this).indexWhere(p);
        }

        @Override
        public int indexWhere(Function1<A, Object> p, int from) {
            return ((Iterator)this).indexWhere(p, from);
        }

        @Override
        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return ((Iterator)this).patch(from, (Iterator)patchElems, replaced);
        }

        @Override
        public <B> void copyToArray(Object xs, int start, int len) {
            ((Iterator)this).copyToArray(xs, start, len);
        }

        @Override
        public boolean sameElements(Iterator<?> that) {
            return ((Iterator)this).sameElements((Iterator)that);
        }

        @Override
        public Traversable<A> toTraversable() {
            return ((Iterator)this).toTraversable();
        }

        @Override
        public Iterator<A> toIterator() {
            return ((Iterator)this).toIterator();
        }

        @Override
        public Stream<A> toStream() {
            return ((Iterator)this).toStream();
        }

        @Override
        public String toString() {
            return ((Iterator)this).toString();
        }

        @Override
        public List<A> reversed() {
            return TraversableOnce.reversed$(this);
        }

        @Override
        public int size() {
            return TraversableOnce.size$(this);
        }

        @Override
        public boolean nonEmpty() {
            return TraversableOnce.nonEmpty$(this);
        }

        @Override
        public int count(Function1<A, Object> p) {
            return TraversableOnce.count$(this, p);
        }

        @Override
        public <B> Option<B> collectFirst(PartialFunction<A, B> pf) {
            return TraversableOnce.collectFirst$(this, pf);
        }

        @Override
        public <B> B $div$colon(B z, Function2<B, A, B> op) {
            return (B)TraversableOnce.$div$colon$(this, z, op);
        }

        @Override
        public <B> B foldLeft(B z, Function2<B, A, B> op) {
            return (B)TraversableOnce.foldLeft$(this, z, op);
        }

        @Override
        public <B> B foldRight(B z, Function2<A, B, B> op) {
            return (B)TraversableOnce.foldRight$(this, z, op);
        }

        @Override
        public <B> B reduceLeft(Function2<B, A, B> op) {
            return (B)TraversableOnce.reduceLeft$(this, op);
        }

        @Override
        public <B> Option<B> reduceLeftOption(Function2<B, A, B> op) {
            return TraversableOnce.reduceLeftOption$(this, op);
        }

        @Override
        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
            return TraversableOnce.reduceOption$(this, op);
        }

        @Override
        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.fold$(this, z, op);
        }

        @Override
        public <B> B sum(Numeric<B> num) {
            return (B)TraversableOnce.sum$(this, num);
        }

        @Override
        public <B> A min(Ordering<B> cmp) {
            return (A)TraversableOnce.min$(this, cmp);
        }

        @Override
        public <B> A max(Ordering<B> cmp) {
            return (A)TraversableOnce.max$(this, cmp);
        }

        @Override
        public <B> A maxBy(Function1<A, B> f, Ordering<B> cmp) {
            return (A)TraversableOnce.maxBy$(this, f, cmp);
        }

        @Override
        public <B> void copyToBuffer(Buffer<B> dest) {
            TraversableOnce.copyToBuffer$(this, dest);
        }

        @Override
        public <B> void copyToArray(Object xs, int start) {
            TraversableOnce.copyToArray$(this, xs, start);
        }

        @Override
        public <B> Object toArray(ClassTag<B> evidence$1) {
            return TraversableOnce.toArray$(this, evidence$1);
        }

        @Override
        public List<A> toList() {
            return TraversableOnce.toList$(this);
        }

        @Override
        public Seq<A> toSeq() {
            return TraversableOnce.toSeq$(this);
        }

        @Override
        public IndexedSeq<A> toIndexedSeq() {
            return TraversableOnce.toIndexedSeq$(this);
        }

        @Override
        public <B> Buffer<B> toBuffer() {
            return TraversableOnce.toBuffer$(this);
        }

        @Override
        public <B> Set<B> toSet() {
            return TraversableOnce.toSet$(this);
        }

        @Override
        public Vector<A> toVector() {
            return TraversableOnce.toVector$(this);
        }

        @Override
        public <Col> Col to(CanBuildFrom<Nothing$, A, Col> cbf) {
            return (Col)TraversableOnce.to$(this, cbf);
        }

        @Override
        public <T, U> Map<T, U> toMap(Predef$.less.colon.less<A, Tuple2<T, U>> ev) {
            return TraversableOnce.toMap$(this, ev);
        }

        @Override
        public String mkString(String start, String sep, String end) {
            return TraversableOnce.mkString$(this, start, sep, end);
        }

        @Override
        public String mkString(String sep) {
            return TraversableOnce.mkString$(this, sep);
        }

        @Override
        public String mkString() {
            return TraversableOnce.mkString$(this);
        }

        @Override
        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return TraversableOnce.addString$(this, b, start, sep, end);
        }

        @Override
        public int sizeHintIfCheap() {
            return GenTraversableOnce.sizeHintIfCheap$(this);
        }

        private Iterator<A> current() {
            return this.current;
        }

        private void current_$eq(Iterator<A> x$1) {
            this.current = x$1;
        }

        private ConcatIteratorCell<A> tail() {
            return this.tail;
        }

        private void tail_$eq(ConcatIteratorCell<A> x$1) {
            this.tail = x$1;
        }

        private ConcatIteratorCell<A> last() {
            return this.last;
        }

        private void last_$eq(ConcatIteratorCell<A> x$1) {
            this.last = x$1;
        }

        private boolean currentHasNextChecked() {
            return this.currentHasNextChecked;
        }

        private void currentHasNextChecked_$eq(boolean x$1) {
            this.currentHasNextChecked = x$1;
        }

        private boolean advance() {
            do {
                if (this.tail() == null) {
                    this.current_$eq(null);
                    this.last_$eq(null);
                    return false;
                }
                this.current_$eq(this.tail().headIterator());
                if (this.last() == this.tail()) {
                    this.last_$eq(this.last().tail());
                }
                this.tail_$eq(this.tail().tail());
                this.merge();
                if (!this.currentHasNextChecked()) continue;
                return true;
            } while (this.current() == null || !this.current().hasNext());
            this.currentHasNextChecked_$eq(true);
            return true;
        }

        private void merge() {
            while (this.current() instanceof ConcatIterator) {
                ConcatIterator c = (ConcatIterator)this.current();
                this.current_$eq(c.current());
                this.currentHasNextChecked_$eq(c.currentHasNextChecked());
                if (c.tail() == null) continue;
                if (this.last() == null) {
                    this.last_$eq(c.last());
                }
                c.last().tail_$eq(this.tail());
                this.tail_$eq(c.tail());
            }
        }

        @Override
        public boolean hasNext() {
            if (this.currentHasNextChecked()) {
                return true;
            }
            if (this.current() == null) {
                return false;
            }
            if (this.current().hasNext()) {
                this.currentHasNextChecked_$eq(true);
                return true;
            }
            return this.advance();
        }

        @Override
        public A next() {
            if (this.hasNext()) {
                this.currentHasNextChecked_$eq(false);
                return this.current().next();
            }
            return (A)Iterator$.MODULE$.empty().next();
        }

        @Override
        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
            ConcatIteratorCell c = new ConcatIteratorCell(that, null);
            if (this.tail() == null) {
                this.tail_$eq(c);
                this.last_$eq(c);
            } else {
                this.last().tail_$eq(c);
                this.last_$eq(c);
            }
            if (this.current() == null) {
                this.current_$eq(Iterator$.MODULE$.empty());
            }
            return this;
        }

        public ConcatIterator(Iterator<A> current) {
            this.current = current;
            GenTraversableOnce.$init$(this);
            TraversableOnce.$init$(this);
            Iterator.$init$(this);
            this.tail = null;
            this.last = null;
            this.currentHasNextChecked = false;
        }
    }

    private static final class ConcatIteratorCell<A> {
        private final Function0<GenTraversableOnce<A>> head;
        private ConcatIteratorCell<A> tail;

        public ConcatIteratorCell<A> tail() {
            return this.tail;
        }

        public void tail_$eq(ConcatIteratorCell<A> x$1) {
            this.tail = x$1;
        }

        public Iterator<A> headIterator() {
            return this.head.apply().toIterator();
        }

        public ConcatIteratorCell(Function0<GenTraversableOnce<A>> head, ConcatIteratorCell<A> tail) {
            this.head = head;
            this.tail = tail;
        }
    }

    public static final class SliceIterator<A>
    extends AbstractIterator<A> {
        private final Iterator<A> underlying;
        private int scala$collection$Iterator$SliceIterator$$remaining;
        private int dropping;

        public Iterator<A> underlying() {
            return this.underlying;
        }

        public int scala$collection$Iterator$SliceIterator$$remaining() {
            return this.scala$collection$Iterator$SliceIterator$$remaining;
        }

        private void scala$collection$Iterator$SliceIterator$$remaining_$eq(int x$1) {
            this.scala$collection$Iterator$SliceIterator$$remaining = x$1;
        }

        private int dropping() {
            return this.dropping;
        }

        private void dropping_$eq(int x$1) {
            this.dropping = x$1;
        }

        private void skip() {
            while (this.dropping() > 0) {
                if (this.underlying().hasNext()) {
                    this.underlying().next();
                    this.dropping_$eq(this.dropping() - 1);
                    continue;
                }
                this.dropping_$eq(0);
            }
        }

        @Override
        public boolean hasNext() {
            this.skip();
            return this.scala$collection$Iterator$SliceIterator$$remaining() != 0 && this.underlying().hasNext();
        }

        @Override
        public A next() {
            this.skip();
            if (this.scala$collection$Iterator$SliceIterator$$remaining() > 0) {
                this.scala$collection$Iterator$SliceIterator$$remaining_$eq(this.scala$collection$Iterator$SliceIterator$$remaining() - 1);
                return this.underlying().next();
            }
            if (this.scala$collection$Iterator$SliceIterator$$remaining() < 0) {
                return this.underlying().next();
            }
            return (A)Iterator$.MODULE$.empty().next();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Iterator<A> sliceIterator(int from, int until) {
            int rest;
            int n;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            int lo = RichInt$.MODULE$.max$extension(from, 0);
            if (until < 0) {
                n = this.adjustedBound$1(lo);
            } else if (until <= lo) {
                n = 0;
            } else if (this.scala$collection$Iterator$SliceIterator$$remaining() < 0) {
                n = until - lo;
            } else {
                void intWrapper_x;
                int n2 = this.adjustedBound$1(lo);
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                n = rest = RichInt$.MODULE$.min$extension((int)intWrapper_x, until - lo);
            }
            if (rest == 0) {
                return Iterator$.MODULE$.empty();
            }
            this.dropping_$eq(this.dropping() + lo);
            this.scala$collection$Iterator$SliceIterator$$remaining_$eq(rest);
            return this;
        }

        private final int adjustedBound$1(int lo$1) {
            if (this.scala$collection$Iterator$SliceIterator$$remaining() < 0) {
                return -1;
            }
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return RichInt$.MODULE$.max$extension(n, this.scala$collection$Iterator$SliceIterator$$remaining() - lo$1);
        }

        public SliceIterator(Iterator<A> underlying, int start, int limit) {
            this.underlying = underlying;
            this.scala$collection$Iterator$SliceIterator$$remaining = limit;
            this.dropping = start;
        }
    }
}

