/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.collection.immutable;

import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.Serializable;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.AbstractSeq;
import coursierapi.shaded.scala.collection.CustomParallelizable;
import coursierapi.shaded.scala.collection.GenSeqLike;
import coursierapi.shaded.scala.collection.IndexedSeq;
import coursierapi.shaded.scala.collection.IndexedSeqLike;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.TraversableOnce;
import coursierapi.shaded.scala.collection.generic.GenericCompanion;
import coursierapi.shaded.scala.collection.immutable.Iterable;
import coursierapi.shaded.scala.collection.immutable.Nil$;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.collection.immutable.StringOps;
import coursierapi.shaded.scala.collection.immutable.Traversable;
import coursierapi.shaded.scala.collection.mutable.Buffer;
import coursierapi.shaded.scala.collection.parallel.Combiner;
import coursierapi.shaded.scala.collection.parallel.immutable.ParRange;
import coursierapi.shaded.scala.math.Numeric;
import coursierapi.shaded.scala.math.Numeric$IntIsIntegral$;
import coursierapi.shaded.scala.math.Ordering;
import coursierapi.shaded.scala.math.Ordering$Int$;
import coursierapi.shaded.scala.runtime.BoxedUnit;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Nothing$;

public class Range
extends AbstractSeq<Object>
implements Serializable,
CustomParallelizable<Object, ParRange>,
coursierapi.shaded.scala.collection.immutable.IndexedSeq<Object> {
    private final int start;
    private final int end;
    private final int step;
    private final boolean isEmpty;
    private final int scala$collection$immutable$Range$$numRangeElements;
    private final int scala$collection$immutable$Range$$lastElement;

    @Override
    public Combiner<Object, ParRange> parCombiner() {
        return CustomParallelizable.parCombiner$(this);
    }

    @Override
    public GenericCompanion<coursierapi.shaded.scala.collection.immutable.IndexedSeq> companion() {
        return coursierapi.shaded.scala.collection.immutable.IndexedSeq.companion$(this);
    }

    @Override
    public coursierapi.shaded.scala.collection.immutable.IndexedSeq<Object> toIndexedSeq() {
        return coursierapi.shaded.scala.collection.immutable.IndexedSeq.toIndexedSeq$(this);
    }

    @Override
    public coursierapi.shaded.scala.collection.immutable.IndexedSeq<Object> seq() {
        return coursierapi.shaded.scala.collection.immutable.IndexedSeq.seq$(this);
    }

    @Override
    public int hashCode() {
        return IndexedSeqLike.hashCode$(this);
    }

    @Override
    public IndexedSeq<Object> thisCollection() {
        return IndexedSeqLike.thisCollection$(this);
    }

    @Override
    public IndexedSeq toCollection(Object repr) {
        return IndexedSeqLike.toCollection$(this, repr);
    }

    @Override
    public Iterator<Object> iterator() {
        return IndexedSeqLike.iterator$(this);
    }

    @Override
    public <A1> Buffer<A1> toBuffer() {
        return IndexedSeqLike.toBuffer$(this);
    }

    @Override
    public int sizeHintIfCheap() {
        return IndexedSeqLike.sizeHintIfCheap$(this);
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int step() {
        return this.step;
    }

    @Override
    public ParRange par() {
        return new ParRange(this);
    }

    private long gap() {
        return (long)this.end() - (long)this.start();
    }

    private boolean isExact() {
        return this.gap() % (long)this.step() == 0L;
    }

    private boolean hasStub() {
        return this.isInclusive() || !this.isExact();
    }

    private long longLength() {
        return this.gap() / (long)this.step() + (long)(this.hasStub() ? 1 : 0);
    }

    @Override
    public final boolean isEmpty() {
        return this.isEmpty;
    }

    public int scala$collection$immutable$Range$$numRangeElements() {
        return this.scala$collection$immutable$Range$$numRangeElements;
    }

    public int scala$collection$immutable$Range$$lastElement() {
        return this.scala$collection$immutable$Range$$lastElement;
    }

    @Override
    public int last() {
        if (this.isEmpty()) {
            return BoxesRunTime.unboxToInt(Nil$.MODULE$.last());
        }
        return this.scala$collection$immutable$Range$$lastElement();
    }

    @Override
    public int head() {
        if (this.isEmpty()) {
            throw Nil$.MODULE$.head();
        }
        return this.start();
    }

    @Override
    public <A1> int min(Ordering<A1> ord) {
        if (ord == Ordering$Int$.MODULE$) {
            if (this.step() > 0) {
                return this.head();
            }
            return this.last();
        }
        return BoxesRunTime.unboxToInt(TraversableOnce.min$(this, ord));
    }

    @Override
    public <A1> int max(Ordering<A1> ord) {
        if (ord == Ordering$Int$.MODULE$) {
            if (this.step() > 0) {
                return this.last();
            }
            return this.head();
        }
        return BoxesRunTime.unboxToInt(TraversableOnce.max$(this, ord));
    }

    public Range copy(int start, int end, int step) {
        return new Range(start, end, step);
    }

    public boolean isInclusive() {
        return false;
    }

    @Override
    public int size() {
        return this.length();
    }

    @Override
    public int length() {
        if (this.scala$collection$immutable$Range$$numRangeElements() < 0) {
            throw this.fail();
        }
        return this.scala$collection$immutable$Range$$numRangeElements();
    }

    private String description() {
        String string = "%d %s %d by %s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(string).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.start()), this.isInclusive() ? "to" : "until", BoxesRunTime.boxToInteger(this.end()), BoxesRunTime.boxToInteger(this.step())}));
    }

    private Nothing$ fail() {
        throw new IllegalArgumentException(new StringBuilder(54).append(this.description()).append(": seqs cannot contain more than Int.MaxValue elements.").toString());
    }

    public void scala$collection$immutable$Range$$validateMaxLength() {
        if (this.scala$collection$immutable$Range$$numRangeElements() < 0) {
            throw this.fail();
        }
    }

    @Override
    public final int apply(int idx) {
        return this.apply$mcII$sp(idx);
    }

    @Override
    public final <U> void foreach(Function1<Object, U> f) {
        if (!this.isEmpty()) {
            int i = this.start();
            while (true) {
                f.apply(BoxesRunTime.boxToInteger(i));
                if (i == this.scala$collection$immutable$Range$$lastElement()) {
                    return;
                }
                i += this.step();
            }
        }
    }

    @Override
    public final Range take(int n) {
        if (n <= 0 || this.isEmpty()) {
            return this.newEmptyRange(this.start());
        }
        if (n >= this.scala$collection$immutable$Range$$numRangeElements() && this.scala$collection$immutable$Range$$numRangeElements() >= 0) {
            return this;
        }
        return new Inclusive(this.start(), this.locationAfterN(n - 1), this.step());
    }

    @Override
    public final Range drop(int n) {
        if (n <= 0 || this.isEmpty()) {
            return this;
        }
        if (n >= this.scala$collection$immutable$Range$$numRangeElements() && this.scala$collection$immutable$Range$$numRangeElements() >= 0) {
            return this.newEmptyRange(this.end());
        }
        return this.copy(this.locationAfterN(n), this.end(), this.step());
    }

    @Override
    public Range slice(int from, int until) {
        if (from <= 0) {
            return this.take(until);
        }
        if (until >= this.scala$collection$immutable$Range$$numRangeElements() && this.scala$collection$immutable$Range$$numRangeElements() >= 0) {
            return this.drop(from);
        }
        int fromValue = this.locationAfterN(from);
        if (from >= until) {
            return this.newEmptyRange(fromValue);
        }
        return new Inclusive(fromValue, this.locationAfterN(until - 1), this.step());
    }

    @Override
    public final Range init() {
        if (this.isEmpty()) {
            Nil$.MODULE$.init();
        }
        return this.dropRight(1);
    }

    @Override
    public final Range tail() {
        if (this.isEmpty()) {
            Nil$.MODULE$.tail();
        }
        return this.drop(1);
    }

    private int locationAfterN(int n) {
        return this.start() + this.step() * n;
    }

    private Range newEmptyRange(int value) {
        return new Range(value, value, this.step());
    }

    @Override
    public final Tuple2<Range, Range> splitAt(int n) {
        return new Tuple2<Range, Range>(this.take(n), this.drop(n));
    }

    @Override
    public final Range dropRight(int n) {
        if (n <= 0) {
            return this;
        }
        if (this.scala$collection$immutable$Range$$numRangeElements() >= 0) {
            return this.take(this.scala$collection$immutable$Range$$numRangeElements() - n);
        }
        int y = this.last() - this.step() * n;
        if (this.step() > 0 && y < this.start() || this.step() < 0 && y > this.start()) {
            return this.newEmptyRange(this.start());
        }
        return new Inclusive(this.start(), y, this.step());
    }

    @Override
    public final Range reverse() {
        if (this.isEmpty()) {
            return this;
        }
        return new Inclusive(this.last(), this.start(), -this.step());
    }

    @Override
    public final <B> int sum(Numeric<B> num) {
        if (num == Numeric$IntIsIntegral$.MODULE$) {
            if (this.isEmpty()) {
                return 0;
            }
            if (this.scala$collection$immutable$Range$$numRangeElements() == 1) {
                return this.head();
            }
            return (int)((long)this.scala$collection$immutable$Range$$numRangeElements() * ((long)this.head() + (long)this.last()) / 2L);
        }
        if (this.isEmpty()) {
            return num.toInt(num.zero());
        }
        Object acc2 = num.zero();
        int i = this.head();
        while (true) {
            acc2 = num.plus(acc2, BoxesRunTime.boxToInteger(i));
            if (i == this.scala$collection$immutable$Range$$lastElement()) {
                return num.toInt(acc2);
            }
            i += this.step();
        }
    }

    @Override
    public Range toSeq() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Range) {
            int l0;
            Range range = (Range)other;
            return range.canEqual(this) && !(!this.isEmpty() ? !range.nonEmpty() || this.start() != range.start() || (l0 = this.last()) != range.last() || this.start() != l0 && this.step() != range.step() : !range.isEmpty());
            {
            }
        }
        return GenSeqLike.equals$(this, other);
    }

    @Override
    public String toString() {
        String stepped;
        String preposition = this.isInclusive() ? "to" : "until";
        String string = stepped = this.step() == 1 ? "" : new StringBuilder(4).append(" by ").append(this.step()).toString();
        String prefix = this.isEmpty() ? "empty " : (!this.isExact() ? "inexact " : "");
        return new StringBuilder(8).append(prefix).append("Range ").append(this.start()).append(" ").append(preposition).append(" ").append(this.end()).append(stepped).toString();
    }

    public final void foreach$mVc$sp(Function1<Object, BoxedUnit> f) {
        if (!this.isEmpty()) {
            int i = this.start();
            while (true) {
                f.apply$mcVI$sp(i);
                if (i == this.scala$collection$immutable$Range$$lastElement()) {
                    return;
                }
                i += this.step();
            }
        }
    }

    @Override
    public int apply$mcII$sp(int idx) {
        this.scala$collection$immutable$Range$$validateMaxLength();
        if (idx < 0 || idx >= this.scala$collection$immutable$Range$$numRangeElements()) {
            throw new IndexOutOfBoundsException(Integer.toString(idx));
        }
        return this.start() + this.step() * idx;
    }

    public Range(int start, int end, int step) {
        int n;
        long len;
        this.start = start;
        this.end = end;
        this.step = step;
        Traversable.$init$(this);
        Iterable.$init$(this);
        Seq.$init$(this);
        IndexedSeqLike.$init$(this);
        IndexedSeq.$init$(this);
        coursierapi.shaded.scala.collection.immutable.IndexedSeq.$init$(this);
        CustomParallelizable.$init$(this);
        boolean bl = this.isEmpty = start > end && step > 0 || start < end && step < 0 || start == end && !this.isInclusive();
        if (step == 0) {
            throw new IllegalArgumentException("step cannot be 0.");
        }
        this.scala$collection$immutable$Range$$numRangeElements = this.isEmpty() ? 0 : ((len = this.longLength()) > Integer.MAX_VALUE ? -1 : (int)len);
        switch (step) {
            case 1: {
                if (this.isInclusive()) {
                    n = end;
                    break;
                }
                n = end - 1;
                break;
            }
            case -1: {
                if (this.isInclusive()) {
                    n = end;
                    break;
                }
                n = end + 1;
                break;
            }
            default: {
                int remainder = (int)(this.gap() % (long)step);
                n = remainder != 0 ? end - remainder : (this.isInclusive() ? end : end - step);
            }
        }
        this.scala$collection$immutable$Range$$lastElement = n;
    }

    public static final class Inclusive
    extends Range {
        @Override
        public boolean isInclusive() {
            return true;
        }

        @Override
        public Range copy(int start, int end, int step) {
            return new Inclusive(start, end, step);
        }

        public Inclusive(int start, int end, int step) {
            super(start, end, step);
        }
    }
}

