/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.collection.mutable;

import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.collection.AbstractIterator;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.Iterator$;
import coursierapi.shaded.scala.collection.immutable.Range;
import coursierapi.shaded.scala.collection.mutable.ArrayOps;
import coursierapi.shaded.scala.collection.mutable.FlatHashTable$;
import coursierapi.shaded.scala.collection.mutable.FlatHashTable$NullSentinel$;
import coursierapi.shaded.scala.collection.mutable.HashTable$;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.RichInt$;
import coursierapi.shaded.scala.util.hashing.package$;
import java.util.Arrays;

public interface FlatHashTable<A>
extends HashUtils<A> {
    private boolean tableDebug() {
        return false;
    }

    public int _loadFactor();

    public void _loadFactor_$eq(int var1);

    public Object[] table();

    public void table_$eq(Object[] var1);

    public int tableSize();

    public void tableSize_$eq(int var1);

    public int threshold();

    public void threshold_$eq(int var1);

    public int[] sizemap();

    public void sizemap_$eq(int[] var1);

    public int seedvalue();

    public void seedvalue_$eq(int var1);

    public static /* synthetic */ int capacity$(FlatHashTable $this, int expectedSize) {
        return $this.capacity(expectedSize);
    }

    default public int capacity(int expectedSize) {
        return HashTable$.MODULE$.nextPositivePowerOfTwo(expectedSize);
    }

    public static /* synthetic */ int initialSize$(FlatHashTable $this) {
        return $this.initialSize();
    }

    default public int initialSize() {
        return 32;
    }

    private int initialCapacity() {
        return this.capacity(this.initialSize());
    }

    public static /* synthetic */ int tableSizeSeed$(FlatHashTable $this) {
        return $this.tableSizeSeed();
    }

    default public int tableSizeSeed() {
        return Integer.bitCount(this.table().length - 1);
    }

    public static /* synthetic */ boolean containsElem$(FlatHashTable $this, Object elem) {
        return $this.containsElem(elem);
    }

    default public boolean containsElem(A elem) {
        return this.findElemImpl(elem) != null;
    }

    private Object findElemImpl(A elem) {
        Object searchEntry = this.elemToEntry(elem);
        int h = this.index(searchEntry.hashCode());
        Object curEntry = this.table()[h];
        while (curEntry != null && !BoxesRunTime.equals(curEntry, searchEntry)) {
            h = (h + 1) % this.table().length;
            curEntry = this.table()[h];
        }
        return curEntry;
    }

    public static /* synthetic */ boolean addElem$(FlatHashTable $this, Object elem) {
        return $this.addElem(elem);
    }

    default public boolean addElem(A elem) {
        return this.addEntry(this.elemToEntry(elem));
    }

    public static /* synthetic */ boolean addEntry$(FlatHashTable $this, Object newEntry) {
        return $this.addEntry(newEntry);
    }

    default public boolean addEntry(Object newEntry) {
        int h = this.index(newEntry.hashCode());
        Object curEntry = this.table()[h];
        while (curEntry != null) {
            if (BoxesRunTime.equals(curEntry, newEntry)) {
                return false;
            }
            h = (h + 1) % this.table().length;
            curEntry = this.table()[h];
        }
        this.table()[h] = newEntry;
        this.tableSize_$eq(this.tableSize() + 1);
        this.nnSizeMapAdd(h);
        if (this.tableSize() >= this.threshold()) {
            this.growTable();
        }
        return true;
    }

    public static /* synthetic */ boolean removeElem$(FlatHashTable $this, Object elem) {
        return $this.removeElem(elem);
    }

    default public boolean removeElem(A elem) {
        if (this.tableDebug()) {
            this.checkConsistent();
        }
        Object removalEntry = this.elemToEntry(elem);
        int h = this.index(removalEntry.hashCode());
        Object curEntry = this.table()[h];
        while (curEntry != null) {
            if (BoxesRunTime.equals(curEntry, removalEntry)) {
                int h0 = h;
                int h1 = (h + 1) % this.table().length;
                while (this.table()[h1] != null) {
                    int h2 = this.index(this.table()[h1].hashCode());
                    if (h2 != h1 && this.precedes$1(h2, h0)) {
                        this.table()[h0] = this.table()[h1];
                        h0 = h1;
                    }
                    h1 = (h1 + 1) % this.table().length;
                }
                this.table()[h0] = null;
                this.tableSize_$eq(this.tableSize() - 1);
                this.nnSizeMapRemove(h0);
                if (this.tableDebug()) {
                    this.checkConsistent();
                }
                return true;
            }
            h = (h + 1) % this.table().length;
            curEntry = this.table()[h];
        }
        return false;
    }

    public static /* synthetic */ Iterator iterator$(FlatHashTable $this) {
        return $this.iterator();
    }

    default public Iterator<A> iterator() {
        return new AbstractIterator<A>(this){
            private int i;
            private final /* synthetic */ FlatHashTable $outer;

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                while (this.i() < this.$outer.table().length && this.$outer.table()[this.i()] == null) {
                    this.i_$eq(this.i() + 1);
                }
                return this.i() < this.$outer.table().length;
            }

            public A next() {
                if (this.hasNext()) {
                    this.i_$eq(this.i() + 1);
                    return this.$outer.entryToElem(this.$outer.table()[this.i() - 1]);
                }
                return (A)Iterator$.MODULE$.empty().next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.i = 0;
            }
        };
    }

    private void growTable() {
        Object[] oldtable = this.table();
        this.table_$eq(new Object[this.table().length * 2]);
        this.tableSize_$eq(0);
        this.nnSizeMapReset(this.table().length);
        this.seedvalue_$eq(this.tableSizeSeed());
        this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold(this._loadFactor(), this.table().length));
        for (int i = 0; i < oldtable.length; ++i) {
            Object entry = oldtable[i];
            if (entry == null) continue;
            this.addEntry(entry);
        }
        if (this.tableDebug()) {
            this.checkConsistent();
            return;
        }
    }

    private void checkConsistent() {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.table().length);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                FlatHashTable.$anonfun$checkConsistent$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    public static /* synthetic */ void nnSizeMapAdd$(FlatHashTable $this, int h) {
        $this.nnSizeMapAdd(h);
    }

    default public void nnSizeMapAdd(int h) {
        if (this.sizemap() != null) {
            int p = h >> this.sizeMapBucketBitSize();
            int[] nArray = this.sizemap();
            nArray[p] = nArray[p] + 1;
            return;
        }
    }

    public static /* synthetic */ void nnSizeMapRemove$(FlatHashTable $this, int h) {
        $this.nnSizeMapRemove(h);
    }

    default public void nnSizeMapRemove(int h) {
        if (this.sizemap() != null) {
            int[] nArray = this.sizemap();
            int n = h >> this.sizeMapBucketBitSize();
            nArray[n] = nArray[n] - 1;
            return;
        }
    }

    public static /* synthetic */ void nnSizeMapReset$(FlatHashTable $this, int tableLength) {
        $this.nnSizeMapReset(tableLength);
    }

    default public void nnSizeMapReset(int tableLength) {
        if (this.sizemap() != null) {
            int nsize = this.calcSizeMapSize(tableLength);
            if (this.sizemap().length != nsize) {
                this.sizemap_$eq(new int[nsize]);
                return;
            }
            Arrays.fill(this.sizemap(), 0);
            return;
        }
    }

    public static /* synthetic */ int totalSizeMapBuckets$(FlatHashTable $this) {
        return $this.totalSizeMapBuckets();
    }

    default public int totalSizeMapBuckets() {
        return (this.table().length - 1) / this.sizeMapBucketSize() + 1;
    }

    public static /* synthetic */ int calcSizeMapSize$(FlatHashTable $this, int tableLength) {
        return $this.calcSizeMapSize(tableLength);
    }

    default public int calcSizeMapSize(int tableLength) {
        return (tableLength >> this.sizeMapBucketBitSize()) + 1;
    }

    public static /* synthetic */ void sizeMapInit$(FlatHashTable $this, int tableLength) {
        $this.sizeMapInit(tableLength);
    }

    default public void sizeMapInit(int tableLength) {
        this.sizemap_$eq(new int[this.calcSizeMapSize(tableLength)]);
    }

    public static /* synthetic */ void sizeMapInitAndRebuild$(FlatHashTable $this) {
        $this.sizeMapInitAndRebuild();
    }

    /*
     * WARNING - void declaration
     */
    default public void sizeMapInitAndRebuild() {
        void intWrapper_x;
        this.sizeMapInit(this.table().length);
        int totalbuckets = this.totalSizeMapBuckets();
        int tableidx = 0;
        Object[] tbl = this.table();
        int n = this.sizeMapBucketSize();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        int tableuntil = RichInt$.MODULE$.min$extension((int)intWrapper_x, tbl.length);
        for (int bucketidx = 0; bucketidx < totalbuckets; ++bucketidx) {
            int currbucketsz = 0;
            while (tableidx < tableuntil) {
                if (tbl[tableidx] != null) {
                    ++currbucketsz;
                }
                ++tableidx;
            }
            this.sizemap()[bucketidx] = currbucketsz;
            tableuntil += this.sizeMapBucketSize();
        }
    }

    public static /* synthetic */ boolean alwaysInitSizeMap$(FlatHashTable $this) {
        return $this.alwaysInitSizeMap();
    }

    default public boolean alwaysInitSizeMap() {
        return false;
    }

    public static /* synthetic */ int index$(FlatHashTable $this, int hcode) {
        return $this.index(hcode);
    }

    default public int index(int hcode) {
        int improved = this.improve(hcode, this.seedvalue());
        int ones = this.table().length - 1;
        return improved >>> 32 - Integer.bitCount(ones) & ones;
    }

    public static /* synthetic */ void clearTable$(FlatHashTable $this) {
        $this.clearTable();
    }

    default public void clearTable() {
        for (int i = this.table().length - 1; i >= 0; --i) {
            this.table()[i] = null;
        }
        this.tableSize_$eq(0);
        this.nnSizeMapReset(this.table().length);
    }

    public static /* synthetic */ Contents hashTableContents$(FlatHashTable $this) {
        return $this.hashTableContents();
    }

    default public Contents<A> hashTableContents() {
        return new Contents(this._loadFactor(), this.table(), this.tableSize(), this.threshold(), this.seedvalue(), this.sizemap());
    }

    public static /* synthetic */ void initWithContents$(FlatHashTable $this, Contents c) {
        $this.initWithContents(c);
    }

    default public void initWithContents(Contents<A> c) {
        if (c != null) {
            this._loadFactor_$eq(c.loadFactor());
            this.table_$eq(c.table());
            this.tableSize_$eq(c.tableSize());
            this.threshold_$eq(c.threshold());
            this.seedvalue_$eq(c.seedvalue());
            this.sizemap_$eq(c.sizemap());
        }
        if (this.alwaysInitSizeMap() && this.sizemap() == null) {
            this.sizeMapInitAndRebuild();
            return;
        }
    }

    private boolean precedes$1(int i, int j) {
        int d = this.table().length >> 1;
        if (i <= j) {
            return j - i < d;
        }
        return i - j > d;
    }

    public static /* synthetic */ String $anonfun$checkConsistent$2(FlatHashTable $this, int i$1) {
        return new StringBuilder(2).append(i$1).append(" ").append($this.table()[i$1]).append(" ").append(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps($this.table())).mkString()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ void $anonfun$checkConsistent$1(FlatHashTable $this, int i) {
        if ($this.table()[i] != null && !$this.containsElem($this.entryToElem($this.table()[i]))) {
            void assert_assertion;
            boolean bl = false;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            if (assert_assertion == false) {
                throw new AssertionError((Object)new StringBuilder(18).append("assertion failed: ").append((Object)FlatHashTable.$anonfun$checkConsistent$2($this, i)).toString());
            }
            return;
        }
    }

    public static void $init$(FlatHashTable $this) {
        $this._loadFactor_$eq(FlatHashTable$.MODULE$.defaultLoadFactor());
        $this.table_$eq(new Object[$this.initialCapacity()]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold($this._loadFactor(), $this.initialCapacity()));
        $this.sizemap_$eq(null);
        $this.seedvalue_$eq($this.tableSizeSeed());
    }

    public static class Contents<A> {
        private final int loadFactor;
        private final Object[] table;
        private final int tableSize;
        private final int threshold;
        private final int seedvalue;
        private final int[] sizemap;

        public int loadFactor() {
            return this.loadFactor;
        }

        public Object[] table() {
            return this.table;
        }

        public int tableSize() {
            return this.tableSize;
        }

        public int threshold() {
            return this.threshold;
        }

        public int seedvalue() {
            return this.seedvalue;
        }

        public int[] sizemap() {
            return this.sizemap;
        }

        public Contents(int loadFactor, Object[] table, int tableSize, int threshold, int seedvalue, int[] sizemap) {
            this.loadFactor = loadFactor;
            this.table = table;
            this.tableSize = tableSize;
            this.threshold = threshold;
            this.seedvalue = seedvalue;
            this.sizemap = sizemap;
        }
    }

    public static interface HashUtils<A> {
        public static /* synthetic */ int sizeMapBucketBitSize$(HashUtils $this) {
            return $this.sizeMapBucketBitSize();
        }

        default public int sizeMapBucketBitSize() {
            return 5;
        }

        public static /* synthetic */ int sizeMapBucketSize$(HashUtils $this) {
            return $this.sizeMapBucketSize();
        }

        default public int sizeMapBucketSize() {
            return 1 << this.sizeMapBucketBitSize();
        }

        public static /* synthetic */ int improve$(HashUtils $this, int hcode, int seed) {
            return $this.improve(hcode, seed);
        }

        default public int improve(int hcode, int seed) {
            return Integer.rotateRight(package$.MODULE$.byteswap32(hcode), seed);
        }

        public static /* synthetic */ Object elemToEntry$(HashUtils $this, Object elem) {
            return $this.elemToEntry(elem);
        }

        default public Object elemToEntry(A elem) {
            if (elem == null) {
                return FlatHashTable$NullSentinel$.MODULE$;
            }
            return elem;
        }

        public static /* synthetic */ Object entryToElem$(HashUtils $this, Object entry) {
            return $this.entryToElem(entry);
        }

        default public A entryToElem(Object entry) {
            if (entry == FlatHashTable$NullSentinel$.MODULE$) {
                return null;
            }
            return (A)entry;
        }

        public static void $init$(HashUtils $this) {
        }
    }
}

