/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.collection.mutable;

import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.collection.TraversableLike;
import coursierapi.shaded.scala.collection.TraversableOnce;
import coursierapi.shaded.scala.collection.generic.Growable;
import coursierapi.shaded.scala.collection.mutable.Builder;
import coursierapi.shaded.scala.collection.mutable.ReusableBuilder;
import coursierapi.shaded.scala.collection.mutable.WrappedArray;
import coursierapi.shaded.scala.reflect.ClassTag;
import coursierapi.shaded.scala.runtime.BoxedUnit;
import java.util.Arrays;

public class WrappedArrayBuilder<A>
implements ReusableBuilder<A, WrappedArray<A>> {
    private final ClassTag<A> tag;
    private final ClassTag<A> manifest;
    private WrappedArray<A> elems;
    private int capacity;
    private int size;

    @Override
    public void sizeHint(TraversableLike<?, ?> coll) {
        Builder.sizeHint$((Builder)this, coll);
    }

    @Override
    public void sizeHint(TraversableLike<?, ?> coll, int delta) {
        Builder.sizeHint$(this, coll, delta);
    }

    @Override
    public void sizeHintBounded(int size, TraversableLike<?, ?> boundingColl) {
        Builder.sizeHintBounded$(this, size, boundingColl);
    }

    @Override
    public <NewTo> Builder<A, NewTo> mapResult(Function1<WrappedArray<A>, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    @Override
    public Growable<A> $plus$plus$eq(TraversableOnce<A> xs) {
        return Growable.$plus$plus$eq$(this, xs);
    }

    private WrappedArray<A> elems() {
        return this.elems;
    }

    private void elems_$eq(WrappedArray<A> x$1) {
        this.elems = x$1;
    }

    private int capacity() {
        return this.capacity;
    }

    private void capacity_$eq(int x$1) {
        this.capacity = x$1;
    }

    private int size() {
        return this.size;
    }

    private void size_$eq(int x$1) {
        this.size = x$1;
    }

    private WrappedArray<A> mkArray(int size) {
        if (size == 0) {
            return this.tag.emptyWrappedArray();
        }
        Class<?> runtimeClass = this.tag.runtimeClass();
        if (runtimeClass.isPrimitive()) {
            Class<Integer> clazz = Integer.TYPE;
            if (clazz != null && clazz.equals(runtimeClass)) {
                int[] array = this.elems() == null ? new int[size] : Arrays.copyOf((int[])this.elems().array(), size);
                return new WrappedArray.ofInt(array);
            }
            Class<Double> clazz2 = Double.TYPE;
            if (clazz2 != null && clazz2.equals(runtimeClass)) {
                double[] array = this.elems() == null ? new double[size] : Arrays.copyOf((double[])this.elems().array(), size);
                return new WrappedArray.ofDouble(array);
            }
            Class<Long> clazz3 = Long.TYPE;
            if (clazz3 != null && clazz3.equals(runtimeClass)) {
                long[] array = this.elems() == null ? new long[size] : Arrays.copyOf((long[])this.elems().array(), size);
                return new WrappedArray.ofLong(array);
            }
            Class<Float> clazz4 = Float.TYPE;
            if (clazz4 != null && clazz4.equals(runtimeClass)) {
                float[] array = this.elems() == null ? new float[size] : Arrays.copyOf((float[])this.elems().array(), size);
                return new WrappedArray.ofFloat(array);
            }
            Class<Character> clazz5 = Character.TYPE;
            if (clazz5 != null && clazz5.equals(runtimeClass)) {
                char[] array = this.elems() == null ? new char[size] : Arrays.copyOf((char[])this.elems().array(), size);
                return new WrappedArray.ofChar(array);
            }
            Class<Byte> clazz6 = Byte.TYPE;
            if (clazz6 != null && clazz6.equals(runtimeClass)) {
                byte[] array = this.elems() == null ? new byte[size] : Arrays.copyOf((byte[])this.elems().array(), size);
                return new WrappedArray.ofByte(array);
            }
            Class<Short> clazz7 = Short.TYPE;
            if (clazz7 != null && clazz7.equals(runtimeClass)) {
                short[] array = this.elems() == null ? new short[size] : Arrays.copyOf((short[])this.elems().array(), size);
                return new WrappedArray.ofShort(array);
            }
            Class<Boolean> clazz8 = Boolean.TYPE;
            if (clazz8 != null && clazz8.equals(runtimeClass)) {
                boolean[] array = this.elems() == null ? new boolean[size] : Arrays.copyOf((boolean[])this.elems().array(), size);
                return new WrappedArray.ofBoolean(array);
            }
            Class<Void> clazz9 = Void.TYPE;
            if (clazz9 != null && clazz9.equals(runtimeClass)) {
                BoxedUnit[] array = this.elems() == null ? new BoxedUnit[size] : (BoxedUnit[])Arrays.copyOf((Object[])this.elems().array(), size);
                return new WrappedArray.ofUnit(array);
            }
            throw new MatchError(runtimeClass);
        }
        Object[] array = this.elems() == null ? new Object[size] : Arrays.copyOf((Object[])this.elems().array(), size);
        return new WrappedArray.ofRef<Object>(array);
    }

    private void resize(int size) {
        this.elems_$eq(this.mkArray(size));
        this.capacity_$eq(size);
    }

    @Override
    public void sizeHint(int size) {
        if (this.capacity() < size) {
            this.resize(size);
            return;
        }
    }

    private void ensureSize(int size) {
        if (this.capacity() < size) {
            int newsize;
            int n = newsize = this.capacity() == 0 ? 16 : this.capacity() * 2;
            while (newsize < size) {
                newsize *= 2;
            }
            this.resize(newsize);
            return;
        }
    }

    @Override
    public WrappedArrayBuilder<A> $plus$eq(A elem) {
        this.ensureSize(this.size() + 1);
        this.elems().update(this.size(), elem);
        this.size_$eq(this.size() + 1);
        return this;
    }

    @Override
    public WrappedArray<A> result() {
        if (this.capacity() != 0 && this.capacity() == this.size()) {
            this.capacity_$eq(0);
            return this.elems();
        }
        return this.mkArray(this.size());
    }

    public WrappedArrayBuilder(ClassTag<A> tag) {
        this.tag = tag;
        Growable.$init$(this);
        Builder.$init$(this);
        this.manifest = tag;
        this.capacity = 0;
        this.size = 0;
    }
}

