/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.concurrent.duration;

import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.concurrent.duration.Duration;
import coursierapi.shaded.scala.concurrent.duration.Duration$;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.RichLong;
import java.util.concurrent.TimeUnit;

public final class FiniteDuration
extends Duration {
    private final long length;
    private final TimeUnit unit;

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public TimeUnit unit() {
        return this.unit;
    }

    private boolean bounded(long max) {
        return -max <= this.length() && this.length() <= max;
    }

    public long toNanos() {
        return this.unit().toNanos(this.length());
    }

    @Override
    public long toMillis() {
        return this.unit().toMillis(this.length());
    }

    private String unitString() {
        return new StringBuilder(0).append((String)Duration$.MODULE$.timeUnitName().apply(this.unit())).append((Object)(this.length() == 1L ? "" : "s")).toString();
    }

    public String toString() {
        return new StringBuilder(1).append(this.length()).append(" ").append(this.unitString()).toString();
    }

    @Override
    public int compare(Duration other) {
        if (other instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)other;
            long l = this.toNanos();
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return new RichLong(l).compare(BoxesRunTime.boxToLong(finiteDuration.toNanos()));
        }
        return -other.compare(this);
    }

    @Override
    public Duration $times(double factor) {
        if (!Double.isInfinite(factor)) {
            return Duration$.MODULE$.fromNanos((double)this.toNanos() * factor);
        }
        if (Double.isNaN(factor)) {
            return Duration$.MODULE$.Undefined();
        }
        if (factor > 0.0 ^ this.$less(Duration$.MODULE$.Zero())) {
            return Duration$.MODULE$.Inf();
        }
        return Duration$.MODULE$.MinusInf();
    }

    @Override
    public FiniteDuration unary_$minus() {
        return Duration$.MODULE$.apply(-this.length(), this.unit());
    }

    @Override
    public final boolean isFinite() {
        return true;
    }

    public boolean equals(Object other) {
        if (other instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)other;
            return this.toNanos() == finiteDuration.toNanos();
        }
        return super.equals(other);
    }

    public int hashCode() {
        return (int)this.toNanos();
    }

    public static final /* synthetic */ String $anonfun$new$1() {
        return "Duration is limited to +-(2^63-1)ns (ca. 292 years)";
    }

    /*
     * WARNING - void declaration
     */
    public FiniteDuration(long length, TimeUnit unit) {
        void require_requirement;
        long v;
        boolean bl;
        this.length = length;
        this.unit = unit;
        boolean bl2 = ((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)unit) ? this.bounded(Long.MAX_VALUE) : (((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)unit) ? this.bounded(9223372036854775L) : (((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)unit) ? this.bounded(9223372036854L) : (((Object)((Object)TimeUnit.SECONDS)).equals((Object)unit) ? this.bounded(9223372036L) : (((Object)((Object)TimeUnit.MINUTES)).equals((Object)unit) ? this.bounded(153722867L) : (((Object)((Object)TimeUnit.HOURS)).equals((Object)unit) ? this.bounded(2562047L) : (((Object)((Object)TimeUnit.DAYS)).equals((Object)unit) ? this.bounded(106751L) : (bl = -106751L <= (v = TimeUnit.DAYS.convert(length, unit)) && v <= 106751L)))))));
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (require_requirement == false) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)FiniteDuration.$anonfun$new$1()).toString());
        }
    }
}

