/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.scala.concurrent.impl;

import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.Function2;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.PartialFunction;
import coursierapi.shaded.scala.Serializable;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.collection.immutable.List;
import coursierapi.shaded.scala.collection.immutable.Nil$;
import coursierapi.shaded.scala.concurrent.CanAwait;
import coursierapi.shaded.scala.concurrent.ExecutionContext;
import coursierapi.shaded.scala.concurrent.Future;
import coursierapi.shaded.scala.concurrent.Future$InternalCallbackExecutor$;
import coursierapi.shaded.scala.concurrent.duration.Duration;
import coursierapi.shaded.scala.concurrent.duration.Duration$;
import coursierapi.shaded.scala.concurrent.duration.FiniteDuration;
import coursierapi.shaded.scala.concurrent.impl.CallbackRunnable;
import coursierapi.shaded.scala.concurrent.impl.Promise$;
import coursierapi.shaded.scala.runtime.BoxedUnit;
import coursierapi.shaded.scala.util.Failure;
import coursierapi.shaded.scala.util.Try;
import coursierapi.shaded.scala.util.control.NonFatal$;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public interface Promise<T>
extends Future<T>,
coursierapi.shaded.scala.concurrent.Promise<T> {
    @Override
    default public Promise<T> future() {
        return this;
    }

    private void completeWithFailure(Promise<?> p, Throwable t) {
        if (NonFatal$.MODULE$.apply(t)) {
            p.complete(new Failure(t));
            return;
        }
        if (t instanceof InterruptedException) {
            if (p.tryComplete(new Failure(new ExecutionException("Boxed InterruptedException", t)))) {
                Thread.currentThread().interrupt();
                return;
            }
            return;
        }
        throw t;
    }

    @Override
    default public <S> Future<S> transform(Function1<Try<T>, Try<S>> f, ExecutionContext executor) {
        DefaultPromise p = new DefaultPromise();
        this.onComplete((Function1<Try, Object> & java.io.Serializable & Serializable)result -> {
            try {
                return p.complete((Try)f.apply((Try)result));
            }
            catch (Throwable t) {
                this.completeWithFailure(p, t);
                return BoxedUnit.UNIT;
            }
        }, executor);
        return p.future();
    }

    @Override
    default public <S> Future<S> transformWith(Function1<Try<T>, Future<S>> f, ExecutionContext executor) {
        DefaultPromise p = new DefaultPromise();
        this.onComplete((Function1<Try, Object> & java.io.Serializable & Serializable)v -> {
            Object object;
            try {
                Future future = (Future)f.apply((Try)v);
                if (future == this) {
                    object = p.complete(v);
                } else if (future instanceof DefaultPromise) {
                    ((DefaultPromise)future).linkRootOf(p);
                    object = BoxedUnit.UNIT;
                } else {
                    object = p.completeWith(future);
                }
            }
            catch (Throwable t) {
                this.completeWithFailure(p, t);
                object = BoxedUnit.UNIT;
            }
            return object;
        }, executor);
        return p.future();
    }

    default public String toString() {
        Option option = this.value();
        if (option instanceof Some) {
            Try result = (Try)((Some)option).value();
            return new StringBuilder(8).append("Future(").append(result).append(")").toString();
        }
        if (None$.MODULE$.equals(option)) {
            return "Future(<not completed>)";
        }
        throw new MatchError(option);
    }

    public static void $init$(Promise $this) {
    }

    private static final class CompletionLatch<T>
    extends AbstractQueuedSynchronizer
    implements Function1<Try<T>, BoxedUnit> {
        @Override
        public boolean apply$mcZI$sp(int v1) {
            return Function1.apply$mcZI$sp$(this, v1);
        }

        @Override
        public double apply$mcDI$sp(int v1) {
            return Function1.apply$mcDI$sp$(this, v1);
        }

        @Override
        public float apply$mcFI$sp(int v1) {
            return Function1.apply$mcFI$sp$(this, v1);
        }

        @Override
        public int apply$mcII$sp(int v1) {
            return Function1.apply$mcII$sp$(this, v1);
        }

        @Override
        public long apply$mcJI$sp(int v1) {
            return Function1.apply$mcJI$sp$(this, v1);
        }

        @Override
        public void apply$mcVI$sp(int v1) {
            Function1.apply$mcVI$sp$(this, v1);
        }

        @Override
        public String toString() {
            return Function1.toString$(this);
        }

        @Override
        public int tryAcquireShared(int ignored) {
            if (this.getState() != 0) {
                return 1;
            }
            return -1;
        }

        @Override
        public boolean tryReleaseShared(int ignore) {
            this.setState(1);
            return true;
        }

        @Override
        public void apply(Try<T> ignored) {
            this.releaseShared(1);
        }
    }

    public static class DefaultPromise<T>
    extends AtomicReference<Object>
    implements Promise<T> {
        @Override
        public Promise<T> future() {
            return ((Promise)this).future();
        }

        @Override
        public <S> Future<S> transform(Function1<Try<T>, Try<S>> f, ExecutionContext executor) {
            return ((Promise)this).transform(f, executor);
        }

        @Override
        public <S> Future<S> transformWith(Function1<Try<T>, Future<S>> f, ExecutionContext executor) {
            return ((Promise)this).transformWith(f, executor);
        }

        @Override
        public String toString() {
            return ((Promise)this).toString();
        }

        @Override
        public <S> Future<S> map(Function1<T, S> f, ExecutionContext executor) {
            return Future.map$(this, f, executor);
        }

        @Override
        public <S> Future<S> flatMap(Function1<T, Future<S>> f, ExecutionContext executor) {
            return Future.flatMap$(this, f, executor);
        }

        @Override
        public <U> Future<U> recover(PartialFunction<Throwable, U> pf, ExecutionContext executor) {
            return Future.recover$(this, pf, executor);
        }

        @Override
        public <U, R> Future<R> zipWith(Future<U> that, Function2<T, U, R> f, ExecutionContext executor) {
            return Future.zipWith$(this, that, f, executor);
        }

        @Override
        public <U> Future<T> andThen(PartialFunction<Try<T>, U> pf, ExecutionContext executor) {
            return Future.andThen$(this, pf, executor);
        }

        @Override
        public coursierapi.shaded.scala.concurrent.Promise<T> complete(Try<T> result) {
            return coursierapi.shaded.scala.concurrent.Promise.complete$(this, result);
        }

        @Override
        public final coursierapi.shaded.scala.concurrent.Promise<T> completeWith(Future<T> other) {
            return coursierapi.shaded.scala.concurrent.Promise.completeWith$(this, other);
        }

        @Override
        public final coursierapi.shaded.scala.concurrent.Promise<T> tryCompleteWith(Future<T> other) {
            return coursierapi.shaded.scala.concurrent.Promise.tryCompleteWith$(this, other);
        }

        private DefaultPromise<T> compressedRoot() {
            Object v = this.get();
            if (v instanceof DefaultPromise) {
                DefaultPromise defaultPromise = (DefaultPromise)v;
                return this.compressedRoot(defaultPromise);
            }
            return this;
        }

        private final DefaultPromise<T> compressedRoot(DefaultPromise<?> linked) {
            while (true) {
                DefaultPromise<?> target;
                if (linked == (target = super.root())) {
                    return target;
                }
                if (this.compareAndSet(linked, target)) {
                    return target;
                }
                Object v = this.get();
                if (!(v instanceof DefaultPromise)) break;
                linked = (DefaultPromise)v;
            }
            return this;
        }

        private DefaultPromise<T> root() {
            Object v;
            while ((v = this_.get()) instanceof DefaultPromise) {
                DefaultPromise this_ = (DefaultPromise)v;
            }
            return this_;
        }

        public final boolean tryAwait(Duration atMost) {
            if (!this.isCompleted()) {
                if (atMost == Duration$.MODULE$.Undefined()) {
                    throw new IllegalArgumentException("cannot wait for Undefined period");
                }
                Duration.Infinite infinite = Duration$.MODULE$.Inf();
                if (!(infinite != null ? !infinite.equals(atMost) : atMost != null)) {
                    CompletionLatch l = new CompletionLatch();
                    this.onComplete(l, Future$InternalCallbackExecutor$.MODULE$);
                    l.acquireSharedInterruptibly(1);
                } else {
                    Duration.Infinite infinite2 = Duration$.MODULE$.MinusInf();
                    if (infinite2 == null ? atMost != null : !infinite2.equals(atMost)) {
                        if (atMost instanceof FiniteDuration) {
                            FiniteDuration finiteDuration = (FiniteDuration)atMost;
                            if (finiteDuration.$greater(Duration$.MODULE$.Zero())) {
                                CompletionLatch l = new CompletionLatch();
                                this.onComplete(l, Future$InternalCallbackExecutor$.MODULE$);
                                l.tryAcquireSharedNanos(1, finiteDuration.toNanos());
                            }
                        } else {
                            throw new MatchError(atMost);
                        }
                    }
                }
                return this.isCompleted();
            }
            return true;
        }

        public final DefaultPromise<T> ready(Duration atMost, CanAwait permit) throws TimeoutException, InterruptedException {
            if (this.tryAwait(atMost)) {
                return this;
            }
            throw new TimeoutException(new StringBuilder(26).append("Futures timed out after [").append(atMost).append("]").toString());
        }

        @Override
        public final T result(Duration atMost, CanAwait permit) throws Exception {
            return this.ready(atMost, permit).value().get().get();
        }

        @Override
        public Option<Try<T>> value() {
            return this.value0();
        }

        private Option<Try<T>> value0() {
            while (true) {
                Object v;
                if ((v = this_.get()) instanceof Try) {
                    Try try_ = (Try)v;
                    return new Some<Try<T>>(try_);
                }
                if (!(v instanceof DefaultPromise)) break;
                DefaultPromise defaultPromise = (DefaultPromise)v;
                DefaultPromise<T> this_ = this_.compressedRoot(defaultPromise);
            }
            return None$.MODULE$;
        }

        @Override
        public final boolean isCompleted() {
            return this.isCompleted0();
        }

        private boolean isCompleted0() {
            while (true) {
                Object v;
                if ((v = this_.get()) instanceof Try) {
                    return true;
                }
                if (!(v instanceof DefaultPromise)) break;
                DefaultPromise defaultPromise = (DefaultPromise)v;
                DefaultPromise<T> this_ = this_.compressedRoot(defaultPromise);
            }
            return false;
        }

        @Override
        public final boolean tryComplete(Try<T> value) {
            Try<T> resolved = Promise$.MODULE$.scala$concurrent$impl$Promise$$resolveTry(value);
            List list = this.tryCompleteAndGetListeners(resolved);
            if (list == null) {
                return false;
            }
            if (list.isEmpty()) {
                return true;
            }
            List foreach_these = list;
            while (!foreach_these.isEmpty()) {
                CallbackRunnable<T> callbackRunnable = foreach_these.head();
                DefaultPromise.$anonfun$tryComplete$1$adapted(resolved, callbackRunnable);
                foreach_these = (List)foreach_these.tail();
            }
            return true;
        }

        private List<CallbackRunnable<T>> tryCompleteAndGetListeners(Try<T> v) {
            while (true) {
                Object v2;
                if ((v2 = this_.get()) instanceof List) {
                    List list = (List)v2;
                    if (!this_.compareAndSet(list, v)) continue;
                    return list;
                }
                if (!(v2 instanceof DefaultPromise)) break;
                DefaultPromise defaultPromise = (DefaultPromise)v2;
                DefaultPromise<T> this_ = this_.compressedRoot(defaultPromise);
            }
            return null;
        }

        @Override
        public final <U> void onComplete(Function1<Try<T>, U> func, ExecutionContext executor) {
            this.dispatchOrAddCallback(new CallbackRunnable(executor.prepare(), func));
        }

        private void dispatchOrAddCallback(CallbackRunnable<T> runnable) {
            block4: {
                Object v;
                while (true) {
                    if ((v = this_.get()) instanceof Try) {
                        Try try_ = (Try)v;
                        runnable.executeWithValue(try_);
                        return;
                    }
                    if (v instanceof DefaultPromise) {
                        DefaultPromise defaultPromise = (DefaultPromise)v;
                        DefaultPromise<T> this_ = this_.compressedRoot(defaultPromise);
                        continue;
                    }
                    if (!(v instanceof List)) break;
                    List list = (List)v;
                    if (!this_.compareAndSet(list, list.$colon$colon(runnable))) {
                        continue;
                    }
                    break block4;
                    break;
                }
                throw new MatchError(v);
            }
        }

        public final void linkRootOf(DefaultPromise<T> target) {
            this.link(super.compressedRoot());
        }

        private void link(DefaultPromise<T> target) {
            while (this_ != target) {
                List list;
                Object v = this_.get();
                if (v instanceof Try) {
                    Try try_ = (Try)v;
                    if (target.tryComplete(try_)) break;
                    throw new IllegalStateException("Cannot link completed promises together");
                }
                if (v instanceof DefaultPromise) {
                    DefaultPromise defaultPromise = (DefaultPromise)v;
                    DefaultPromise<T> this_ = this_.compressedRoot(defaultPromise);
                    continue;
                }
                if (!(v instanceof List) || !this_.compareAndSet(list = (List)v, target)) continue;
                if (!list.nonEmpty()) break;
                List foreach_these = list;
                while (!foreach_these.isEmpty()) {
                    CallbackRunnable callbackRunnable = (CallbackRunnable)foreach_these.head();
                    DefaultPromise.$anonfun$link$1$adapted(target, callbackRunnable);
                    foreach_these = (List)foreach_these.tail();
                }
                break;
            }
        }

        public DefaultPromise() {
            super(Nil$.MODULE$);
            coursierapi.shaded.scala.concurrent.Promise.$init$(this);
            Future.$init$(this);
            Promise.$init$(this);
        }

        public static final /* synthetic */ Object $anonfun$tryComplete$1$adapted(Try resolved$1, CallbackRunnable r) {
            r.executeWithValue(resolved$1);
            return BoxedUnit.UNIT;
        }

        public static final /* synthetic */ Object $anonfun$link$1$adapted(DefaultPromise target$1, CallbackRunnable x$2) {
            target$1.dispatchOrAddCallback(x$2);
            return BoxedUnit.UNIT;
        }
    }
}

