/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.internal.api;

import coursierapi.ArchiveCache;
import coursierapi.Artifact;
import coursierapi.Cache;
import coursierapi.CacheLogger;
import coursierapi.Complete;
import coursierapi.CompleteResult;
import coursierapi.Credentials;
import coursierapi.Dependency;
import coursierapi.DependencyManagement;
import coursierapi.Fetch;
import coursierapi.FetchResult;
import coursierapi.IvyRepository;
import coursierapi.JvmManager;
import coursierapi.Logger;
import coursierapi.MavenRepository;
import coursierapi.Module;
import coursierapi.Publication;
import coursierapi.Repository;
import coursierapi.ResolutionParams;
import coursierapi.SimpleLogger;
import coursierapi.VersionListing;
import coursierapi.VersionsResult;
import coursierapi.error.CoursierError;
import coursierapi.error.DownloadingArtifactsError;
import coursierapi.error.FetchError;
import coursierapi.error.MultipleResolutionError;
import coursierapi.error.ResolutionError;
import coursierapi.error.SimpleResolutionError;
import coursierapi.shaded.coursier.Artifacts;
import coursierapi.shaded.coursier.Artifacts$;
import coursierapi.shaded.coursier.Fetch;
import coursierapi.shaded.coursier.Fetch$;
import coursierapi.shaded.coursier.Fetch$FetchTaskOps$;
import coursierapi.shaded.coursier.Fetch$Result$;
import coursierapi.shaded.coursier.LocalRepositories$;
import coursierapi.shaded.coursier.Repositories$;
import coursierapi.shaded.coursier.Resolve;
import coursierapi.shaded.coursier.Resolve$;
import coursierapi.shaded.coursier.Versions;
import coursierapi.shaded.coursier.Versions$;
import coursierapi.shaded.coursier.cache.ArchiveCache$;
import coursierapi.shaded.coursier.cache.ArtifactError;
import coursierapi.shaded.coursier.cache.CacheDefaults$;
import coursierapi.shaded.coursier.cache.CacheLogger;
import coursierapi.shaded.coursier.cache.CacheLogger$;
import coursierapi.shaded.coursier.cache.FileCache;
import coursierapi.shaded.coursier.cache.FileCache$;
import coursierapi.shaded.coursier.cache.UnArchiver$;
import coursierapi.shaded.coursier.cache.loggers.RefreshLogger$;
import coursierapi.shaded.coursier.complete.Complete$;
import coursierapi.shaded.coursier.core.Authentication;
import coursierapi.shaded.coursier.core.Authentication$;
import coursierapi.shaded.coursier.core.Classifier;
import coursierapi.shaded.coursier.core.Configuration$;
import coursierapi.shaded.coursier.core.DependencyManagement;
import coursierapi.shaded.coursier.core.DependencyManagement$Key$;
import coursierapi.shaded.coursier.core.DependencyManagement$Values$;
import coursierapi.shaded.coursier.core.MinimizedExclusions$;
import coursierapi.shaded.coursier.core.ModuleName;
import coursierapi.shaded.coursier.core.Organization;
import coursierapi.shaded.coursier.core.Publication$;
import coursierapi.shaded.coursier.core.Type;
import coursierapi.shaded.coursier.core.Version$;
import coursierapi.shaded.coursier.core.Versions;
import coursierapi.shaded.coursier.error.FetchError;
import coursierapi.shaded.coursier.error.ResolutionError;
import coursierapi.shaded.coursier.internal.api.ApiHelper;
import coursierapi.shaded.coursier.internal.api.ApiHelper$;
import coursierapi.shaded.coursier.internal.api.WrappedLogger;
import coursierapi.shaded.coursier.ivy.IvyRepository$;
import coursierapi.shaded.coursier.ivy.Pattern;
import coursierapi.shaded.coursier.jvm.JavaHome;
import coursierapi.shaded.coursier.jvm.JavaHome$;
import coursierapi.shaded.coursier.jvm.JvmCache;
import coursierapi.shaded.coursier.jvm.JvmCache$;
import coursierapi.shaded.coursier.package$;
import coursierapi.shaded.coursier.package$Dependency$;
import coursierapi.shaded.coursier.package$Module$;
import coursierapi.shaded.coursier.params.ResolutionParams$;
import coursierapi.shaded.coursier.parse.DependencyParser$;
import coursierapi.shaded.coursier.parse.ModuleParser$;
import coursierapi.shaded.coursier.util.Artifact$;
import coursierapi.shaded.coursier.util.Task;
import coursierapi.shaded.coursier.util.Task$;
import coursierapi.shaded.scala.$less$colon$less$;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.Predef$ArrowAssoc$;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.IterableOnce;
import coursierapi.shaded.scala.collection.IterableOnceOps;
import coursierapi.shaded.scala.collection.IterableOps;
import coursierapi.shaded.scala.collection.JavaConverters$;
import coursierapi.shaded.scala.collection.Map;
import coursierapi.shaded.scala.collection.MapOps;
import coursierapi.shaded.scala.collection.Seq;
import coursierapi.shaded.scala.collection.Set;
import coursierapi.shaded.scala.collection.StringOps$;
import coursierapi.shaded.scala.collection.immutable.Nil$;
import coursierapi.shaded.scala.collection.immutable.Vector;
import coursierapi.shaded.scala.concurrent.ExecutionContext;
import coursierapi.shaded.scala.reflect.ClassTag$;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.util.Either;
import coursierapi.shaded.scala.util.Left;
import coursierapi.shaded.scala.util.Right;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public final class ApiHelper$ {
    public static final ApiHelper$ MODULE$ = new ApiHelper$();

    public Repository[] defaultRepositories() {
        return (Repository[])((IterableOnceOps)Resolve$.MODULE$.defaultRepositories().map((Function1<coursierapi.shaded.coursier.core.Repository, Repository> & Serializable)x$1 -> MODULE$.repository((coursierapi.shaded.coursier.core.Repository)x$1))).toArray(ClassTag$.MODULE$.apply(Repository.class));
    }

    public IvyRepository ivy2Local() {
        IvyRepository repo = IvyRepository.of(LocalRepositories$.MODULE$.ivy2Local().pattern().string(), (String)LocalRepositories$.MODULE$.ivy2Local().metadataPatternOpt().map((Function1<Pattern, String> & Serializable)x$2 -> x$2.string()).orNull($less$colon$less$.MODULE$.refl()));
        return repo.withDropInfoAttributes(LocalRepositories$.MODULE$.ivy2Local().dropInfoAttributes());
    }

    public MavenRepository central() {
        return MavenRepository.of(Repositories$.MODULE$.central().root());
    }

    public ExecutorService defaultPool() {
        return CacheDefaults$.MODULE$.pool();
    }

    public File defaultLocation() {
        return CacheDefaults$.MODULE$.location();
    }

    public File defaultArchiveCacheLocation() {
        return CacheDefaults$.MODULE$.archiveCacheLocation();
    }

    public Logger progressBarLogger(OutputStreamWriter writer) {
        return WrappedLogger.of(RefreshLogger$.MODULE$.create(writer));
    }

    public Logger nopLogger() {
        return WrappedLogger.of(CacheLogger$.MODULE$.nop());
    }

    public Module parseModule(String s, String scalaVersion) {
        Either<String, coursierapi.shaded.coursier.core.Module> either = ModuleParser$.MODULE$.module(s, scalaVersion);
        if (either instanceof Left) {
            Left left = (Left)either;
            String err = (String)left.value();
            throw new IllegalArgumentException(err);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            coursierapi.shaded.coursier.core.Module m = (coursierapi.shaded.coursier.core.Module)right.value();
            return this.module(m);
        }
        throw new MatchError(either);
    }

    public Dependency parseDependency(String s, String scalaVersion) {
        Either<String, coursierapi.shaded.coursier.core.Dependency> either = DependencyParser$.MODULE$.dependency(s, scalaVersion, Configuration$.MODULE$.empty());
        if (either instanceof Left) {
            Left left = (Left)either;
            String err = (String)left.value();
            throw new IllegalArgumentException(err);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            coursierapi.shaded.coursier.core.Dependency dep = (coursierapi.shaded.coursier.core.Dependency)right.value();
            return this.dependency(dep);
        }
        throw new MatchError(either);
    }

    private Option<Authentication> authenticationOpt(Credentials credentials) {
        if (credentials == null) {
            return None$.MODULE$;
        }
        return new Some<Authentication>(Authentication$.MODULE$.apply(credentials.getUser(), credentials.getPassword()));
    }

    private coursierapi.shaded.coursier.ivy.IvyRepository ivyRepository(IvyRepository ivy) {
        boolean x$10;
        boolean x$9;
        boolean x$8;
        boolean x$7;
        coursierapi.shaded.scala.collection.immutable.Map<String, String> x$6;
        String x$1 = ivy.getPattern();
        Option<String> x$2 = Option$.MODULE$.apply(ivy.getMetadataPattern()).filter((Function1<String, Object> & Serializable)x$3 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$3))));
        Option<Authentication> x$32 = this.authenticationOpt(ivy.getCredentials());
        boolean x$4 = ivy.getDropInfoAttributes();
        Option<Object> x$5 = IvyRepository$.MODULE$.parse$default$3();
        Either<String, coursierapi.shaded.coursier.ivy.IvyRepository> either = IvyRepository$.MODULE$.parse(x$1, x$2, x$5, x$6 = IvyRepository$.MODULE$.parse$default$4(), x$7 = IvyRepository$.MODULE$.parse$default$5(), x$8 = IvyRepository$.MODULE$.parse$default$6(), x$9 = IvyRepository$.MODULE$.parse$default$7(), x$4, x$32, x$10 = IvyRepository$.MODULE$.parse$default$10());
        if (either instanceof Left) {
            Left left = (Left)either;
            String err = (String)left.value();
            throw new Exception(new StringBuilder(25).append("Invalid Ivy repository ").append(ivy).append(": ").append(err).toString());
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            coursierapi.shaded.coursier.ivy.IvyRepository repo = (coursierapi.shaded.coursier.ivy.IvyRepository)right.value();
            return repo;
        }
        throw new MatchError(either);
    }

    public coursierapi.shaded.coursier.core.Module module(Module mod) {
        return package$Module$.MODULE$.apply(mod.getOrganization(), mod.getName(), ((IterableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(mod.getAttributes()).asScala()).iterator().toMap($less$colon$less$.MODULE$.refl()));
    }

    public Module module(coursierapi.shaded.coursier.core.Module mod) {
        return Module.of(mod.organization(), mod.name(), JavaConverters$.MODULE$.mapAsJavaMapConverter(mod.attributes()).asJava());
    }

    public DependencyManagement.Key depMgmtKey(DependencyManagement.Key key) {
        return DependencyManagement$Key$.MODULE$.apply(key.getOrganization(), key.getName(), key.getType(), key.getClassifier());
    }

    public DependencyManagement.Key depMgmtKey(DependencyManagement.Key key) {
        return new DependencyManagement.Key(key.organization(), key.name(), key.type(), key.classifier());
    }

    public DependencyManagement.Values depMgmtValues(DependencyManagement.Values values) {
        return DependencyManagement$Values$.MODULE$.apply(values.getConfiguration(), values.getVersion(), MinimizedExclusions$.MODULE$.apply(((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaSetConverter(values.getExclusions()).asScala()).map((Function1<Map.Entry, Tuple2> & Serializable)e -> new Tuple2<Organization, ModuleName>(new Organization((String)e.getKey()), new ModuleName((String)e.getValue())))).toSet()), values.isOptional());
    }

    public DependencyManagement.Values depMgmtValues(DependencyManagement.Values values) {
        DependencyManagement.Values apiValues = new DependencyManagement.Values(values.config(), values.version(), values.optional());
        return apiValues.withExclusions(JavaConverters$.MODULE$.setAsJavaSetConverter(((IterableOnceOps)values.minimizedExclusions().toSeq().map((Function1<Tuple2, Map.Entry> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String org = ((Organization)tuple2._1()).value();
                String name = ((ModuleName)tuple2._2()).value();
                return new AbstractMap.SimpleImmutableEntry<String, String>(org, name);
            }
            throw new MatchError(tuple2);
        })).toSet()).asJava());
    }

    public coursierapi.shaded.coursier.core.Dependency dependency(Dependency dep) {
        coursierapi.shaded.coursier.core.Module module0 = this.module(dep.getModule());
        coursierapi.shaded.scala.collection.immutable.Set<Tuple2<Organization, ModuleName>> exclusions = JavaConverters$.MODULE$.asScalaIteratorConverter(dep.getExclusions().iterator()).asScala().map((Function1<Map.Entry, Tuple2> & Serializable)e -> new Tuple2<Organization, ModuleName>(new Organization((String)e.getKey()), new ModuleName((String)e.getValue()))).toSet();
        String configuration = dep.getConfiguration();
        coursierapi.shaded.coursier.core.Dependency dep0 = package$Dependency$.MODULE$.apply(module0, dep.getVersion()).withExclusions(exclusions).withConfiguration(configuration).withTransitive(dep.isTransitive()).withOverrides(((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(dep.getOverrides()).asScala()).map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                DependencyManagement.Key key = (DependencyManagement.Key)tuple2._1();
                DependencyManagement.Values values = (DependencyManagement.Values)tuple2._2();
                return new Tuple2<DependencyManagement.Key, DependencyManagement.Values>(MODULE$.depMgmtKey(key), MODULE$.depMgmtValues(values));
            }
            throw new MatchError(tuple2);
        }).toMap($less$colon$less$.MODULE$.refl()));
        return (coursierapi.shaded.coursier.core.Dependency)Option$.MODULE$.apply(dep.getPublication()).map((Function1<Publication, coursierapi.shaded.coursier.core.Dependency> & Serializable)p -> {
            coursierapi.shaded.coursier.core.Publication p0 = Publication$.MODULE$.apply(p.getName(), p.getType(), p.getExtension(), p.getClassifier());
            return dep0.withPublication(p0);
        }).getOrElse((Function0<coursierapi.shaded.coursier.core.Dependency> & Serializable)() -> dep0);
    }

    public Dependency dependency(coursierapi.shaded.coursier.core.Dependency dep) {
        return Dependency.of(this.module(dep.module()), dep.version()).withConfiguration(dep.configuration()).withType(dep.attributes().type()).withClassifier(dep.attributes().classifier()).withExclusion(JavaConverters$.MODULE$.setAsJavaSetConverter((Set)dep.exclusions().map((Function1<Tuple2, Map.Entry> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String o = ((Organization)tuple2._1()).value();
                String n = ((ModuleName)tuple2._2()).value();
                return new AbstractMap.SimpleImmutableEntry<String, String>(o, n);
            }
            throw new MatchError(tuple2);
        })).asJava()).withTransitive(dep.transitive()).withOverrides(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)dep.overrides().map((Function1<Tuple2, Tuple2> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                DependencyManagement.Key key = (DependencyManagement.Key)tuple2._1();
                DependencyManagement.Values values = (DependencyManagement.Values)tuple2._2();
                return new Tuple2<DependencyManagement.Key, DependencyManagement.Values>(MODULE$.depMgmtKey(key), MODULE$.depMgmtValues(values));
            }
            throw new MatchError(tuple2);
        })).asJava());
    }

    public coursierapi.shaded.coursier.core.Repository repository(Repository repo) {
        Repository repository = repo;
        if (repository instanceof ApiHelper.ApiRepo) {
            ApiHelper.ApiRepo apiRepo = (ApiHelper.ApiRepo)repository;
            coursierapi.shaded.coursier.core.Repository repo0 = apiRepo.repo();
            return repo0;
        }
        if (repository instanceof MavenRepository) {
            MavenRepository mavenRepository = (MavenRepository)repository;
            return package$.MODULE$.MavenRepository().apply(mavenRepository.getBase(), this.authenticationOpt(mavenRepository.getCredentials()));
        }
        if (repository instanceof IvyRepository) {
            IvyRepository ivyRepository = (IvyRepository)repository;
            return this.ivyRepository(ivyRepository);
        }
        throw new Exception(new StringBuilder(25).append("Unrecognized repository: ").append(repository).toString());
    }

    public Credentials credentials(Authentication auth) {
        return Credentials.of(auth.user(), (String)auth.passwordOpt().getOrElse((Function0<String> & Serializable)() -> ""));
    }

    public Authentication credentials(Credentials credentials) {
        return Authentication$.MODULE$.apply(credentials.getUser(), credentials.getPassword());
    }

    public Repository repository(coursierapi.shaded.coursier.core.Repository repo) {
        coursierapi.shaded.coursier.core.Repository repository = repo;
        if (repository instanceof coursierapi.shaded.coursier.maven.MavenRepository) {
            coursierapi.shaded.coursier.maven.MavenRepository mavenRepository = (coursierapi.shaded.coursier.maven.MavenRepository)repository;
            Option credentialsOpt = mavenRepository.authentication().map((Function1<Authentication, Credentials> & Serializable)auth -> MODULE$.credentials((Authentication)auth));
            return MavenRepository.of(mavenRepository.root()).withCredentials((Credentials)credentialsOpt.orNull($less$colon$less$.MODULE$.refl()));
        }
        if (repository instanceof coursierapi.shaded.coursier.ivy.IvyRepository) {
            coursierapi.shaded.coursier.ivy.IvyRepository ivyRepository = (coursierapi.shaded.coursier.ivy.IvyRepository)repository;
            Option credentialsOpt = ivyRepository.authentication().map((Function1<Authentication, Credentials> & Serializable)auth -> MODULE$.credentials((Authentication)auth));
            Option mdPatternOpt = ivyRepository.metadataPatternOpt().map((Function1<Pattern, String> & Serializable)x$4 -> x$4.string());
            return IvyRepository.of(ivyRepository.pattern().string()).withMetadataPattern((String)mdPatternOpt.orNull($less$colon$less$.MODULE$.refl())).withCredentials((Credentials)credentialsOpt.orNull($less$colon$less$.MODULE$.refl()));
        }
        return new ApiHelper.ApiRepo(repository);
    }

    public coursierapi.shaded.coursier.params.ResolutionParams resolutionParams(ResolutionParams params) {
        coursierapi.shaded.coursier.params.ResolutionParams params0;
        block0: {
            params0 = ResolutionParams$.MODULE$.apply();
            if (params.getMaxIterations() == null) break block0;
            params0 = params0.withMaxIterations(Predef$.MODULE$.Integer2int(params.getMaxIterations()));
        }
        return params0.withForceVersion((coursierapi.shaded.scala.collection.immutable.Map)((IterableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(params.getForceVersions()).asScala()).iterator().toMap($less$colon$less$.MODULE$.refl()).map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Module m = (Module)tuple2._1();
                String v = (String)tuple2._2();
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.module(m)), v);
            }
            throw new MatchError(tuple2);
        })).withForcedProperties(((IterableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(params.getForcedProperties()).asScala()).iterator().toMap($less$colon$less$.MODULE$.refl())).withProfiles(((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(params.getProfiles()).asScala()).toSet()).withExclusions(((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaSetConverter(params.getExclusions()).asScala()).map((Function1<Map.Entry, Tuple2> & Serializable)e -> new Tuple2<Organization, ModuleName>(new Organization((String)e.getKey()), new ModuleName((String)e.getValue())))).toSet()).withUseSystemOsInfo(params.getUseSystemOsInfo()).withUseSystemJdkVersion(params.getUseSystemJdkVersion()).withScalaVersionOpt(Option$.MODULE$.apply(params.getScalaVersion())).withKeepProvidedDependencies(Option$.MODULE$.apply(params.getKeepProvidedDependencies()).map((Function1<Boolean, Object> & Serializable)b -> BoxesRunTime.boxToBoolean(Predef$.MODULE$.Boolean2boolean(b)))).withForceDepMgmtVersions(Option$.MODULE$.apply(params.getForceDepMgmtVersions()).map((Function1<Boolean, Object> & Serializable)b -> BoxesRunTime.boxToBoolean(Predef$.MODULE$.Boolean2boolean(b)))).withEnableDependencyOverrides(Option$.MODULE$.apply(params.getEnableDependencyOverrides()).map((Function1<Boolean, Object> & Serializable)b -> BoxesRunTime.boxToBoolean(Predef$.MODULE$.Boolean2boolean(b))));
    }

    public FileCache<Task> cache(Cache cache) {
        Option loggerOpt = Option$.MODULE$.apply(cache.getLogger()).map((Function1<Logger, coursierapi.shaded.coursier.cache.CacheLogger> & Serializable)x0$1 -> {
            Logger logger = x0$1;
            if (logger instanceof SimpleLogger) {
                SimpleLogger simpleLogger = (SimpleLogger)logger;
                return new coursierapi.shaded.coursier.cache.CacheLogger(simpleLogger){
                    private final SimpleLogger x2$1;

                    public void foundLocally(String url) {
                        coursierapi.shaded.coursier.cache.CacheLogger.foundLocally$(this, url);
                    }

                    public void checkingArtifact(String url, coursierapi.shaded.coursier.util.Artifact artifact) {
                        coursierapi.shaded.coursier.cache.CacheLogger.checkingArtifact$(this, url, artifact);
                    }

                    public void downloadingArtifact(String url, coursierapi.shaded.coursier.util.Artifact artifact) {
                        coursierapi.shaded.coursier.cache.CacheLogger.downloadingArtifact$(this, url, artifact);
                    }

                    public void checkingUpdates(String url, Option<Object> currentTimeOpt) {
                        coursierapi.shaded.coursier.cache.CacheLogger.checkingUpdates$(this, url, currentTimeOpt);
                    }

                    public void checkingUpdatesResult(String url, Option<Object> currentTimeOpt, Option<Object> remoteTimeOpt) {
                        coursierapi.shaded.coursier.cache.CacheLogger.checkingUpdatesResult$(this, url, currentTimeOpt, remoteTimeOpt);
                    }

                    public void gettingLength(String url) {
                        coursierapi.shaded.coursier.cache.CacheLogger.gettingLength$(this, url);
                    }

                    public void gettingLengthResult(String url, Option<Object> length) {
                        coursierapi.shaded.coursier.cache.CacheLogger.gettingLengthResult$(this, url, length);
                    }

                    public void removedCorruptFile(String url, Option<String> reason) {
                        coursierapi.shaded.coursier.cache.CacheLogger.removedCorruptFile$(this, url, reason);
                    }

                    public void pickedModuleVersion(String module, String version) {
                        coursierapi.shaded.coursier.cache.CacheLogger.pickedModuleVersion$(this, module, version);
                    }

                    public void init(Option<Object> sizeHint) {
                        coursierapi.shaded.coursier.cache.CacheLogger.init$(this, sizeHint);
                    }

                    public Option<Object> init$default$1() {
                        return coursierapi.shaded.coursier.cache.CacheLogger.init$default$1$(this);
                    }

                    public void stop() {
                        coursierapi.shaded.coursier.cache.CacheLogger.stop$(this);
                    }

                    public final <T> T use(Function0<T> f) {
                        return (T)coursierapi.shaded.coursier.cache.CacheLogger.use$(this, f);
                    }

                    public final <T> CacheLogger.Using<T> using() {
                        return coursierapi.shaded.coursier.cache.CacheLogger.using$(this);
                    }

                    public void downloadingArtifact(String url) {
                        this.x2$1.starting(url);
                    }

                    public void downloadLength(String url, long totalLength, long alreadyDownloaded, boolean watching) {
                        this.x2$1.length(url, totalLength, alreadyDownloaded, watching);
                    }

                    public void downloadProgress(String url, long downloaded) {
                        this.x2$1.progress(url, downloaded);
                    }

                    public void downloadedArtifact(String url, boolean success) {
                        this.x2$1.done(url, success);
                    }
                    {
                        this.x2$1 = x2$1;
                        coursierapi.shaded.coursier.cache.CacheLogger.$init$(this);
                    }
                };
            }
            if (logger instanceof WrappedLogger) {
                WrappedLogger wrappedLogger = (WrappedLogger)logger;
                return wrappedLogger.getLogger();
            }
            if (logger instanceof CacheLogger) {
                CacheLogger cacheLogger = (CacheLogger)logger;
                return new coursierapi.shaded.coursier.cache.CacheLogger(cacheLogger){
                    private final CacheLogger x4$1;

                    public void downloadingArtifact(String url) {
                        coursierapi.shaded.coursier.cache.CacheLogger.downloadingArtifact$(this, url);
                    }

                    public Option<Object> init$default$1() {
                        return coursierapi.shaded.coursier.cache.CacheLogger.init$default$1$(this);
                    }

                    public final <T> T use(Function0<T> f) {
                        return (T)coursierapi.shaded.coursier.cache.CacheLogger.use$(this, f);
                    }

                    public final <T> CacheLogger.Using<T> using() {
                        return coursierapi.shaded.coursier.cache.CacheLogger.using$(this);
                    }

                    public void downloadingArtifact(String url, coursierapi.shaded.coursier.util.Artifact artifact) {
                        this.x4$1.downloadingArtifact(url, ApiHelper$.MODULE$.coursier$internal$api$ApiHelper$$artifact(artifact));
                    }

                    public void foundLocally(String url) {
                        this.x4$1.foundLocally(url);
                    }

                    public void gettingLength(String url) {
                        this.x4$1.gettingLength(url);
                    }

                    public void init(Option<Object> sizeHint) {
                        this.x4$1.init((Integer)sizeHint.map((Function1<Object, Integer> & Serializable)x -> anon.2.$anonfun$init$1(BoxesRunTime.unboxToInt(x))).orNull($less$colon$less$.MODULE$.refl()));
                    }

                    public void stop() {
                        this.x4$1.stop();
                    }

                    public void checkingArtifact(String url, coursierapi.shaded.coursier.util.Artifact artifact) {
                        this.x4$1.checkingArtifact(url, ApiHelper$.MODULE$.coursier$internal$api$ApiHelper$$artifact(artifact));
                    }

                    public void checkingUpdates(String url, Option<Object> currentTimeOpt) {
                        this.x4$1.checkingUpdates(url, (Long)currentTimeOpt.map((Function1<Object, Long> & Serializable)x -> anon.2.$anonfun$checkingUpdates$1(BoxesRunTime.unboxToLong(x))).orNull($less$colon$less$.MODULE$.refl()));
                    }

                    public void checkingUpdatesResult(String url, Option<Object> currentTimeOpt, Option<Object> remoteTimeOpt) {
                        this.x4$1.checkingUpdatesResult(url, (Long)currentTimeOpt.map((Function1<Object, Long> & Serializable)x -> anon.2.$anonfun$checkingUpdatesResult$1(BoxesRunTime.unboxToLong(x))).orNull($less$colon$less$.MODULE$.refl()), (Long)remoteTimeOpt.map((Function1<Object, Long> & Serializable)x -> anon.2.$anonfun$checkingUpdatesResult$2(BoxesRunTime.unboxToLong(x))).orNull($less$colon$less$.MODULE$.refl()));
                    }

                    public void downloadedArtifact(String url, boolean success) {
                        this.x4$1.downloadedArtifact(url, success);
                    }

                    public void downloadLength(String url, long totalLength, long alreadyDownloaded, boolean watching) {
                        this.x4$1.downloadLength(url, totalLength, alreadyDownloaded, watching);
                    }

                    public void downloadProgress(String url, long downloaded) {
                        this.x4$1.downloadProgress(url, downloaded);
                    }

                    public void gettingLengthResult(String url, Option<Object> length) {
                        this.x4$1.gettingLengthResult(url, (Long)length.map((Function1<Object, Long> & Serializable)x -> anon.2.$anonfun$gettingLengthResult$1(BoxesRunTime.unboxToLong(x))).orNull($less$colon$less$.MODULE$.refl()));
                    }

                    public void pickedModuleVersion(String module, String version) {
                        this.x4$1.pickedModuleVersion(module, version);
                    }

                    public void removedCorruptFile(String url, Option<String> reason) {
                        this.x4$1.removedCorruptFile(url, (String)reason.orNull($less$colon$less$.MODULE$.refl()));
                    }

                    public static final /* synthetic */ Integer $anonfun$init$1(int x) {
                        return Predef$.MODULE$.int2Integer(x);
                    }

                    public static final /* synthetic */ Long $anonfun$checkingUpdates$1(long x) {
                        return Predef$.MODULE$.long2Long(x);
                    }

                    public static final /* synthetic */ Long $anonfun$checkingUpdatesResult$1(long x) {
                        return Predef$.MODULE$.long2Long(x);
                    }

                    public static final /* synthetic */ Long $anonfun$checkingUpdatesResult$2(long x) {
                        return Predef$.MODULE$.long2Long(x);
                    }

                    public static final /* synthetic */ Long $anonfun$gettingLengthResult$1(long x) {
                        return Predef$.MODULE$.long2Long(x);
                    }
                    {
                        this.x4$1 = x4$1;
                        coursierapi.shaded.coursier.cache.CacheLogger.$init$(this);
                    }
                };
            }
            throw new MatchError(logger);
        });
        return FileCache$.MODULE$.apply(FileCache$.MODULE$.apply$default$1()).withPool(cache.getPool()).withLocation(cache.getLocation()).withLogger((coursierapi.shaded.coursier.cache.CacheLogger)loggerOpt.getOrElse((Function0<coursierapi.shaded.coursier.cache.CacheLogger> & Serializable)() -> CacheLogger$.MODULE$.nop()));
    }

    public coursierapi.shaded.coursier.Fetch<Task> fetch(Fetch fetch) {
        Artifacts<Task> artifacts2;
        Resolve<Task> resolve;
        block0: {
            Vector<coursierapi.shaded.coursier.core.Dependency> dependencies = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(fetch.getDependencies()).asScala()).map((Function1<Dependency, coursierapi.shaded.coursier.core.Dependency> & Serializable)dep -> MODULE$.dependency((Dependency)dep))).toVector();
            Vector<coursierapi.shaded.coursier.core.Dependency> bomDependencies = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(fetch.getBomDependencies()).asScala()).map((Function1<Dependency, coursierapi.shaded.coursier.core.Dependency> & Serializable)dep -> MODULE$.dependency((Dependency)dep))).toVector();
            Vector<coursierapi.shaded.coursier.core.Repository> repositories = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(fetch.getRepositories()).asScala()).map((Function1<Repository, coursierapi.shaded.coursier.core.Repository> & Serializable)repo -> MODULE$.repository((Repository)repo))).toVector();
            FileCache<Task> cache0 = this.cache(fetch.getCache());
            coursierapi.shaded.scala.collection.immutable.Set classifiers = (coursierapi.shaded.scala.collection.immutable.Set)((IterableOnce)JavaConverters$.MODULE$.asScalaSetConverter(fetch.getClassifiers()).asScala()).iterator().toSet().map((Function1<String, Object> & Serializable)x$5 -> new Classifier(x$5));
            coursierapi.shaded.coursier.params.ResolutionParams params = this.resolutionParams(fetch.getResolutionParams());
            resolve = Resolve$.MODULE$.apply().withDependencies(dependencies).withBomDependencies(bomDependencies).withRepositories(repositories).withCache(cache0).withResolutionParams(params);
            artifacts2 = Artifacts$.MODULE$.apply().withMainArtifacts(fetch.getMainArtifacts()).withClassifiers(classifiers);
            if (fetch.getArtifactTypes() == null) break block0;
            artifacts2 = artifacts2.withArtifactTypes((coursierapi.shaded.scala.collection.immutable.Set)((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(fetch.getArtifactTypes()).asScala()).toSet().map((Function1<String, Object> & Serializable)x$6 -> new Type(x$6)));
        }
        return Fetch$.MODULE$.apply(resolve, artifacts2, None$.MODULE$).withFetchCache(Option$.MODULE$.apply(fetch.getFetchCacheIKnowWhatImDoing()));
    }

    private SimpleResolutionError simpleResError(ResolutionError.Simple err) {
        ResolutionError.Simple simple = err;
        if (simple != null) {
            ResolutionError.Simple simple2 = simple;
            return SimpleResolutionError.of(simple2.getMessage());
        }
        throw new MatchError((Object)simple);
    }

    public Artifact coursier$internal$api$ApiHelper$$artifact(coursierapi.shaded.coursier.util.Artifact artifact) {
        Credentials credentials0 = (Credentials)artifact.authentication().map((Function1<Authentication, Credentials> & Serializable)auth -> MODULE$.credentials((Authentication)auth)).orNull($less$colon$less$.MODULE$.refl());
        return Artifact.of(artifact.url(), artifact.changing(), artifact.optional(), credentials0);
    }

    private coursierapi.shaded.coursier.util.Artifact artifact(Artifact artifact) {
        return Artifact$.MODULE$.apply(artifact.getUrl()).withChanging(artifact.isChanging()).withOptional(artifact.isOptional()).withAuthentication(Option$.MODULE$.apply(artifact.getCredentials()).map((Function1<Credentials, Authentication> & Serializable)credentials -> MODULE$.credentials((Credentials)credentials)));
    }

    public FetchResult doFetch(Fetch apiFetch) {
        Either<coursierapi.shaded.coursier.error.CoursierError, Fetch.Result> either;
        Either<coursierapi.shaded.coursier.error.CoursierError, Fetch.Result> either2;
        coursierapi.shaded.coursier.Fetch<Task> fetch0 = this.fetch(apiFetch);
        if (apiFetch.getFetchCacheIKnowWhatImDoing() == null) {
            coursierapi.shaded.coursier.Fetch<Task> qual$1 = Fetch$.MODULE$.FetchTaskOps(fetch0);
            ExecutionContext x$12 = Fetch$FetchTaskOps$.MODULE$.eitherResult$default$1$extension(qual$1);
            either2 = Fetch$FetchTaskOps$.MODULE$.eitherResult$extension(qual$1, x$12);
        } else {
            coursierapi.shaded.coursier.util.Artifact dummyArtifact = Artifact$.MODULE$.apply("", (coursierapi.shaded.scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((coursierapi.shaded.scala.collection.immutable.Seq)Nil$.MODULE$), (coursierapi.shaded.scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((coursierapi.shaded.scala.collection.immutable.Seq)Nil$.MODULE$), false, false, None$.MODULE$);
            coursierapi.shaded.coursier.Fetch<Task> qual$2 = Fetch$.MODULE$.FetchTaskOps(fetch0);
            ExecutionContext x$2 = Fetch$FetchTaskOps$.MODULE$.either$default$1$extension(qual$2);
            either2 = Fetch$FetchTaskOps$.MODULE$.either$extension(qual$2, x$2).map((Function1<coursierapi.shaded.scala.collection.immutable.Seq, Fetch.Result> & Serializable)files -> Fetch$Result$.MODULE$.apply().withExtraArtifacts((coursierapi.shaded.scala.collection.immutable.Seq)files.map((Function1<File, Tuple2> & Serializable)x$9 -> new Tuple2<coursierapi.shaded.coursier.util.Artifact, File>(dummyArtifact, (File)x$9))));
        }
        Either<coursierapi.shaded.coursier.error.CoursierError, Fetch.Result> either3 = either = either2;
        if (either3 instanceof Left) {
            CoursierError coursierError;
            Left left = (Left)either3;
            coursierapi.shaded.coursier.error.CoursierError err2 = (coursierapi.shaded.coursier.error.CoursierError)left.value();
            coursierapi.shaded.coursier.error.CoursierError coursierError2 = err2;
            if (coursierError2 instanceof FetchError.DownloadingArtifacts) {
                FetchError.DownloadingArtifacts downloadingArtifacts = (FetchError.DownloadingArtifacts)coursierError2;
                coursierError = DownloadingArtifactsError.of(JavaConverters$.MODULE$.mapAsJavaMapConverter(((IterableOnceOps)downloadingArtifacts.errors().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        coursierapi.shaded.coursier.util.Artifact a = (coursierapi.shaded.coursier.util.Artifact)tuple2._1();
                        ArtifactError e = (ArtifactError)tuple2._2();
                        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(a.url()), e.describe());
                    }
                    throw new MatchError(tuple2);
                })).toMap($less$colon$less$.MODULE$.refl())).asJava());
            } else if (coursierError2 instanceof coursierapi.shaded.coursier.error.FetchError) {
                coursierapi.shaded.coursier.error.FetchError fetchError = (coursierapi.shaded.coursier.error.FetchError)coursierError2;
                coursierError = FetchError.of(fetchError.getMessage());
            } else if (coursierError2 instanceof ResolutionError.Several) {
                ResolutionError.Several several = (ResolutionError.Several)coursierError2;
                coursierError = MultipleResolutionError.of(this.simpleResError(several.head()), (SimpleResolutionError[])((IterableOnceOps)several.tail().map((Function1<ResolutionError.Simple, SimpleResolutionError> & Serializable)err -> MODULE$.simpleResError((ResolutionError.Simple)err))).toArray(ClassTag$.MODULE$.apply(SimpleResolutionError.class)));
            } else if (coursierError2 instanceof ResolutionError.Simple) {
                ResolutionError.Simple simple = (ResolutionError.Simple)coursierError2;
                coursierError = this.simpleResError(simple);
            } else if (coursierError2 instanceof coursierapi.shaded.coursier.error.ResolutionError) {
                coursierapi.shaded.coursier.error.ResolutionError resolutionError = (coursierapi.shaded.coursier.error.ResolutionError)coursierError2;
                coursierError = ResolutionError.of(resolutionError.getMessage());
            } else if (coursierError2 != null) {
                coursierapi.shaded.coursier.error.CoursierError coursierError3 = coursierError2;
                coursierError = CoursierError.of(coursierError3.getMessage());
            } else {
                throw new MatchError((Object)coursierError2);
            }
            FetchError ex = coursierError;
            throw ex;
        }
        if (either3 instanceof Right) {
            Right right = (Right)either3;
            Fetch.Result result = (Fetch.Result)right.value();
            ArrayList<Map.Entry<Artifact, File>> artifactFiles = new ArrayList<Map.Entry<Artifact, File>>();
            result.artifacts().withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(ApiHelper$.$anonfun$doFetch$5(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$10 -> BoxesRunTime.boxToBoolean(ApiHelper$.$anonfun$doFetch$6(artifactFiles, x$10)));
            ArrayList<Dependency> deps = new ArrayList<Dependency>();
            ((IterableOnceOps)result.resolution().orderedDependencies().map((Function1<coursierapi.shaded.coursier.core.Dependency, Dependency> & Serializable)dep -> MODULE$.dependency((coursierapi.shaded.coursier.core.Dependency)dep))).foreach((Function1<Dependency, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(deps.add(x$1)));
            return FetchResult.of(artifactFiles, deps);
        }
        throw new MatchError(either3);
    }

    public CompleteResult doComplete(Complete complete) {
        FileCache<Task> cache0 = this.cache(complete.getCache());
        Vector<coursierapi.shaded.coursier.core.Repository> repositories = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(complete.getRepositories()).asScala()).map((Function1<Repository, coursierapi.shaded.coursier.core.Repository> & Serializable)repo -> MODULE$.repository((Repository)repo))).toVector();
        Option<String> binVersionOpt = Option$.MODULE$.apply(complete.getScalaBinaryVersion());
        Tuple2 res = (Tuple2)Task$.MODULE$.PlatformTaskOps(Complete$.MODULE$.apply(cache0, Task$.MODULE$.sync()).withRepositories(repositories).withScalaBinaryVersionOpt(binVersionOpt).withScalaVersionOpt(Option$.MODULE$.apply(complete.getScalaVersion()), binVersionOpt.isEmpty()).withInput(complete.getInput()).complete().value()).unsafeRun(cache0.ec());
        return CompleteResult.of(res._1$mcI$sp(), JavaConverters$.MODULE$.seqAsJavaList((Seq)res._2()));
    }

    public VersionListing versionListing(coursierapi.shaded.coursier.core.Versions versions2) {
        return VersionListing.of(versions2.latest(), versions2.release(), JavaConverters$.MODULE$.seqAsJavaList(versions2.available()), (LocalDateTime)versions2.lastUpdated().map((Function1<Versions.DateTime, LocalDateTime> & Serializable)dt -> LocalDateTime.of(dt.year(), dt.month(), dt.day(), dt.hour(), dt.minute(), dt.second())).orNull($less$colon$less$.MODULE$.refl()));
    }

    public Versions<Task> versions(coursierapi.Versions versions2) {
        FileCache<Task> cache0 = this.cache(versions2.getCache());
        Vector<coursierapi.shaded.coursier.core.Repository> repositories = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(versions2.getRepositories()).asScala()).map((Function1<Repository, coursierapi.shaded.coursier.core.Repository> & Serializable)repo -> MODULE$.repository((Repository)repo))).toVector();
        return Versions$.MODULE$.apply(cache0, Task$.MODULE$.sync()).withRepositories(repositories).withModule(this.module(versions2.getModule()));
    }

    public VersionsResult getVersions(coursierapi.Versions versions0) {
        Versions<Task> ver = this.versions(versions0);
        Versions.Result res = (Versions.Result)Task$.MODULE$.PlatformTaskOps(ver.result().value()).unsafeRun(ver.cache().ec());
        coursierapi.shaded.scala.collection.immutable.Seq errors = (coursierapi.shaded.scala.collection.immutable.Seq)res.results().collect(new Serializable(){

            public final <A1 extends Tuple2<coursierapi.shaded.coursier.core.Repository, Either<String, coursierapi.shaded.coursier.core.Versions>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    coursierapi.shaded.coursier.core.Repository repo = A1._1();
                    Either<String, coursierapi.shaded.coursier.core.Versions> either = A1._2();
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        String error = (String)left.value();
                        return (B1)new AbstractMap.SimpleImmutableEntry<Repository, String>(ApiHelper$.MODULE$.repository(repo), error);
                    }
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<coursierapi.shaded.coursier.core.Repository, Either<String, coursierapi.shaded.coursier.core.Versions>> x1) {
                Either<String, coursierapi.shaded.coursier.core.Versions> either;
                Tuple2<coursierapi.shaded.coursier.core.Repository, Either<String, coursierapi.shaded.coursier.core.Versions>> tuple2 = x1;
                return tuple2 != null && (either = tuple2._2()) instanceof Left;
            }
        });
        coursierapi.shaded.scala.collection.immutable.Seq listings = (coursierapi.shaded.scala.collection.immutable.Seq)res.results().collect(new Serializable(){

            public final <A1 extends Tuple2<coursierapi.shaded.coursier.core.Repository, Either<String, coursierapi.shaded.coursier.core.Versions>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 != null) {
                    coursierapi.shaded.coursier.core.Repository repo = A1._1();
                    Either<String, coursierapi.shaded.coursier.core.Versions> either = A1._2();
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        coursierapi.shaded.coursier.core.Versions ver = (coursierapi.shaded.coursier.core.Versions)right.value();
                        return (B1)new AbstractMap.SimpleImmutableEntry<Repository, VersionListing>(ApiHelper$.MODULE$.repository(repo), ApiHelper$.MODULE$.versionListing(ver));
                    }
                }
                return function1.apply(x2);
            }

            public final boolean isDefinedAt(Tuple2<coursierapi.shaded.coursier.core.Repository, Either<String, coursierapi.shaded.coursier.core.Versions>> x2) {
                Either<String, coursierapi.shaded.coursier.core.Versions> either;
                Tuple2<coursierapi.shaded.coursier.core.Repository, Either<String, coursierapi.shaded.coursier.core.Versions>> tuple2 = x2;
                return tuple2 != null && (either = tuple2._2()) instanceof Right;
            }
        });
        return VersionsResult.of(JavaConverters$.MODULE$.seqAsJavaList(errors), JavaConverters$.MODULE$.seqAsJavaList(listings), this.versionListing(res.versions()));
    }

    public File cacheGet(Cache cache, Artifact artifact) {
        FileCache<Task> cache0 = this.cache(cache);
        Either either = (Either)Task$.MODULE$.PlatformTaskOps(cache0.file(this.artifact(artifact)).run().value()).unsafeRun(cache0.ec());
        if (either instanceof Left) {
            Left left = (Left)either;
            ArtifactError err = (ArtifactError)left.value();
            throw err;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            File f = (File)right.value();
            return f;
        }
        throw new MatchError(either);
    }

    public coursierapi.shaded.coursier.cache.ArchiveCache<Task> archiveCache(ArchiveCache archiveCache) {
        return ArchiveCache$.MODULE$.apply(archiveCache.getLocation(), this.cache(archiveCache.getCache()), UnArchiver$.MODULE$.default(), Task$.MODULE$.sync());
    }

    public File archiveCacheGet(ArchiveCache archiveCache, Artifact artifact) {
        coursierapi.shaded.coursier.cache.ArchiveCache<Task> archiveCache0 = this.archiveCache(archiveCache);
        Either either = (Either)Task$.MODULE$.PlatformTaskOps(archiveCache0.get(this.artifact(artifact)).value()).unsafeRun(archiveCache0.cache().ec());
        if (either instanceof Left) {
            Left left = (Left)either;
            ArtifactError err = (ArtifactError)left.value();
            throw err;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            File f = (File)right.value();
            return f;
        }
        throw new MatchError(either);
    }

    public File archiveCacheGetIfExists(ArchiveCache archiveCache, Artifact artifact) {
        coursierapi.shaded.coursier.cache.ArchiveCache<Task> archiveCache0 = this.archiveCache(archiveCache);
        Either either = (Either)Task$.MODULE$.PlatformTaskOps(archiveCache0.getIfExists(this.artifact(artifact)).value()).unsafeRun(archiveCache0.cache().ec());
        if (either instanceof Left) {
            Left left = (Left)either;
            ArtifactError err = (ArtifactError)left.value();
            throw err;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Option f = (Option)right.value();
            return (File)f.orNull($less$colon$less$.MODULE$.refl());
        }
        throw new MatchError(either);
    }

    public File jvmManagerGet(JvmManager manager, String jvmId) {
        JvmCache jvmCache = JvmCache$.MODULE$.apply().withDefaultIndex().withArchiveCache(this.archiveCache(manager.getArchiveCache()));
        JavaHome javaHome = JavaHome$.MODULE$.apply().withCache(jvmCache);
        return (File)Task$.MODULE$.PlatformTaskOps(javaHome.get(jvmId)).unsafeRun(jvmCache.archiveCache().cache().ec());
    }

    public int compareVersions(String version0, String version1) {
        return Version$.MODULE$.apply(version0).compareTo(Version$.MODULE$.apply(version1));
    }

    public static final /* synthetic */ boolean $anonfun$doFetch$5(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$doFetch$6(ArrayList artifactFiles$1, Tuple2 x$10) {
        Tuple2 tuple2 = x$10;
        if (tuple2 != null) {
            coursierapi.shaded.coursier.util.Artifact a = (coursierapi.shaded.coursier.util.Artifact)tuple2._1();
            File f = (File)tuple2._2();
            Artifact a0 = MODULE$.coursier$internal$api$ApiHelper$$artifact(a);
            AbstractMap.SimpleEntry<Artifact, File> ent = new AbstractMap.SimpleEntry<Artifact, File>(a0, f);
            return artifactFiles$1.add(ent);
        }
        throw new MatchError(tuple2);
    }

    private ApiHelper$() {
    }
}

