/*
 * Decompiled with CFR 0.152.
 */
package io.getquill.context.jdbc;

import io.getquill.NamingStrategy;
import io.getquill.ReturnAction;
import io.getquill.context.ContextEffect;
import io.getquill.context.ExecutionInfo;
import io.getquill.context.ProtoContext;
import io.getquill.context.jdbc.Decoders;
import io.getquill.context.jdbc.Encoders;
import io.getquill.context.jdbc.ResultSetExtractor$;
import io.getquill.context.sql.SqlContext;
import io.getquill.context.sql.idiom.SqlIdiom;
import io.getquill.util.ContextLogger;
import io.getquill.util.ContextLogger$;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public interface JdbcRunContext<Dialect extends SqlIdiom, Naming extends NamingStrategy>
extends SqlContext<Dialect, Naming>,
Encoders,
Decoders {
    public static void $init$(JdbcRunContext $this) {
        $this.io$getquill$context$jdbc$JdbcRunContext$_setter_$logger_$eq(ContextLogger$.MODULE$.apply(JdbcRunContext.class));
    }

    public ContextLogger logger();

    public void io$getquill$context$jdbc$JdbcRunContext$_setter_$logger_$eq(ContextLogger var1);

    public static BoxedUnit context$(JdbcRunContext $this) {
        return $this.context();
    }

    default public BoxedUnit context() {
        return BoxedUnit.UNIT;
    }

    public ContextEffect<Object> effect();

    public <T> Object withConnection(Function1<Connection, Object> var1);

    public static Object withConnectionWrapped$(JdbcRunContext $this, Function1 f) {
        return $this.withConnectionWrapped(f);
    }

    default public <T> Object withConnectionWrapped(Function1<Connection, T> f) {
        return this.withConnection((Function1<Connection, Object>)(Function1 & Serializable)conn -> this.effect().wrap(() -> JdbcRunContext.withConnectionWrapped$$anonfun$2$$anonfun$1(f, conn)));
    }

    public static Object executeAction$(JdbcRunContext $this, String sql, Function1 prepare, ExecutionInfo executionInfo, BoxedUnit dc) {
        return $this.executeAction(sql, (Function1<PreparedStatement, Tuple2<List<Object>, PreparedStatement>>)prepare, executionInfo, dc);
    }

    default public <T> Object executeAction(String sql, Function1<PreparedStatement, Tuple2<List<Object>, PreparedStatement>> prepare, ExecutionInfo executionInfo, BoxedUnit dc) {
        return this.withConnectionWrapped((Function1 & Serializable)conn -> {
            Tuple2 tuple2 = (Tuple2)prepare.apply((Object)conn.prepareStatement(sql));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List params = (List)tuple2._1();
            PreparedStatement ps = (PreparedStatement)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)params, (Object)ps);
            List params2 = (List)tuple22._1();
            PreparedStatement ps2 = (PreparedStatement)tuple22._2();
            this.logger().logQuery(sql, (Seq)params2);
            return ps2.executeUpdate();
        });
    }

    public static Function1 executeAction$default$2$(JdbcRunContext $this) {
        return $this.executeAction$default$2();
    }

    default public <T> Function1<PreparedStatement, Tuple2<List<Object>, PreparedStatement>> executeAction$default$2() {
        return this.identityPrepare();
    }

    public static Object executeQuery$(JdbcRunContext $this, String sql, Function1 prepare, Function1 extractor, ExecutionInfo executionInfo, BoxedUnit dc) {
        return $this.executeQuery(sql, (Function1<PreparedStatement, Tuple2<List<Object>, PreparedStatement>>)prepare, extractor, executionInfo, dc);
    }

    default public <T> Object executeQuery(String sql, Function1<PreparedStatement, Tuple2<List<Object>, PreparedStatement>> prepare, Function1<ResultSet, T> extractor, ExecutionInfo executionInfo, BoxedUnit dc) {
        return this.withConnectionWrapped((Function1 & Serializable)conn -> {
            Tuple2 tuple2 = (Tuple2)prepare.apply((Object)conn.prepareStatement(sql));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List params = (List)tuple2._1();
            PreparedStatement ps = (PreparedStatement)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)params, (Object)ps);
            List params2 = (List)tuple22._1();
            PreparedStatement ps2 = (PreparedStatement)tuple22._2();
            this.logger().logQuery(sql, (Seq)params2);
            ResultSet rs = ps2.executeQuery();
            return this.extractResult(rs, extractor);
        });
    }

    public static Function1 executeQuery$default$2$(JdbcRunContext $this) {
        return $this.executeQuery$default$2();
    }

    default public <T> Function1<PreparedStatement, Tuple2<List<Object>, PreparedStatement>> executeQuery$default$2() {
        return this.identityPrepare();
    }

    public static Function1 executeQuery$default$3$(JdbcRunContext $this) {
        return $this.executeQuery$default$3();
    }

    default public <T> Function1<ResultSet, ResultSet> executeQuery$default$3() {
        return this.identityExtractor();
    }

    public static Object executeQuerySingle$(JdbcRunContext $this, String sql, Function1 prepare, Function1 extractor, ExecutionInfo executionInfo, BoxedUnit dc) {
        return $this.executeQuerySingle(sql, (Function1<PreparedStatement, Tuple2<List<Object>, PreparedStatement>>)prepare, extractor, executionInfo, dc);
    }

    default public <T> Object executeQuerySingle(String sql, Function1<PreparedStatement, Tuple2<List<Object>, PreparedStatement>> prepare, Function1<ResultSet, T> extractor, ExecutionInfo executionInfo, BoxedUnit dc) {
        return this.handleSingleWrappedResult(this.executeQuery(sql, prepare, extractor, executionInfo, dc));
    }

    public static Function1 executeQuerySingle$default$2$(JdbcRunContext $this) {
        return $this.executeQuerySingle$default$2();
    }

    default public <T> Function1<PreparedStatement, Tuple2<List<Object>, PreparedStatement>> executeQuerySingle$default$2() {
        return this.identityPrepare();
    }

    public static Function1 executeQuerySingle$default$3$(JdbcRunContext $this) {
        return $this.executeQuerySingle$default$3();
    }

    default public <T> Function1<ResultSet, ResultSet> executeQuerySingle$default$3() {
        return this.identityExtractor();
    }

    public static Object executeActionReturning$(JdbcRunContext $this, String sql, Function1 prepare, Function1 extractor, ReturnAction returningBehavior, ExecutionInfo executionInfo, BoxedUnit dc) {
        return $this.executeActionReturning(sql, (Function1<PreparedStatement, Tuple2<List<Object>, PreparedStatement>>)prepare, extractor, returningBehavior, executionInfo, dc);
    }

    default public <O> Object executeActionReturning(String sql, Function1<PreparedStatement, Tuple2<List<Object>, PreparedStatement>> prepare, Function1<ResultSet, O> extractor, ReturnAction returningBehavior, ExecutionInfo executionInfo, BoxedUnit dc) {
        return this.withConnectionWrapped((Function1 & Serializable)conn -> {
            Tuple2 tuple2 = (Tuple2)prepare.apply((Object)this.prepareWithReturning(sql, (Connection)conn, returningBehavior));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List params = (List)tuple2._1();
            PreparedStatement ps = (PreparedStatement)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)params, (Object)ps);
            List params2 = (List)tuple22._1();
            PreparedStatement ps2 = (PreparedStatement)tuple22._2();
            this.logger().logQuery(sql, (Seq)params2);
            ps2.executeUpdate();
            return this.handleSingleResult(this.extractResult(ps2.getGeneratedKeys(), extractor));
        });
    }

    public static Function1 executeActionReturning$default$2$(JdbcRunContext $this) {
        return $this.executeActionReturning$default$2();
    }

    default public <O> Function1<PreparedStatement, Tuple2<List<Object>, PreparedStatement>> executeActionReturning$default$2() {
        return this.identityPrepare();
    }

    public static PreparedStatement prepareWithReturning$(JdbcRunContext $this, String sql, Connection conn, ReturnAction returningBehavior) {
        return $this.prepareWithReturning(sql, conn, returningBehavior);
    }

    default public PreparedStatement prepareWithReturning(String sql, Connection conn, ReturnAction returningBehavior) {
        PreparedStatement preparedStatement;
        ReturnAction returnAction = returningBehavior;
        if (ReturnAction.ReturnRecord$.MODULE$.equals(returnAction)) {
            preparedStatement = conn.prepareStatement(sql, 1);
        } else if (returnAction instanceof ReturnAction.ReturnColumns) {
            List columns = ((ReturnAction.ReturnColumns)returnAction).columns();
            preparedStatement = conn.prepareStatement(sql, (String[])columns.toArray(ClassTag$.MODULE$.apply(String.class)));
        } else if (ReturnAction.ReturnNothing$.MODULE$.equals(returnAction)) {
            preparedStatement = conn.prepareStatement(sql);
        } else {
            throw new MatchError((Object)returnAction);
        }
        return preparedStatement;
    }

    public static Object executeBatchAction$(JdbcRunContext $this, List groups, ExecutionInfo executionInfo, BoxedUnit dc) {
        return $this.executeBatchAction((List<ProtoContext.BatchGroup>)groups, executionInfo, dc);
    }

    default public Object executeBatchAction(List<ProtoContext.BatchGroup> groups, ExecutionInfo executionInfo, BoxedUnit dc) {
        return this.withConnectionWrapped((Function1 & Serializable)conn -> groups.flatMap((Function1 & Serializable)x$1 -> {
            ProtoContext.BatchGroup batchGroup = x$1;
            if (batchGroup == null) {
                throw new MatchError((Object)batchGroup);
            }
            ProtoContext.BatchGroup batchGroup2 = this.BatchGroup().unapply(batchGroup);
            String string = batchGroup2._1();
            List list = batchGroup2._2();
            String sql = string;
            List prepare = list;
            PreparedStatement ps = conn.prepareStatement(sql);
            prepare.foreach((Function1)(JProcedure1 & Serializable)f -> {
                Tuple2 tuple2 = (Tuple2)f.apply((Object)ps);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                List params = (List)tuple2._1();
                List params2 = params;
                ps.addBatch();
            });
            Object object = Predef$.MODULE$.intArrayOps(ps.executeBatch());
            return Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(object, (Function1)(JFunction1.mcJI.sp & Serializable)_$2 -> _$2, ClassTag$.MODULE$.apply(Long.TYPE)));
        }));
    }

    public static Object executeBatchActionReturning$(JdbcRunContext $this, List groups, Function1 extractor, ExecutionInfo executionInfo, BoxedUnit dc) {
        return $this.executeBatchActionReturning((List<ProtoContext.BatchGroupReturning>)groups, extractor, executionInfo, dc);
    }

    default public <T> Object executeBatchActionReturning(List<ProtoContext.BatchGroupReturning> groups, Function1<ResultSet, T> extractor, ExecutionInfo executionInfo, BoxedUnit dc) {
        return this.withConnectionWrapped((Function1 & Serializable)conn -> groups.flatMap((Function1 & Serializable)x$1 -> {
            ProtoContext.BatchGroupReturning batchGroupReturning = x$1;
            if (batchGroupReturning == null) {
                throw new MatchError((Object)batchGroupReturning);
            }
            ProtoContext.BatchGroupReturning batchGroupReturning2 = this.BatchGroupReturning().unapply(batchGroupReturning);
            String string = batchGroupReturning2._1();
            ReturnAction returnAction = batchGroupReturning2._2();
            List list = batchGroupReturning2._3();
            String sql = string;
            ReturnAction returningBehavior = returnAction;
            List prepare = list;
            PreparedStatement ps = this.prepareWithReturning(sql, (Connection)conn, returningBehavior);
            prepare.foreach((Function1)(JProcedure1 & Serializable)f -> {
                Tuple2 tuple2 = (Tuple2)f.apply((Object)ps);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                List params = (List)tuple2._1();
                List params2 = params;
                this.logger().logBatchItem(sql, (Seq)params2);
                ps.addBatch();
            });
            ps.executeBatch();
            return this.extractResult(ps.getGeneratedKeys(), extractor);
        }));
    }

    public static Object handleSingleWrappedResult$(JdbcRunContext $this, Object list) {
        return $this.handleSingleWrappedResult(list);
    }

    default public <T> Object handleSingleWrappedResult(Object list) {
        return this.effect().push(list, (Function1 & Serializable)_$3 -> this.handleSingleResult((List)_$3));
    }

    public static String parseJdbcType$(JdbcRunContext $this, int intType) {
        return $this.parseJdbcType(intType);
    }

    default public String parseJdbcType(int intType) {
        return JDBCType.valueOf(intType).getName();
    }

    public static List extractResult$(JdbcRunContext $this, ResultSet rs, Function1 extractor) {
        return $this.extractResult(rs, extractor);
    }

    default public <T> List<T> extractResult(ResultSet rs, Function1<ResultSet, T> extractor) {
        return ResultSetExtractor$.MODULE$.apply(rs, extractor);
    }

    private static Object withConnectionWrapped$$anonfun$2$$anonfun$1(Function1 f$2, Connection conn$2) {
        return f$2.apply((Object)conn$2);
    }
}

