/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.http;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.Objects;

public final class Response {
    private final int code;
    private final InputStream body;

    public Response(int code, InputStream body) {
        Preconditions.checkArgument((code >= 100 && code <= 599 ? 1 : 0) != 0, (Object)"Invalid HTTP status code");
        this.code = code;
        this.body = body;
    }

    public int getCode() {
        return this.code;
    }

    public InputStream getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Response response = (Response)o;
        return this.code == response.code && Objects.equals(this.body, response.body);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.body);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("code", this.code).add("body", (Object)this.body).toString();
    }
}

