/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.OptBoolean;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.getstream.core.models.Data;
import io.getstream.core.models.FeedID;
import io.getstream.core.models.Reaction;
import io.getstream.core.models.serialization.DateDeserializer;
import io.getstream.core.utils.Serialization;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
public class EnrichedActivity {
    private final String id;
    private final Data actor;
    private final String verb;
    private final Data object;
    private final String foreignID;
    private final Data target;
    private final Date time;
    private final Data origin;
    private final List<FeedID> to;
    private final Double score;
    private final Map<String, Number> reactionCounts;
    private final Map<String, List<Reaction>> ownReactions;
    private final Map<String, List<Reaction>> latestReactions;
    private final Map<String, Object> extra;

    private EnrichedActivity(Builder builder) {
        this.id = builder.id;
        this.actor = builder.actor;
        this.verb = builder.verb;
        this.object = builder.object;
        this.foreignID = builder.foreignID;
        this.target = builder.target;
        this.time = builder.time;
        this.origin = builder.origin;
        this.to = builder.to;
        this.score = builder.score;
        this.reactionCounts = builder.reactionCounts;
        this.ownReactions = builder.ownReactions;
        this.latestReactions = builder.latestReactions;
        this.extra = builder.extra;
    }

    public String getID() {
        return this.id;
    }

    public Data getActor() {
        return this.actor;
    }

    public String getVerb() {
        return this.verb;
    }

    public Data getObject() {
        return this.object;
    }

    @JsonProperty(value="foreign_id")
    public String getForeignID() {
        return this.foreignID;
    }

    public Data getTarget() {
        return this.target;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS", lenient=OptBoolean.FALSE, timezone="UTC")
    public Date getTime() {
        return this.time;
    }

    public Data getOrigin() {
        return this.origin;
    }

    public List<FeedID> getTo() {
        return this.to;
    }

    public Double getScore() {
        return this.score;
    }

    @JsonIgnore
    public Map<String, Number> getReactionCounts() {
        return this.reactionCounts;
    }

    @JsonIgnore
    public Map<String, List<Reaction>> getOwnReactions() {
        return this.ownReactions;
    }

    @JsonIgnore
    public Map<String, List<Reaction>> getLatestReactions() {
        return this.latestReactions;
    }

    @JsonAnyGetter
    public Map<String, Object> getExtra() {
        return this.extra;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnrichedActivity activity = (EnrichedActivity)o;
        return Objects.equals(this.id, activity.id) && Objects.equals(this.actor, activity.actor) && Objects.equals(this.verb, activity.verb) && Objects.equals(this.object, activity.object) && Objects.equals(this.foreignID, activity.foreignID) && Objects.equals(this.target, activity.target) && Objects.equals(this.time, activity.time) && Objects.equals(this.origin, activity.origin) && Objects.equals(this.to, activity.to) && Objects.equals(this.score, activity.score) && Objects.equals(this.extra, activity.extra);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.actor, this.verb, this.object, this.foreignID, this.target, this.time, this.origin, this.to, this.score, this.extra);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("actor", (Object)this.actor).add("verb", (Object)this.verb).add("object", (Object)this.object).add("foreignID", (Object)this.foreignID).add("target", (Object)this.target).add("time", (Object)this.time).add("origin", (Object)this.origin).add("to", this.to).add("score", (Object)this.score).add("ownReactions", this.ownReactions).add("latestReactions", this.latestReactions).add("reactionCounts", this.reactionCounts).add("extra", this.extra).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private String id;
        private Data actor;
        private String verb;
        private Data object;
        private String foreignID;
        private Data target;
        private Date time;
        private Data origin;
        private List<FeedID> to;
        private Double score;
        private Map<String, Number> reactionCounts;
        private Map<String, List<Reaction>> ownReactions;
        private Map<String, List<Reaction>> latestReactions;
        private Map<String, Object> extra;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @JsonIgnore
        public Builder actor(String actor) {
            this.actor = new Data(actor);
            return this;
        }

        @JsonProperty(value="actor")
        public Builder actor(Data actor) {
            this.actor = actor;
            return this;
        }

        public Builder verb(String verb) {
            this.verb = verb;
            return this;
        }

        @JsonIgnore
        public Builder object(String object) {
            this.object = new Data(object);
            return this;
        }

        @JsonProperty(value="object")
        public Builder object(Data object) {
            this.object = object;
            return this;
        }

        @JsonProperty(value="foreign_id")
        public Builder foreignID(String foreignID) {
            this.foreignID = foreignID;
            return this;
        }

        @JsonIgnore
        public Builder target(String target) {
            this.target = new Data(target);
            return this;
        }

        @JsonProperty(value="target")
        public Builder target(Data target) {
            this.target = target;
            return this;
        }

        @JsonDeserialize(using=DateDeserializer.class)
        public Builder time(Date time) {
            this.time = time;
            return this;
        }

        @JsonIgnore
        public Builder origin(String origin) {
            this.origin = new Data(origin);
            return this;
        }

        @JsonProperty(value="origin")
        public Builder origin(Data origin) {
            this.origin = origin;
            return this;
        }

        @JsonProperty(value="to")
        public Builder to(List<FeedID> to) {
            this.to = to;
            return this;
        }

        @JsonIgnore
        public Builder to(Iterable<FeedID> to) {
            this.to = Lists.newArrayList(to);
            return this;
        }

        @JsonIgnore
        public Builder to(FeedID ... to) {
            this.to = Lists.newArrayList((Object[])to);
            return this;
        }

        public Builder score(double score) {
            this.score = score;
            return this;
        }

        @JsonProperty(value="own_reactions")
        public Builder ownReactions(Map<String, List<Reaction>> ownReactions) {
            this.ownReactions = ownReactions;
            return this;
        }

        @JsonProperty(value="latest_reactions")
        public Builder latestReactions(Map<String, List<Reaction>> latestReactions) {
            this.latestReactions = latestReactions;
            return this;
        }

        @JsonProperty(value="reaction_counts")
        public Builder reactionCounts(Map<String, Number> reactionCounts) {
            this.reactionCounts = reactionCounts;
            return this;
        }

        @JsonAnySetter
        public Builder extraField(String key, Object value) {
            if (this.extra == null) {
                this.extra = Maps.newHashMap();
            }
            this.extra.put(key, value);
            return this;
        }

        @JsonIgnore
        public Builder extra(Map<String, Object> extra) {
            if (!extra.isEmpty()) {
                this.extra = extra;
            }
            return this;
        }

        @JsonIgnore
        public Builder fromEnrichedActivity(EnrichedActivity activity) {
            this.id = activity.id;
            this.actor = activity.actor;
            this.verb = activity.verb;
            this.object = activity.object;
            this.foreignID = activity.foreignID;
            this.target = activity.target;
            this.time = activity.time;
            this.origin = activity.origin;
            this.to = activity.to;
            this.score = activity.score;
            this.ownReactions = activity.ownReactions;
            this.latestReactions = activity.latestReactions;
            this.reactionCounts = activity.reactionCounts;
            this.extra = activity.extra;
            return this;
        }

        @JsonIgnore
        public <T> Builder fromCustomEnrichedActivity(T custom) {
            return this.fromEnrichedActivity(Serialization.convert(custom, EnrichedActivity.class));
        }

        public EnrichedActivity build() {
            Preconditions.checkNotNull((Object)this.actor, (Object)"EnrichedActivity 'actor' field required");
            Preconditions.checkNotNull((Object)this.verb, (Object)"EnrichedActivity 'verb' field required");
            Preconditions.checkNotNull((Object)this.object, (Object)"EnrichedActivity 'object' field required");
            return new EnrichedActivity(this);
        }
    }
}

