/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.getstream.core.http.Request;
import io.getstream.core.options.RequestOption;
import java.util.List;

public final class EnrichmentFlags
implements RequestOption {
    private final List<OpEntry> ops = Lists.newArrayList();
    private String userID;

    public EnrichmentFlags withOwnReactions() {
        this.ops.add(new OpEntry(OpType.OWN_REACTIONS, "true"));
        return this;
    }

    public EnrichmentFlags withUserReactions(String userID) {
        Preconditions.checkNotNull((Object)userID, (Object)"No user ID");
        Preconditions.checkArgument((!userID.isEmpty() ? 1 : 0) != 0, (Object)"No user ID");
        this.ops.add(new OpEntry(OpType.OWN_REACTIONS, "true"));
        this.userID = userID;
        return this;
    }

    public EnrichmentFlags withRecentReactions() {
        this.ops.add(new OpEntry(OpType.RECENT_REACTIONS, "true"));
        return this;
    }

    public EnrichmentFlags withRecentReactions(int limit) {
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"Limit should be a positive value");
        this.ops.add(new OpEntry(OpType.RECENT_REACTIONS_LIMIT, Integer.toString(limit)));
        return this.withRecentReactions();
    }

    public EnrichmentFlags reactionKindFilter(String ... kinds) {
        Preconditions.checkNotNull((Object)kinds, (Object)"No kinds to filter by");
        Preconditions.checkArgument((kinds.length > 0 ? 1 : 0) != 0, (Object)"No kinds to filter by");
        this.ops.add(new OpEntry(OpType.REACTION_KINDS, String.join((CharSequence)",", kinds)));
        return this;
    }

    public EnrichmentFlags withReactionCounts() {
        this.ops.add(new OpEntry(OpType.REACTION_COUNTS, "true"));
        return this;
    }

    public EnrichmentFlags withOwnChildren() {
        this.ops.add(new OpEntry(OpType.OWN_CHILDREN, "true"));
        return this;
    }

    public EnrichmentFlags withUserChildren(String userID) {
        Preconditions.checkNotNull((Object)userID, (Object)"No user ID");
        Preconditions.checkArgument((!userID.isEmpty() ? 1 : 0) != 0, (Object)"No user ID");
        this.ops.add(new OpEntry(OpType.OWN_CHILDREN, "true"));
        this.userID = userID;
        return this;
    }

    @Override
    public void apply(Request.Builder builder) {
        for (OpEntry op : this.ops) {
            builder.addQueryParameter(op.type, op.value);
        }
        if (this.userID != null) {
            builder.addQueryParameter("user_id", this.userID);
        }
    }

    private static final class OpEntry {
        String type;
        String value;

        OpEntry(OpType type, String value) {
            this.type = type.toString();
            this.value = value;
        }
    }

    static enum OpType {
        OWN_CHILDREN("with_own_children"),
        OWN_REACTIONS("with_own_reactions"),
        REACTION_COUNTS("with_reaction_counts"),
        REACTION_KINDS("reaction_kinds_filter"),
        RECENT_REACTIONS("with_recent_reactions"),
        RECENT_REACTIONS_LIMIT("recent_reactions_limit");

        private String operator;

        private OpType(String operator) {
            this.operator = operator;
        }

        public String toString() {
            return this.operator;
        }
    }
}

