/*
 * Decompiled with CFR 0.152.
 */
package client.repo;

import client.repo.StreamRepositoryImpl;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.OkHttpClient;
import io.getstream.client.config.AuthenticationHandlerConfiguration;
import io.getstream.client.config.ClientConfiguration;
import io.getstream.client.repo.StreamRepoFactory;
import io.getstream.client.repo.StreamRepository;
import java.util.concurrent.TimeUnit;

public class StreamRepoFactoryImpl
implements StreamRepoFactory {
    public StreamRepository newInstance(ClientConfiguration clientConfiguration, AuthenticationHandlerConfiguration authenticationHandlerConfiguration) {
        return new StreamRepositoryImpl(clientConfiguration, this.initClient(clientConfiguration));
    }

    private OkHttpClient initClient(ClientConfiguration config) {
        OkHttpClient client = new OkHttpClient();
        client.setConnectTimeout((long)config.getConnectionTimeout(), TimeUnit.MILLISECONDS);
        client.setReadTimeout((long)config.getTimeout(), TimeUnit.MILLISECONDS);
        client.setWriteTimeout((long)config.getTimeout(), TimeUnit.MILLISECONDS);
        client.setRetryOnConnectionFailure(true);
        client.setConnectionPool(new ConnectionPool(config.getMaxConnections(), config.getKeepAlive()));
        return client;
    }
}

