/*
 * Decompiled with CFR 0.152.
 */
package client.repo.handlers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.okhttp.Response;
import io.getstream.client.exception.AuthenticationFailedException;
import io.getstream.client.exception.InternalServerException;
import io.getstream.client.exception.InvalidOrMissingInputException;
import io.getstream.client.exception.ResourceNotFoundException;
import io.getstream.client.exception.StreamClientException;
import io.getstream.client.model.beans.StreamErrorResponse;
import java.io.IOException;

public class StreamExceptionHandler {
    private final ObjectMapper objectMapper;

    public StreamExceptionHandler(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void handleResponseCode(Response response) throws IOException, StreamClientException {
        switch (response.code()) {
            case 400: {
                throw this.buildException((StreamClientException)new InvalidOrMissingInputException(), response);
            }
            case 401: {
                throw this.buildException((StreamClientException)new AuthenticationFailedException(), response);
            }
            case 403: {
                throw this.buildException((StreamClientException)new AuthenticationFailedException(), response);
            }
            case 404: {
                throw this.buildException((StreamClientException)new ResourceNotFoundException(), response);
            }
            case 500: {
                throw this.buildException((StreamClientException)new InternalServerException(), response);
            }
        }
    }

    private StreamClientException buildException(StreamClientException exception, Response response) throws IOException {
        StreamErrorResponse error = (StreamErrorResponse)this.objectMapper.readValue(response.body().byteStream(), StreamErrorResponse.class);
        exception.setCode(error.getCode());
        exception.setHttpStatusCode(error.getStatusCode());
        exception.setDetail(error.getDetail());
        exception.setExceptionField(error.getException());
        return exception;
    }
}

