/*
 * Decompiled with CFR 0.152.
 */
package client.repo.utils;

import client.repo.utils.Base64;
import com.google.common.collect.ImmutableList;
import io.getstream.client.exception.StreamClientException;
import io.getstream.client.model.activities.BaseActivity;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class SignatureUtils {
    private static final String HMAC_SHA1 = "HmacSHA1";
    public static final String UTF_8 = "UTF-8";

    private SignatureUtils() {
        throw new AssertionError();
    }

    public static void addSignatureToRecipients(String secretKey, BaseActivity activity) throws StreamClientException {
        if (activity.getTo() != null && !activity.getTo().isEmpty()) {
            ImmutableList.Builder recipients = ImmutableList.builder();
            for (String recipient : activity.getTo()) {
                try {
                    recipients.add((Object)String.format("%s %s", recipient, SignatureUtils.calculateHMAC(secretKey, recipient.replace(":", ""))));
                }
                catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                    throw new RuntimeException("Fatal error: cannot create authentication token.");
                }
            }
            activity.setTo((List)recipients.build());
        }
    }

    public static String calculateHMAC(String secretKey, String feedId) throws SignatureException, NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        SecretKeySpec signingKey = new SecretKeySpec(SignatureUtils.toSHA1(secretKey), HMAC_SHA1);
        Mac mac = Mac.getInstance(HMAC_SHA1);
        mac.init(signingKey);
        return SignatureUtils.escapeDigest(Base64.encodeToString(mac.doFinal(feedId.getBytes(UTF_8)), 0));
    }

    private static byte[] toSHA1(String key) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        return MessageDigest.getInstance("SHA-1").digest(key.getBytes(UTF_8));
    }

    private static String escapeDigest(String digest) {
        return digest.replace("+", "-").replace("/", "_").replaceAll("^=+", "").replaceAll("=+$", "");
    }
}

