/*
 * Decompiled with CFR 0.152.
 */
package client.repo.utils;

import io.getstream.client.exception.UriBuilderException;
import java.net.URI;
import java.net.URISyntaxException;

public class UriBuilder {
    private static final String PATH_SEPARATOR = "/";
    private URI uri;
    private StringBuilder uriPath = new StringBuilder();
    private StringBuilder uriParams = new StringBuilder();

    private UriBuilder(URI baseEndpoint) {
        this.uri = baseEndpoint;
        if (this.uri.getPath() != null) {
            this.uriPath.append(this.uri.getPath());
        }
        if (this.uri.getQuery() != null) {
            this.uriParams.append(this.uri.getQuery());
        }
    }

    private UriBuilder(String baseEndpoint) {
        this.uri = URI.create(baseEndpoint);
        if (this.uri.getPath() != null) {
            this.uriPath.append(this.uri.getPath());
        }
        if (this.uri.getQuery() != null) {
            this.uriParams.append(this.uri.getQuery());
        }
    }

    public static UriBuilder fromEndpoint(String endpoint) {
        UriBuilder uriBuilder = new UriBuilder(endpoint);
        return uriBuilder;
    }

    public static UriBuilder fromEndpoint(URI endpoint) {
        UriBuilder uriBuilder = new UriBuilder(endpoint);
        return uriBuilder;
    }

    public UriBuilder path(String path) {
        if (this.uriPath.toString().endsWith(PATH_SEPARATOR)) {
            this.uriPath.append(path);
        } else {
            this.uriPath.append(PATH_SEPARATOR).append(path);
        }
        return this;
    }

    public UriBuilder queryParam(String name, String value) {
        if (this.uriParams.length() > 0) {
            this.uriParams.append('&');
        }
        this.uriParams.append(name).append('=').append(value);
        return this;
    }

    public UriBuilder queryParam(String name, Integer value) {
        if (this.uriParams.length() > 0) {
            this.uriParams.append('&');
        }
        this.uriParams.append(name).append('=').append(String.valueOf(value));
        return this;
    }

    public UriBuilder queryParam(String name, Long value) {
        if (this.uriParams.length() > 0) {
            this.uriParams.append('&');
        }
        this.uriParams.append(name).append('=').append(String.valueOf(value));
        return this;
    }

    public URI build() throws UriBuilderException {
        String finalUriPath = null;
        if (this.uriPath.length() > 0) {
            finalUriPath = this.uriPath.toString();
        }
        String finalUriParams = null;
        if (this.uriParams.length() > 0) {
            finalUriParams = this.uriParams.toString();
        }
        try {
            return new URI(this.uri.getScheme(), null, this.uri.getHost(), this.uri.getPort(), finalUriPath, finalUriParams, null);
        }
        catch (URISyntaxException e) {
            throw new UriBuilderException("Cannot build valid URI", (Throwable)e);
        }
    }
}

