/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.okhttp;

import com.google.common.base.Preconditions;
import io.getstream.client.StreamClient;
import io.getstream.client.config.AuthenticationHandlerConfiguration;
import io.getstream.client.config.ClientConfiguration;
import io.getstream.client.model.feeds.BaseFeedFactory;
import io.getstream.client.model.feeds.Feed;
import io.getstream.client.model.feeds.FeedFactory;
import io.getstream.client.okhttp.repo.StreamRepoFactoryImpl;
import io.getstream.client.repo.StreamRepository;
import java.io.IOException;

public class StreamClientImpl
implements StreamClient {
    private FeedFactory feedFactory;
    private final StreamRepository streamRepository;

    public StreamClientImpl(ClientConfiguration clientConfiguration, String key, String secretKey) {
        Preconditions.checkNotNull((Object)clientConfiguration, (Object)"Client configuration cannot be null.");
        AuthenticationHandlerConfiguration authenticationHandlerConfiguration = new AuthenticationHandlerConfiguration();
        authenticationHandlerConfiguration.setApiKey((String)Preconditions.checkNotNull((Object)key, (Object)"API key cannot be null."));
        authenticationHandlerConfiguration.setSecretKey((String)Preconditions.checkNotNull((Object)secretKey, (Object)"API secret key cannot be null."));
        clientConfiguration.setAuthenticationHandlerConfiguration(authenticationHandlerConfiguration);
        this.streamRepository = new StreamRepoFactoryImpl().newInstance(clientConfiguration, authenticationHandlerConfiguration);
        this.feedFactory = new BaseFeedFactory(this.streamRepository);
    }

    public Feed newFeed(String feedSlug, String id) {
        return this.feedFactory.createFeed(feedSlug, id);
    }

    protected FeedFactory getFeedFactory() {
        return this.feedFactory;
    }

    protected void setFeedFactory(FeedFactory feedFactory) {
        this.feedFactory = feedFactory;
    }

    public void shutdown() throws IOException {
        this.streamRepository.shutdown();
    }
}

