/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.okhttp.repo;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import io.getstream.client.config.ClientConfiguration;
import io.getstream.client.exception.StreamClientException;
import io.getstream.client.model.activities.AggregatedActivity;
import io.getstream.client.model.activities.BaseActivity;
import io.getstream.client.model.activities.NotificationActivity;
import io.getstream.client.model.beans.FeedFollow;
import io.getstream.client.model.beans.MarkedActivity;
import io.getstream.client.model.beans.StreamResponse;
import io.getstream.client.model.feeds.BaseFeed;
import io.getstream.client.model.filters.FeedFilter;
import io.getstream.client.okhttp.repo.StreamActivityRepository;
import io.getstream.client.okhttp.repo.handlers.StreamExceptionHandler;
import io.getstream.client.okhttp.repo.utils.FeedFilterUtils;
import io.getstream.client.okhttp.repo.utils.StreamRepoUtils;
import io.getstream.client.okhttp.repo.utils.UriBuilder;
import io.getstream.client.repo.StreamRepository;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamRepositoryImpl
implements StreamRepository {
    private static final Logger LOG = LoggerFactory.getLogger(StreamRepositoryImpl.class);
    static final String API_KEY = "api_key";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
    private final URI baseEndpoint;
    private final String apiKey;
    private final String secretKey;
    private final StreamExceptionHandler exceptionHandler;
    private final OkHttpClient httpClient;
    private final StreamActivityRepository streamActivityRepository;

    public String getToken(BaseFeed feed) {
        return StreamRepoUtils.createFeedToken(feed, this.secretKey);
    }

    public StreamRepositoryImpl(ClientConfiguration streamClient, OkHttpClient closeableHttpClient) {
        this.baseEndpoint = streamClient.getRegion().getEndpoint();
        this.apiKey = streamClient.getAuthenticationHandlerConfiguration().getApiKey();
        this.secretKey = streamClient.getAuthenticationHandlerConfiguration().getSecretKey();
        this.exceptionHandler = new StreamExceptionHandler(OBJECT_MAPPER);
        this.httpClient = closeableHttpClient;
        this.streamActivityRepository = new StreamActivityRepository(OBJECT_MAPPER, this.baseEndpoint, this.apiKey, this.exceptionHandler, this.httpClient, this.secretKey);
    }

    public void follow(BaseFeed feed, String targetFeedId) throws StreamClientException, IOException {
        Request.Builder requestBuilder = new Request.Builder().url(UriBuilder.fromEndpoint(this.baseEndpoint).path("feed").path(feed.getFeedSlug()).path(feed.getUserId()).path("following/").queryParam(API_KEY, this.apiKey).build().toURL());
        requestBuilder.post(new FormEncodingBuilder().add("target", targetFeedId).build());
        Request request = this.addAuthentication(feed, requestBuilder).build();
        this.fireAndForget(request);
    }

    public void unfollow(BaseFeed feed, String targetFeedId) throws StreamClientException, IOException {
        Request.Builder requestBuilder = new Request.Builder().url(UriBuilder.fromEndpoint(this.baseEndpoint).path("feed").path(feed.getFeedSlug()).path(feed.getUserId()).path("following").path(targetFeedId + "/").queryParam(API_KEY, this.apiKey).build().toURL()).delete();
        this.fireAndForget(this.addAuthentication(feed, requestBuilder).build());
    }

    public List<FeedFollow> getFollowing(BaseFeed feed, FeedFilter filter) throws StreamClientException, IOException {
        Request.Builder requestBuilder = new Request.Builder().url(FeedFilterUtils.apply(UriBuilder.fromEndpoint(this.baseEndpoint).path("feed").path(feed.getFeedSlug()).path(feed.getUserId()).path("following/").queryParam(API_KEY, this.apiKey), filter).build().toURL()).get();
        Request request = this.addAuthentication(feed, requestBuilder).build();
        LOG.debug("Invoking url: '{}'", (Object)request.urlString());
        Response response = this.httpClient.newCall(request).execute();
        this.handleResponseCode(response);
        StreamResponse streamResponse = (StreamResponse)OBJECT_MAPPER.readValue(response.body().byteStream(), (TypeReference)new TypeReference<StreamResponse<FeedFollow>>(){});
        return streamResponse.getResults();
    }

    public List<FeedFollow> getFollowers(BaseFeed feed, FeedFilter filter) throws StreamClientException, IOException {
        Request.Builder requestBuilder = new Request.Builder().url(FeedFilterUtils.apply(UriBuilder.fromEndpoint(this.baseEndpoint).path("feed").path(feed.getFeedSlug()).path(feed.getUserId()).path("followers/").queryParam(API_KEY, this.apiKey), filter).build().toURL()).get();
        Request request = this.addAuthentication(feed, requestBuilder).build();
        LOG.debug("Invoking url: '{}'", (Object)request.urlString());
        Response response = this.httpClient.newCall(request).execute();
        this.handleResponseCode(response);
        StreamResponse streamResponse = (StreamResponse)OBJECT_MAPPER.readValue(response.body().byteStream(), (TypeReference)new TypeReference<StreamResponse<FeedFollow>>(){});
        return streamResponse.getResults();
    }

    public void deleteActivityById(BaseFeed feed, String activityId) throws IOException, StreamClientException {
        this.streamActivityRepository.deleteActivityById(feed, activityId);
    }

    public void deleteActivityByForeignId(BaseFeed feed, String activityId) throws IOException, StreamClientException {
        this.streamActivityRepository.deleteActivityByForeignId(feed, activityId);
    }

    public <T extends BaseActivity> StreamResponse<T> getActivities(BaseFeed feed, Class<T> type, FeedFilter filter) throws IOException, StreamClientException {
        return this.streamActivityRepository.getActivities(feed, type, filter);
    }

    public <T extends BaseActivity> T addActivity(BaseFeed feed, T activity) throws StreamClientException, IOException {
        return this.streamActivityRepository.addActivity(feed, activity);
    }

    public <T extends BaseActivity> StreamResponse<AggregatedActivity<T>> getAggregatedActivities(BaseFeed feed, Class<T> type, FeedFilter filter) throws IOException, StreamClientException {
        return this.streamActivityRepository.getAggregatedActivities(feed, type, filter);
    }

    public <T extends BaseActivity> StreamResponse<NotificationActivity<T>> getNotificationActivities(BaseFeed feed, Class<T> type, FeedFilter filter) throws IOException, StreamClientException {
        return this.streamActivityRepository.getNotificationActivities(feed, type, filter);
    }

    public <T extends BaseActivity> StreamResponse<NotificationActivity<T>> getNotificationActivities(BaseFeed feed, Class<T> type, FeedFilter filter, boolean markAsRead, boolean markAsSeen) throws IOException, StreamClientException {
        return this.streamActivityRepository.getNotificationActivities(feed, type, filter, markAsRead, markAsSeen);
    }

    public <T extends BaseActivity> StreamResponse<NotificationActivity<T>> getNotificationActivities(BaseFeed feed, Class<T> type, FeedFilter filter, MarkedActivity markAsRead, MarkedActivity markAsSeen) throws IOException, StreamClientException {
        return this.streamActivityRepository.getNotificationActivities(feed, type, filter, markAsRead, markAsSeen);
    }

    public void shutdown() throws IOException {
    }

    private void fireAndForget(Request request) throws IOException, StreamClientException {
        LOG.debug("Invoking url: '{}", (Object)request.urlString());
        this.handleResponseCode(this.httpClient.newCall(request).execute());
    }

    private void handleResponseCode(Response response) throws StreamClientException, IOException {
        this.exceptionHandler.handleResponseCode(response);
    }

    private Request.Builder addAuthentication(BaseFeed feed, Request.Builder httpRequest) {
        return StreamRepoUtils.addAuthentication(feed, this.secretKey, httpRequest);
    }

    public static ObjectMapper getObjectMapper() {
        return OBJECT_MAPPER;
    }
}

